/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.nlogo.api.LogoException;
import org.nlogo.awt.Utils;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Slider;
import org.nlogo.window.SliderPainter;

public strictfp class SliderVerticalPainter
extends SliderPainter
implements MouseWheelListener {
    private final Slider slider;
    protected final Handle handle = new Handle();
    protected final Channel channel = new Channel();

    public SliderVerticalPainter(Slider slider) {
        this.slider = slider;
        if (slider.painter == null) {
            slider.setOpaque(true);
            slider.setLayout(null);
            slider.setBackground(InterfaceColors.SLIDER_BACKGROUND);
            Utils.adjustDefaultFont(slider);
        }
        slider.add(this.handle);
        slider.add(this.channel);
        slider.addMouseWheelListener(this);
    }

    public void dettach() {
        this.slider.remove(this.handle);
        this.slider.remove(this.channel);
        this.slider.removeMouseWheelListener(this);
    }

    public Dimension getMinimumSize() {
        return new Dimension(33, 92);
    }

    public Dimension getPreferredSize(Font font) {
        int height = 0;
        FontMetrics metrics = this.slider.getFontMetrics(font);
        height = this.maxValueWidth(metrics) + metrics.stringWidth(this.slider.name) + 2 + 1 + 23;
        return new Dimension(33, StrictMath.max(height, 150));
    }

    public Dimension getMaximumSize() {
        return new Dimension(33, 10000);
    }

    private int maxValueWidth(FontMetrics metrics) {
        int result = metrics.stringWidth(this.slider.valueString(this.slider.minimum));
        result = StrictMath.max(result, metrics.stringWidth(this.slider.valueString(this.slider.maximum)));
        result = StrictMath.max(result, metrics.stringWidth(this.slider.valueString(this.slider.minimum + this.slider.increment)));
        result = StrictMath.max(result, metrics.stringWidth(this.slider.valueString(this.slider.maximum - this.slider.increment)));
        return result;
    }

    public void setToolTipText(String text) {
        this.handle.setToolTipText(text);
        this.channel.setToolTipText(text);
    }

    public void doLayout() {
        float scaleFactor = this.slider.getBorder() != null ? (float)this.slider.getWidth() / 33.0f : (float)this.slider.getWidth() / 18.0f;
        this.handle.setSize((int)(14.0f * scaleFactor), (int)(8.0f * scaleFactor));
        this.handle.setLocation(2, this.handleYPos());
        this.channel.setBounds(3, 2, (int)(12.0f * scaleFactor), this.slider.getBounds().height - 1 - 2);
    }

    private int handleYPos() {
        return 7 - (int)StrictMath.round((this.slider.value - this.slider.maximum) / this.scaleFactor()) - this.handle.getBounds().height / 2;
    }

    public void handlePositionChanged(int y, boolean buttonRelease) {
        try {
            double newValue = this.slider.maximum - (double)y * this.scaleFactor();
            this.slider.value(this.slider.coerceValue(newValue), buttonRelease);
        }
        catch (LogoException e) {
            Exceptions.ignore(e);
        }
    }

    public void incrementClick(int y) {
        try {
            Rectangle thisRect = this.channel.getBounds();
            Rectangle handleRect = this.handle.getBounds();
            int center = handleRect.y + this.handle.getBounds().height / 2;
            if (y + thisRect.y > center) {
                this.slider.value(this.slider.coerceValue(this.slider.value - this.slider.increment));
            } else {
                this.slider.value(this.slider.coerceValue(this.slider.value + this.slider.increment));
            }
        }
        catch (LogoException e) {
            Exceptions.ignore(e);
        }
    }

    private double scaleFactor() {
        return (this.slider.maximum() - this.slider.minimum) / (double)(this.slider.getBounds().height - 1 - 2 - 6 - 6);
    }

    public void paintComponent(Graphics g) {
        int nameYOffset = 10;
        int padNameWidth = 3;
        Rectangle rect = this.slider.getBounds();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        if (this.slider.getBorder() != null) {
            g.setColor(this.slider.getForeground());
            String valueString = this.slider.valueString(this.slider.value);
            FontMetrics fontMetrics = g.getFontMetrics();
            int valueHeight = fontMetrics.stringWidth(valueString);
            String shortenedName = Utils.shortenStringToFit(this.slider.name, rect.height - nameYOffset - valueHeight - 2 - 6 - 2, fontMetrics);
            g.setColor(this.slider.getForeground());
            double rot = -StrictMath.toRadians(90.0);
            int y = rect.height - nameYOffset;
            int x = rect.width - fontMetrics.getMaxDescent() - padNameWidth;
            if (shortenedName.length() > 0) {
                TextLayout nameLayout = new TextLayout(shortenedName, g.getFont(), ((Graphics2D)g).getFontRenderContext());
                g.translate(x, y);
                ((Graphics2D)g).rotate(rot);
                nameLayout.draw((Graphics2D)g, 0.0f, 0.0f);
                ((Graphics2D)g).rotate(-rot);
                g.translate(-x, -y);
            }
            if (valueString.length() > 0) {
                TextLayout valueLayout = new TextLayout(valueString, g.getFont(), ((Graphics2D)g).getFontRenderContext());
                y = StrictMath.round(valueHeight + 2 + 6);
                g.translate(x, y);
                ((Graphics2D)g).rotate(rot);
                valueLayout.draw((Graphics2D)g, 0.0f, 0.0f);
                ((Graphics2D)g).rotate(-rot);
                g.translate(-x, -y);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        try {
            if (e.getWheelRotation() >= 1) {
                this.slider.value(this.slider.coerceValue(this.slider.value - this.slider.increment));
            } else {
                this.slider.value(this.slider.coerceValue(this.slider.value + this.slider.increment));
            }
        }
        catch (LogoException ex) {
            Exceptions.ignore(ex);
        }
    }

    private strictfp class Handle
    extends JPanel {
        Handle() {
            this.setBackground(InterfaceColors.SLIDER_HANDLE);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    new Events.InputBoxLoseFocusEvent().raise(Handle.this);
                }

                public void mouseReleased(MouseEvent e) {
                    Handle.this.changed(e.getY(), true);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent e) {
                    Handle.this.changed(e.getY(), false);
                }
            });
        }

        public Point getToolTipLocation(MouseEvent e) {
            Point loc = SliderVerticalPainter.this.slider.getToolTipLocation(e);
            if (loc != null) {
                loc = new Point(loc);
                loc.translate(-this.getX(), -this.getY());
            }
            return loc;
        }

        private void changed(int mouseY, boolean buttonReleased) {
            SliderVerticalPainter.this.handlePositionChanged(mouseY + this.getY() - this.getHeight() / 2, buttonReleased);
        }
    }

    private strictfp class Channel
    extends JComponent {
        Channel() {
            this.setOpaque(false);
            this.setBackground(Utils.mixColors(InterfaceColors.SLIDER_BACKGROUND, Color.BLACK, 0.5));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    new Events.InputBoxLoseFocusEvent().raise(Channel.this);
                    if (!e.isPopupTrigger() && Utils.button1Mask(e)) {
                        SliderVerticalPainter.this.incrementClick(e.getY());
                    }
                }
            });
        }

        public Point getToolTipLocation(MouseEvent e) {
            Point loc = SliderVerticalPainter.this.slider.getToolTipLocation(e);
            if (loc != null) {
                loc = new Point(loc);
                loc.translate(-this.getX(), -this.getY());
            }
            return loc;
        }

        public void paintComponent(Graphics g) {
            int x = 0;
            int y = 6;
            int height = this.getHeight() - 6 - 6;
            int width = this.getWidth();
            g.setColor(this.getBackground());
            g.fillRect(x, y, width, height);
            org.nlogo.swing.Utils.createWidgetBorder().paintBorder(this, g, x, y, width, height);
        }
    }
}

