/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.DynamicSliderConstraint;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Editable;
import org.nlogo.api.File;
import org.nlogo.api.PropertyDescription;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.Slider;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class SliderWidget
extends Slider
implements Editable,
Events.AfterLoadEvent.Handler,
Events.PeriodicUpdateEvent.Handler,
InterfaceGlobalWidget {
    public final MersenneTwisterFast random;
    private boolean eventOnReleaseOnly;
    protected Double defaultValue = 1.0;
    protected String minimumSnippet = "0";
    protected Procedure minimumProcedure = null;
    protected String maximumSnippet = "100";
    protected Procedure maximumProcedure = null;
    public String incrementSnippet = "1";
    public Procedure incrementProcedure = null;
    boolean nameChanged = false;

    @Override
    public String classDisplayName() {
        return "Slider";
    }

    public SliderWidget(boolean eventOnReleaseOnly, MersenneTwisterFast random) {
        this.setBorder(this.widgetBorder);
        this.eventOnReleaseOnly = eventOnReleaseOnly;
        this.random = random;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                new Events.InputBoxLoseFocusEvent().raise(SliderWidget.this);
            }
        });
    }

    @Override
    public List<PropertyDescription> propertySet() {
        ArrayList<PropertyDescription> result = new ArrayList<PropertyDescription>();
        result.add(new PropertyDescription("nameWrapper", "Global variable", "VariableName", 0, true));
        result.add(new PropertyDescription("minimumWrapper", "Minimum", "min, increment, and max may be numbers or reporters", "ReporterLine", 1, false));
        result.add(new PropertyDescription("incrementWrapper", "Increment", " ", "ReporterLine", -1, false));
        result.add(new PropertyDescription("maximumWrapper", "Maximum", " ", "ReporterLine", 0, false));
        result.add(new PropertyDescription("valueWrapper", "Value", "Double", -1, false));
        result.add(new PropertyDescription("units", "Units (optional)", "String", 0, false));
        result.add(new PropertyDescription("vertical", "vertical?", "Boolean", 0, false));
        return result;
    }

    public void minimumWrapper(String minimum) {
        this.minimumSnippet = minimum;
    }

    public void maximumWrapper(String maximum) {
        this.maximumSnippet = maximum;
    }

    @Override
    public Object valueObject() {
        return this.value();
    }

    @Override
    public void valueObject(Object value) {
        if (value instanceof Double) {
            this.value((Double)value, true);
        }
    }

    @Override
    public void value(Double value) {
        if (!value.equals(this.value()) || this.value() < this.minimum() || this.value() > this.effectiveMaximum()) {
            super.value(value);
            new Events.InterfaceGlobalEvent(this, false, false, true, false).raise(this);
        }
    }

    @Override
    public void value(Double value, boolean buttonRelease) {
        boolean valueChanged = false;
        if (!value.equals(this.value()) || this.value() < this.minimum() || this.value() > this.effectiveMaximum()) {
            super.value(value, buttonRelease);
            valueChanged = true;
            if (!this.eventOnReleaseOnly) {
                new Events.InterfaceGlobalEvent(this, false, false, true, buttonRelease).raise(this);
            }
        }
        if (this.eventOnReleaseOnly && buttonRelease) {
            new Events.InterfaceGlobalEvent(this, false, false, valueChanged, buttonRelease).raise(this);
        }
    }

    public void valueWrapper(double value) {
        this.value(value);
    }

    public void incrementWrapper(String increment) {
        this.incrementSnippet = increment;
    }

    @Override
    public void setConstraintError(String errorProperty, Exception ex) {
        super.setConstraintError(errorProperty, ex);
        if (!(this.error instanceof CompilerException) || !(ex instanceof SliderConstraint.RuntimeConstraintException)) {
            this.error = ex;
            this.errorProperty = errorProperty;
        }
        if (this.error == null) {
            if (this.constraint == null) {
                this.updateConstraints();
            }
            this.setForeground(Color.BLACK);
        } else {
            this.setForeground(Color.RED);
        }
    }

    @Override
    public void handle(Events.PeriodicUpdateEvent e) {
        new Events.InterfaceGlobalEvent(this, false, true, false, false).raise(this);
        if (this.constraint != null) {
            this.setSliderConstraint(this.constraint);
        }
    }

    @Override
    public void name(String name) {
        this.name(name, true);
    }

    private void name(String name, boolean sendEvent) {
        super.name(name);
        this.displayName(name);
        if (sendEvent) {
            new Events.InterfaceGlobalEvent(this, true, false, false, false).raise(this);
        }
    }

    @Override
    public void updateConstraints() {
        if (this.name().length() > 0) {
            if (this.constraint instanceof DynamicSliderConstraint) {
                new Events.AddSliderConstraintEvent(this, this.name, this.minimum.toString(), this.maximum.toString(), this.increment.toString(), this.defaultValue).raise(this);
            }
            if (this.minimumSnippet != null && this.maximumSnippet != null && this.incrementSnippet != null) {
                new Events.AddSliderConstraintEvent(this, this.name, this.minimumSnippet, this.maximumSnippet, this.incrementSnippet, this.defaultValue).raise(this);
            }
        }
    }

    @Override
    public boolean editFinished() {
        super.editFinished();
        this.name(this.name(), this.nameChanged);
        double value = StrictMath.max(this.value(), this.minimum);
        value = StrictMath.min(value, this.maximum);
        this.value(value);
        this.nameChanged = false;
        this.updateConstraints();
        return true;
    }

    @Override
    public void handle(Events.AfterLoadEvent e) {
        this.updateConstraints();
        this.valueWrapper(this.defaultValue);
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        String min = File.restoreLines(strings[7]);
        String max = File.restoreLines(strings[8]);
        double val = Double.parseDouble(strings[9]);
        String inc = File.restoreLines(strings[10]);
        if (strings.length > 12) {
            this.units(strings[12]);
            if (this.units.equals("NIL")) {
                this.units("");
            }
        }
        if (strings.length > 13 && strings[13].equals("VERTICAL")) {
            this.vertical(true);
        }
        this.name(File.restoreLines(strings[6]));
        this.minimumWrapper(min);
        this.maximumWrapper(max);
        this.minimumWrapper(min);
        this.incrementWrapper(inc);
        this.valueWrapper(val);
        this.defaultValue = val;
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        return this;
    }
}

