/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nlogo.api.Version;
import org.nlogo.awt.Utils;
import org.nlogo.log.Logger;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;

public strictfp class SpeedSliderPanel
extends JPanel
implements MouseListener,
ChangeListener,
Events.LoadBeginEvent.Handler {
    private final GUIWorkspace workspace;
    final SpeedSlider speedSlider;
    final JLabel normal = new SpeedLabel("normal speed");
    private final boolean labelsBelow;

    public SpeedSliderPanel(GUIWorkspace workspace, boolean labelsBelow) {
        this.workspace = workspace;
        this.labelsBelow = labelsBelow;
        this.speedSlider = new SpeedSlider((int)workspace.speed());
        this.speedSlider.setFocusable(false);
        this.speedSlider.addChangeListener(this);
        this.speedSlider.addMouseListener(this);
        this.speedSlider.setOpaque(false);
        Utils.adjustDefaultFont(this.normal);
        this.setOpaque(false);
        if (labelsBelow) {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            c.gridwidth = 0;
            this.add((Component)this.speedSlider, c);
            c.gridwidth = 1;
            c.anchor = 10;
            this.add((Component)this.normal, c);
        } else {
            BorderLayout layout = new BorderLayout();
            layout.setVgap(0);
            this.setLayout(layout);
            this.add((Component)this.speedSlider, "Center");
            this.add((Component)this.normal, "East");
        }
        this.enableLabels(0);
    }

    public void setEnabled(boolean enabled) {
        this.speedSlider.setEnabled(enabled);
        if (enabled) {
            this.stateChanged(null);
        } else {
            this.normal.setText(" ");
        }
    }

    public void stateChanged(ChangeEvent e) {
        int value = this.speedSlider.getValue();
        value = value < -10 ? (value += 10) : (value > 10 ? (value -= 10) : 0);
        this.workspace.speed(value / 2);
        if (Version.isLoggingEnabled()) {
            Logger.logSpeedSlider(value);
        }
        this.enableLabels(value);
        this.workspace.updateManager.nudgeSleeper();
    }

    void enableLabels(int value) {
        if (value == 0) {
            if (this.labelsBelow) {
                this.normal.setText("      normal speed");
            } else {
                this.normal.setText("normal speed");
            }
        } else if (value < 0) {
            if (this.labelsBelow) {
                this.normal.setText("slower                         ");
            } else {
                this.normal.setText("slower");
            }
        } else if (this.labelsBelow) {
            this.normal.setText("                         faster");
        } else {
            this.normal.setText("faster");
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        int value = this.speedSlider.getValue();
        if (value <= 10 && value > 0 || value >= -10 && value < 0) {
            this.speedSlider.setValue(0);
        }
    }

    public void handle(Events.LoadBeginEvent e) {
        this.speedSlider.reset();
    }

    public boolean isEnabled() {
        return this.speedSlider.isEnabled();
    }

    private strictfp class SpeedLabel
    extends JLabel {
        SpeedLabel(String label) {
            super(label);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            d.width = !SpeedSliderPanel.this.labelsBelow ? StrictMath.max(d.width, fontMetrics.stringWidth("normal speed")) : StrictMath.max(d.width, fontMetrics.stringWidth("                         faster") + 10);
            return d;
        }
    }

    private strictfp class SpeedSlider
    extends JSlider
    implements MouseWheelListener {
        SpeedSlider(int defaultSpeed) {
            super(-110, 112, defaultSpeed);
            this.setExtent(1);
            this.setToolTipText("Adjust speed of model");
            this.addMouseWheelListener(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(180, super.getPreferredSize().height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, super.getPreferredSize().height);
        }

        void reset() {
            this.setValue(0);
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            this.setValue(this.getValue() - e.getWheelRotation());
        }

        public void paint(Graphics g) {
            Rectangle bounds = this.getBounds();
            int x = bounds.x + bounds.width / 2 - 1;
            g.setColor(Color.gray);
            g.drawLine(x, bounds.y + bounds.height * 3 / 4, x, bounds.y + bounds.height);
            super.paint(g);
        }
    }
}

