/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Perspective;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.Shape;
import org.nlogo.api.ViewSettings;
import org.nlogo.awt.ImageSelection;
import org.nlogo.awt.Utils;
import org.nlogo.shape.VectorShape;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.LocalViewInterface;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.SyntaxColors;
import org.nlogo.window.ViewMouseHandler;

public strictfp class View
extends JComponent
implements ActionListener,
ViewSettings,
Events.CompiledEvent.Handler,
Events.IconifiedEvent.Handler,
Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler,
LocalViewInterface {
    protected final GUIWorkspace workspace;
    final ViewMouseHandler mouser;
    public RendererInterface renderer;
    private boolean paintingImmediately = false;
    private boolean framesSkipped = false;
    private int fontSize = 13;
    private final Runnable paintRunnable = new Runnable(){

        public void run() {
            View.this.paintingImmediately = true;
            View.this.paintImmediately();
            View.this.paintingImmediately = false;
        }
    };
    boolean iconified = false;
    private Image offscreenImage = null;
    private Graphics2D gOff = null;
    private boolean dirty = true;
    public int frameCount = 0;
    private boolean frozen = false;
    protected double patchSize = 13.0;
    private double zoom = 0.0;
    protected double viewWidth;
    protected double viewHeight;
    public boolean renderPerspective = true;

    public View(GUIWorkspace workspace) {
        this.workspace = workspace;
        this.setOpaque(true);
        this.renderer = workspace.newRenderer();
        this.mouser = new ViewMouseHandler(this, workspace.world, this);
        this.addMouseListener(this.mouser);
        this.addMouseMotionListener(this.mouser);
        workspace.viewManager.add(this);
    }

    public boolean isHeadless() {
        return this.workspace.isHeadless();
    }

    public void displaySwitch(boolean on) {
        this.workspace.viewWidget.displaySwitch.setOn(on);
    }

    public boolean displaySwitch() {
        return this.workspace.viewWidget.displaySwitch.isSelected();
    }

    public void incrementalUpdateFromEventThread() {
        this.paintRunnable.run();
    }

    public void dirty() {
        this.dirty = true;
    }

    public void framesSkipped() {
        this.framesSkipped = true;
    }

    public int fontSize() {
        return this.fontSize;
    }

    public void resetMouseCors() {
        this.mouser.resetMouseCors();
    }

    public double mouseXCor() {
        return this.mouser.mouseXCor();
    }

    public double mouseYCor() {
        return this.mouser.mouseYCor();
    }

    public boolean mouseDown() {
        return this.mouser.mouseDown();
    }

    public boolean mouseInside() {
        return this.mouser.mouseInside();
    }

    public void mouseDown(boolean mouseDown) {
        this.mouser.mouseDown(mouseDown);
    }

    public boolean isDead() {
        return false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.workspace.world.worldWidth(), this.workspace.world.worldHeight());
    }

    public Dimension getPreferredSize() {
        int width = (int)(this.viewWidth * this.patchSize());
        int height = (int)(this.viewHeight * this.patchSize());
        return new Dimension(width, height);
    }

    public void handle(Events.IconifiedEvent e) {
        if (e.frame == Utils.getFrame(this)) {
            this.iconified = e.iconified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beClean() {
        if (this.dirty && this.getWidth() > 0 && this.getHeight() > 0) {
            if (this.workspace.jobManager.isInterrupted()) {
                return false;
            }
            if (this.offscreenImage == null) {
                this.offscreenImage = this.createImage(this.getWidth(), this.getHeight());
                if (this.offscreenImage != null) {
                    this.gOff = (Graphics2D)this.offscreenImage.getGraphics();
                    this.gOff.setFont(this.getFont());
                }
            }
            if (this.gOff != null) {
                World world = this.workspace.world;
                synchronized (world) {
                    this.renderer.paint(this.gOff, (ViewSettings)this);
                }
            }
            this.dirty = false;
        }
        return true;
    }

    public void setBounds(int x, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (width != bounds.width || height != bounds.height || x != bounds.x || y != bounds.y) {
            super.setBounds(x, y, width, height);
            this.discardOffscreenImage();
        }
    }

    public void discardOffscreenImage() {
        this.offscreenImage = null;
        this.gOff = null;
        this.dirty = true;
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void paint(Graphics g) {
        if (!this.isDead()) {
            super.paint(g);
            this.workspace.donePainting();
            if (this.workspace.world.observer().perspective() == Perspective.FOLLOW || this.workspace.world.observer().perspective() == Perspective.RIDE) {
                this.mouser.updateMouseCors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        ++this.frameCount;
        if (this.frozen || !this.workspace.world.displayOn()) {
            if (this.dirty) {
                g.setColor(InterfaceColors.GRAPHICS_BACKGROUND);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g.drawImage(this.offscreenImage, 0, 0, null);
            }
            this.framesSkipped = false;
        } else if (this.paintingImmediately) {
            World world = this.workspace.world;
            synchronized (world) {
                this.renderer.paint((Graphics2D)g, (ViewSettings)this);
            }
            this.framesSkipped = false;
        } else if (this.beClean()) {
            g.drawImage(this.offscreenImage, 0, 0, null);
            this.framesSkipped = false;
        } else {
            this.framesSkipped = true;
        }
    }

    public void paintingImmediately(boolean paintingImmediately) {
        this.paintingImmediately = paintingImmediately;
    }

    public void paintImmediately(boolean force) {
        if (this.viewIsVisible() && (this.framesSkipped || force)) {
            this.paintingImmediately(true);
            this.paintImmediately();
            this.paintingImmediately(false);
        }
    }

    public boolean viewIsVisible() {
        return !this.iconified && this.isShowing();
    }

    public void paintImmediately() {
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage exportView() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setFont(this.getFont());
        World world = this.workspace.world;
        synchronized (world) {
            this.renderer.paint(graphics, (ViewSettings)this);
        }
        return image;
    }

    void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            if (this.workspace.world.displayOn()) {
                this.beClean();
            }
        }
    }

    void thaw() {
        if (this.frozen) {
            this.frozen = false;
            this.repaint();
        }
    }

    public void shapeChanged(Shape shape) {
        this.dirty = true;
        new Events.DirtyEvent().raise(this);
        this.renderer.resetCache(this.patchSize());
        this.repaint();
    }

    public void handle(Events.LoadBeginEvent e) {
        this.setVisible(false);
        this.patchSize = 13.0;
        this.zoom = 0.0;
        this.renderer = this.workspace.newRenderer();
    }

    public void handle(Events.LoadEndEvent e) {
        this.renderer.changeTopology(this.workspace.world.wrappingAllowedInX(), this.workspace.world.wrappingAllowedInY());
        this.setVisible(true);
    }

    public void handle(Events.CompiledEvent e) {
        if (e.sourceOwner instanceof ProceduresInterface) {
            this.renderer.resetCache(this.patchSize());
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.dirty = true;
            this.beClean();
        }
    }

    void setTrueFontSize(int size) {
        this.fontSize = size;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.offscreenImage = null;
        this.discardOffscreenImage();
    }

    public void applyNewFontSize(int newFontSize, int zoom) {
        Font font = this.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), newFontSize + zoom);
        this.setTrueFontSize(newFontSize);
        this.setFont(newFont);
        this.dirty();
        this.repaint();
    }

    public Component getExportWindowFrame() {
        return this.workspace.viewWidget;
    }

    public double patchSize() {
        return this.patchSize + this.zoom;
    }

    public void visualPatchSize(double patchSize) {
        double oldZoom = this.zoom;
        this.zoom = patchSize - this.patchSize;
        if (this.zoom != oldZoom) {
            this.renderer.resetCache(this.patchSize());
        }
    }

    public double viewWidth() {
        return this.viewWidth;
    }

    public double viewHeight() {
        return this.viewHeight;
    }

    public void setSize(int worldWidth, int worldHeight, double patchSize) {
        this.patchSize = patchSize;
        this.viewWidth = worldWidth;
        this.viewHeight = worldHeight;
        this.renderer.resetCache(this.patchSize());
    }

    public Perspective perspective() {
        return this.workspace.world.observer().perspective();
    }

    public boolean drawSpotlight() {
        return true;
    }

    public double viewOffsetX() {
        return this.workspace.world.observer().followOffsetX();
    }

    public double viewOffsetY() {
        return this.workspace.world.observer().followOffsetY();
    }

    public boolean renderPerspective() {
        return this.renderPerspective;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point populateContextMenu(JPopupMenu menu, Point p, Component source2) {
        JMenuItem copyItem = new JMenuItem("Copy View");
        copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(View.this.exportView()), null);
            }
        });
        menu.add(copyItem);
        JMenuItem exportItem = new JMenuItem("Export View...");
        exportItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                View.this.workspace.doExportView(View.this);
            }
        });
        menu.add(exportItem);
        if (!this.workspace.world.observer().atHome2D()) {
            menu.add(new JPopupMenu.Separator());
            JMenuItem resetItem = new JMenuItem("<html>" + Utils.colorize("reset-perspective", SyntaxColors.COMMAND_COLOR));
            resetItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    View.this.workspace.world.observer().resetPerspective();
                    View.this.workspace.viewManager.incrementalUpdateFromEventThread();
                }
            });
            menu.add(resetItem);
        }
        p = new Point(p);
        this.mouser.translatePointToXCorYCor(p);
        World world = this.workspace.world;
        synchronized (world) {
            double xcor = this.mouser.translatePointToUnboundedX(p.x);
            double ycor = this.mouser.translatePointToUnboundedY(p.y);
            Patch patch = null;
            try {
                patch = this.workspace.world.getPatchAt(xcor, ycor);
                menu.add(new JPopupMenu.Separator());
                menu.add(new AgentMenuItem(patch, AgentMenuType.INSPECT, "inspect", false));
            }
            catch (AgentException e) {
                Exceptions.ignore(e);
            }
            boolean linksAdded = false;
            AgentSet.Iterator links = this.workspace.world.links().iterator();
            while (links.hasNext()) {
                Link link = (Link)links.next();
                if (link.hidden() || !(this.workspace.world.protractor().distance(link, xcor, ycor, true) < link.lineThickness() + 0.5)) continue;
                if (!linksAdded) {
                    menu.add(new JPopupMenu.Separator());
                    linksAdded = true;
                }
                menu.add(new AgentMenuItem(link, AgentMenuType.INSPECT, "inspect", false));
            }
            boolean turtlesAdded = false;
            AgentSet.Iterator turtles = this.workspace.world.turtles().iterator();
            while (turtles.hasNext()) {
                VectorShape shape;
                Turtle turtle2 = (Turtle)turtles.next();
                if (turtle2.hidden()) continue;
                double offset = turtle2.size() * 0.5;
                if (offset * this.workspace.world.patchSize() < 3.0) {
                    offset += 3.0 / this.workspace.world.patchSize();
                }
                if ((shape = (VectorShape)this.workspace.world.turtleShapeList().shape(turtle2.shape())).isRotatable() && !turtle2.hidden()) {
                    double dist = this.workspace.world.protractor().distance(turtle2, xcor, ycor, true);
                    if (!(dist <= offset)) continue;
                    if (!turtlesAdded) {
                        menu.add(new JPopupMenu.Separator());
                        turtlesAdded = true;
                    }
                    this.addTurtleToContextMenu(menu, turtle2);
                    continue;
                }
                double xCor = turtle2.xcor();
                double yCor = turtle2.ycor();
                double xMouse = xcor;
                double yMouse = ycor;
                if (this.workspace.world.wrappingAllowedInX()) {
                    double x = xCor > xMouse ? xMouse + (double)this.workspace.world.worldWidth() : xMouse - (double)this.workspace.world.worldWidth();
                    double d = xMouse = StrictMath.abs(xMouse - xCor) < StrictMath.abs(x - xCor) ? xMouse : x;
                }
                if (this.workspace.world.wrappingAllowedInY()) {
                    double y = yCor > yMouse ? yMouse + (double)this.workspace.world.worldHeight() : yMouse - (double)this.workspace.world.worldHeight();
                    double d = yMouse = StrictMath.abs(yMouse - yCor) < StrictMath.abs(y - yCor) ? yMouse : y;
                }
                if (!(xMouse >= xCor - offset) || !(xMouse <= xCor + offset) || !(yMouse >= yCor - offset) || !(yMouse <= yCor + offset)) continue;
                if (!turtlesAdded) {
                    menu.add(new JPopupMenu.Separator());
                    turtlesAdded = true;
                }
                this.addTurtleToContextMenu(menu, turtle2);
            }
            int x = 0;
            int y = 0;
            if (patch != null) {
                x = (int)StrictMath.round(this.renderer.graphicsX(patch.pxcor + 1, this.patchSize(), this.viewOffsetX()));
                y = (int)StrictMath.round(this.renderer.graphicsY(patch.pycor - 1, this.patchSize(), this.viewOffsetY()));
                p.x += StrictMath.min(x - p.x, 15);
                p.y += StrictMath.min(y - p.y, 15);
            }
        }
        return p;
    }

    private void addTurtleToContextMenu(JPopupMenu menu, Turtle turtle2) {
        AgentMenu submenu = new AgentMenu(turtle2);
        submenu.add(new AgentMenuItem(turtle2, AgentMenuType.INSPECT, "inspect", true));
        submenu.add(new JPopupMenu.Separator());
        submenu.add(new AgentMenuItem(turtle2, AgentMenuType.WATCH, "watch", true));
        submenu.add(new AgentMenuItem(turtle2, AgentMenuType.FOLLOW, "follow", true));
        menu.add(submenu);
    }

    public void actionPerformed(ActionEvent e) {
        AgentMenuItem item = (AgentMenuItem)e.getSource();
        switch (item.type) {
            case INSPECT: {
                this.workspace.inspectAgent(item.agent.getAgentClass(), item.agent, 3.0);
                return;
            }
            case FOLLOW: {
                this.workspace.world.observer().setPerspective(Perspective.FOLLOW, item.agent);
                int distance = (int)((Turtle)item.agent).size() * 5;
                this.workspace.world.observer().followDistance(StrictMath.max(1, StrictMath.min(distance, 100)));
                break;
            }
            case WATCH: {
                this.workspace.world.observer().home();
                this.workspace.world.observer().setPerspective(Perspective.WATCH, item.agent);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.workspace.viewManager.incrementalUpdateFromEventThread();
    }

    private strictfp class AgentMenu
    extends JMenu {
        Agent agent;

        AgentMenu(Agent agent) {
            super(agent.toString());
            this.agent = agent;
        }

        public void menuSelectionChanged(boolean isIncluded) {
            super.menuSelectionChanged(isIncluded);
            View.this.renderer.outlineAgent(isIncluded ? this.agent : null);
            View.this.workspace.viewManager.incrementalUpdateFromEventThread();
        }
    }

    private strictfp class AgentMenuItem
    extends JMenuItem {
        Agent agent;
        AgentMenuType type;
        boolean submenu;

        AgentMenuItem(Agent agent, AgentMenuType type, String caption, boolean submenu) {
            super("<html>" + Utils.colorize(caption, SyntaxColors.COMMAND_COLOR) + " " + Utils.colorize(agent.classDisplayName(), SyntaxColors.REPORTER_COLOR) + Utils.colorize(agent.toString().substring(agent.classDisplayName().length()), SyntaxColors.CONSTANT_COLOR));
            this.submenu = false;
            this.agent = agent;
            this.type = type;
            this.addActionListener(View.this);
            this.submenu = submenu;
        }

        public void menuSelectionChanged(boolean isIncluded) {
            super.menuSelectionChanged(isIncluded);
            if (!this.submenu) {
                View.this.renderer.outlineAgent(isIncluded ? this.agent : null);
                View.this.workspace.viewManager.incrementalUpdateFromEventThread();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    strictfp static enum AgentMenuType {
        INSPECT,
        FOLLOW,
        WATCH;

    }
}

