/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Editable;
import org.nlogo.api.PropertyDescription;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.nvm.Workspace;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.OriginConfiguration;
import org.nlogo.window.ViewWidget;
import org.nlogo.workspace.WorldLoaderInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class WorldViewSettings
implements Editable,
WorldPropertiesInterface,
WorldLoaderInterface {
    protected final GUIWorkspace workspace;
    protected final ViewWidget gWidget;
    protected List<PropertyDescription> dimensionProperties;
    protected List<PropertyDescription> wrappingProperties;
    protected List<PropertyDescription> viewProperties;
    protected List<PropertyDescription> modelProperties;
    protected List<OriginConfiguration> cornerChoices;
    protected List<OriginConfiguration> edgeChoices;
    protected List<OriginConfiguration> originConfigurations;
    protected List<PropertyDescription> propertySet = null;
    protected boolean wrappingChanged = false;
    protected boolean edgesChanged = false;
    protected boolean patchSizeChanged = false;
    protected boolean fontSizeChanged = false;
    protected double newPatchSize;
    protected int newMinX;
    protected int newMaxX;
    protected int newMinY;
    protected int newMaxY;
    protected boolean newWrapX;
    protected boolean newWrapY;
    protected int newFontSize;
    protected CompilerException error = null;
    protected String errorProperty = null;

    @Override
    public String classDisplayName() {
        return "Model Settings";
    }

    WorldViewSettings(GUIWorkspace workspace, ViewWidget gw) {
        this.workspace = workspace;
        this.gWidget = gw;
        this.addProperties();
    }

    public abstract void resizeWithProgress(boolean var1);

    public abstract void addWrappingProperties();

    public abstract void addDimensionProperties();

    protected void addProperties() {
        this.propertySet(new ArrayList<PropertyDescription>());
        this.dimensionProperties = new ArrayList<PropertyDescription>();
        this.addDimensionProperties();
        this.wrappingProperties = new ArrayList<PropertyDescription>();
        this.addWrappingProperties();
        this.viewProperties = new ArrayList<PropertyDescription>();
        this.addViewProperties();
        this.modelProperties = new ArrayList<PropertyDescription>();
        this.addModelProperties();
        this.cornerChoices = new ArrayList<OriginConfiguration>();
        this.addCornerChoices();
        this.edgeChoices = new ArrayList<OriginConfiguration>();
        this.addEdgeChoices();
        this.originConfigurations = new ArrayList<OriginConfiguration>();
        this.addOriginConfigurations();
    }

    public void addViewProperties() {
        this.viewProperties.add(new PropertyDescription("patchSize", "Patch size", "measured in pixels", "Double", -1, false));
        this.viewProperties.add(new PropertyDescription("fontSize", "Font size", "of labels on agents", "Integer", 0, false));
    }

    public void addModelProperties() {
        this.modelProperties.add(new PropertyDescription("showTickCounter", "Show tick counter", "Boolean", 0, false));
        this.modelProperties.add(new PropertyDescription("tickCounterLabel", "Tick counter label", "String", 0, false));
    }

    public void refreshViewProperties(boolean threedView) {
        this.viewProperties.clear();
        this.addViewProperties();
        if (threedView) {
            this.viewProperties.add(new PropertyDescription("smooth", "Smooth edges (slower)", "only affects 3D view", "Boolean", 0, false));
            this.viewProperties.add(new PropertyDescription("wireframe", "Show wire frame", "only affects 3D view", "Boolean", 0, false));
            this.viewProperties.add(new PropertyDescription("dualView", "Update 2D view", "Boolean", 0, false));
        }
    }

    public void addCornerChoices() {
        this.cornerChoices.add(new OriginConfiguration("Bottom Left", new boolean[]{false, true, false, true}, new boolean[]{true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration("Top Left", new boolean[]{false, true, true, false}, new boolean[]{true, false, false, true}));
        this.cornerChoices.add(new OriginConfiguration("Top Right", new boolean[]{true, false, true, false}, new boolean[]{false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration("Bottom Right", new boolean[]{true, false, false, true}, new boolean[]{false, true, true, false}));
    }

    public void addEdgeChoices() {
        this.edgeChoices.add(new OriginConfiguration("Bottom", new boolean[]{true, true, false, true}, new boolean[]{false, false, true, false}));
        this.edgeChoices.add(new OriginConfiguration("Top", new boolean[]{true, true, true, false}, new boolean[]{false, false, false, true}));
        this.edgeChoices.add(new OriginConfiguration("Right", new boolean[]{true, false, true, true}, new boolean[]{false, true, false, false}));
        this.edgeChoices.add(new OriginConfiguration("Left", new boolean[]{false, true, true, true}, new boolean[]{true, false, false, false}));
    }

    public void addOriginConfigurations() {
        this.originConfigurations.add(new OriginConfiguration("Center", new boolean[]{false, true, false, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration("Corner", new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration("Edge", new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration("Custom", new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
    }

    public Object load(String[] strings, String version) {
        this.workspace.loadWorld(strings, version, this);
        this.workspace.world.tickCounter.reset();
        this.workspace.world.clearPatches();
        this.workspace.world.displayOn(true);
        return this;
    }

    @Override
    public List<PropertyDescription> propertySet() {
        return this.propertySet;
    }

    public void propertySet(List<PropertyDescription> propertySet) {
        this.propertySet = propertySet;
    }

    public void patchSize(double size) {
        this.newPatchSize = size;
        this.patchSizeChanged = this.patchSizeChanged || size != this.patchSize();
    }

    public double patchSize() {
        return this.workspace.world.patchSize();
    }

    @Override
    public void updateMode(Workspace.UpdateMode updateMode) {
        this.workspace.updateMode(updateMode);
    }

    @Override
    public int fontSize() {
        return this.gWidget.view.fontSize();
    }

    @Override
    public void fontSize(int newFontSize) {
        this.newFontSize = newFontSize;
        if (newFontSize != this.fontSize()) {
            this.fontSizeChanged = true;
        }
        this.workspace.viewManager.applyNewFontSize(newFontSize);
    }

    @Override
    public void showTickCounter(boolean visible) {
        this.workspace.viewWidget.showTickCounter(visible);
    }

    @Override
    public void tickCounterLabel(String label) {
        this.workspace.viewWidget.tickCounterLabel(label);
    }

    @Override
    public void changeTopology(boolean wrapX, boolean wrapY) {
        this.workspace.changeTopology(wrapX, wrapY);
    }

    @Override
    public void clearTurtles() {
        this.workspace.world.clearTurtles();
    }

    @Override
    public Exception error() {
        return this.error;
    }

    @Override
    public String errorProperty() {
        return this.errorProperty;
    }

    @Override
    public void setSize(int x, int y) {
        this.gWidget.setSize(x, y);
    }

    @Override
    public int getMinimumWidth() {
        return this.gWidget.getMinimumWidth();
    }

    @Override
    public int insetWidth() {
        return this.gWidget.insetWidth();
    }

    @Override
    public double computePatchSize(int width, int numPatches) {
        return this.gWidget.computePatchSize(width, numPatches);
    }

    @Override
    public int calculateHeight(int worldHeight, double patchSize) {
        return this.gWidget.calculateHeight(worldHeight, patchSize);
    }

    @Override
    public int calculateWidth(int worldWidth, double patchSize) {
        return this.gWidget.calculateWidth(worldWidth, patchSize);
    }

    @Override
    public void setDimensions(WorldDimensions d, double patchSize) {
        this.workspace.world.patchSize(patchSize);
        this.setDimensions(d);
        this.patchSize(patchSize);
        this.gWidget.resetSize();
    }

    public void setDimensions(WorldDimensions d) {
        this.setDimensions(d.minPxcor, d.maxPxcor, d.minPycor, d.maxPycor);
    }

    public void setDimensions(int minPxcor, int maxPxcor, int minPycor, int maxPycor) {
        this.newMinX = minPxcor;
        this.newMaxX = maxPxcor;
        this.newMinY = minPycor;
        this.newMaxY = maxPycor;
        if (minPxcor != this.workspace.world.minPxcor() || maxPxcor != this.workspace.world.maxPxcor() || minPycor != this.workspace.world.minPycor() || maxPycor != this.workspace.world.maxPycor()) {
            this.prepareForWorldResize();
            this.workspace.world.createPatches(minPxcor, maxPxcor, minPycor, maxPycor);
            this.finishWorldResize();
        }
    }

    void prepareForWorldResize() {
        this.workspace.jobManager.haltNonObserverJobs();
        this.workspace.world.clearTurtles();
        this.workspace.world.clearLinks();
    }

    void finishWorldResize() {
        this.workspace.patchesCreatedNotify();
        this.gWidget.resetSize();
        this.workspace.clearDrawing();
    }

    @Override
    public int sourceOffset() {
        throw new IllegalStateException();
    }
}

