/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Thunk;
import org.nlogo.agent.Turtle;
import org.nlogo.api.CompilerException;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.Procedure;
import org.nlogo.workspace.AbstractWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Evaluator {
    private final AbstractWorkspace workspace;

    Evaluator(AbstractWorkspace workspace) {
        this.workspace = workspace;
    }

    void evaluateCommands(String source2) throws CompilerException {
        this.evaluateCommands(source2, this.workspace.world.observers(), true);
    }

    void evaluateCommands(String source2, Agent agent, boolean waitForCompletion) throws CompilerException {
        ArrayAgentSet agentset = new ArrayAgentSet(agent.getAgentClass(), 1, false, this.workspace.world);
        ((AgentSet)agentset).add(agent);
        this.evaluateCommands(source2, agentset, waitForCompletion);
    }

    void evaluateCommands(String source2, Class<? extends Agent> agentType, boolean waitForCompletion) throws CompilerException {
        this.evaluateCommands(source2, this.workspace.world.agentClassToAgentSet(agentType), waitForCompletion);
    }

    void evaluateCommands(String source2, AgentSet agentSet, boolean waitForCompletion) throws CompilerException {
        Procedure procedure = this.invokeCompiler(source2, true, agentSet.type());
        Job job = this.workspace.jobManager.makeConcurrentJob(null, agentSet, procedure);
        this.workspace.jobManager.addJob(job, waitForCompletion);
    }

    Object evaluateReporter(String source2, Agent agent) throws CompilerException {
        Procedure procedure = this.invokeCompiler(source2, false, agent.getAgentClass());
        ArrayAgentSet agentset = new ArrayAgentSet(agent.getAgentClass(), 1, false, this.workspace.world);
        ((AgentSet)agentset).add(agent);
        return this.workspace.jobManager.addReporterJobAndWait(agentset, procedure);
    }

    Procedure compileCommands(String source2, Class<? extends Agent> agentClass) throws CompilerException {
        return this.invokeCompiler(source2, true, agentClass);
    }

    Procedure compileReporter(String string) throws CompilerException {
        return this.invokeCompiler(string, false, Observer.class);
    }

    boolean runCompiledCommands(Procedure procedure) {
        Job job = this.workspace.jobManager.makeConcurrentJob(null, this.workspace.world.observers(), procedure);
        this.workspace.jobManager.addJob(job, true);
        return job.stopping;
    }

    Object runCompiledReporter(Procedure procedure) {
        return this.workspace.jobManager.addReporterJobAndWait(this.workspace.world.observers(), procedure);
    }

    Procedure compileForRun(String source2, Context context, boolean reporter) throws CompilerException {
        return this.invokeCompilerForRun(source2, context.agent.getAgentClass(), context.activation.procedure, reporter);
    }

    Thunk makeThunk(String source2, Agent agent, JobOwner owner) throws CompilerException {
        return new MyThunk(source2, agent, owner);
    }

    private Procedure invokeCompiler(String source2, boolean commands, Class<? extends Agent> agentClass) throws CompilerException {
        source2 = Evaluator.getHeader(agentClass, commands) + source2 + Evaluator.getFooter(commands);
        Procedure procedure = this.workspace.compiler().compileMoreCode(source2, this.workspace.world.program(), this.workspace.getProcedures(), this.workspace.getExtensionManager());
        procedure.init(this.workspace);
        return procedure;
    }

    private static String getHeader(Class<? extends Agent> clazz, boolean bl) {
        String string = clazz == Observer.class ? "__observercode" : (clazz == Turtle.class ? "__turtlecode" : (clazz == Link.class ? "__linkcode" : "__patchcode"));
        if (bl) {
            return "to __evaluator [] " + string + " ";
        }
        return "to-report __evaluator [] " + string + " report ( ";
    }

    private static String getFooter(boolean commands) {
        return commands ? "\n__done end" : "\n) __done end";
    }

    private Procedure invokeCompilerForRun(String string, Class<? extends Agent> clazz, Procedure procedure, boolean bl) throws CompilerException {
        List<Object> list;
        List<Object> list2 = list = procedure == null ? new ArrayList() : procedure.args;
        String string2 = clazz == Observer.class ? "__observercode" : (clazz == Turtle.class ? "__turtlecode" : (clazz == Link.class ? "__linkcode" : "__patchcode"));
        string = bl ? "to-report __runresult " + list.toString().replace(',', ' ') + " " + string2 + " report ( " + string + "\n) __done end" : "to __run " + list.toString().replace(',', ' ') + " " + string2 + " " + string + "\nend";
        Procedure procedure2 = this.workspace.compiler().compileMoreCode(string, this.workspace.world.program(), this.workspace.getProcedures(), this.workspace.getExtensionManager());
        procedure2.init(this.workspace);
        return procedure2;
    }

    public boolean isConstant(String string) {
        boolean result = true;
        try {
            this.workspace.compiler().readFromString(string, this.workspace.world.program().is3D);
        }
        catch (CompilerException e) {
            result = false;
        }
        return result;
    }

    public Object readFromString(String string) throws CompilerException {
        return this.workspace.compiler().readFromString(string, this.workspace.world, this.workspace.getExtensionManager(), this.workspace.world.program().is3D);
    }

    private strictfp final class MyThunk
    implements Thunk {
        private final AgentSet agentset;
        private final Procedure procedure;
        private final JobOwner owner;

        public MyThunk(String source2, Agent agent, JobOwner owner) throws CompilerException {
            this.agentset = new ArrayAgentSet(agent.getAgentClass(), 1, false, ((Evaluator)Evaluator.this).workspace.world);
            this.agentset.add(agent);
            this.procedure = Evaluator.this.invokeCompiler(source2, false, this.agentset.type());
            this.owner = owner;
        }

        public Object call() throws LogoException {
            return ((Evaluator)Evaluator.this).workspace.jobManager.callReporterProcedure(this.owner, this.agentset, this.procedure);
        }
    }
}

