/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import org.nlogo.api.Version;
import org.nlogo.api.WorldDimensions;
import org.nlogo.nvm.Workspace;
import org.nlogo.workspace.WorldLoaderInterface;

public strictfp class WorldLoader {
    int tickCounterIndex = 23;
    int tickCounterLabelIndex = 24;
    int updateModeIndex = 21;

    public void load(String[] strings, String version, WorldLoaderInterface worldInterface) {
        WorldDimensions d = this.getWorldDimensions(strings, version);
        if (strings.length > this.tickCounterLabelIndex) {
            worldInterface.tickCounterLabel(strings[this.tickCounterLabelIndex]);
        } else {
            worldInterface.tickCounterLabel("ticks");
        }
        if (strings.length > this.tickCounterIndex) {
            worldInterface.showTickCounter(1 == Integer.parseInt(strings[this.tickCounterIndex]));
        } else {
            worldInterface.showTickCounter(true);
        }
        double patchSize = Double.parseDouble(strings[7]);
        int width = this.getWidth(worldInterface, d, patchSize, strings);
        patchSize = this.adjustPatchSize(worldInterface, d, patchSize, strings);
        int height = this.getHeight(worldInterface, d, patchSize, strings);
        worldInterface.setDimensions(d, patchSize);
        worldInterface.clearTurtles();
        if (strings.length > 9) {
            worldInterface.fontSize(Integer.parseInt(strings[9]));
        }
        boolean wrapX = true;
        boolean wrapY = true;
        if (strings.length > 15 && !Version.olderThan31pre1(version)) {
            wrapX = 0 != Integer.parseInt(strings[14]);
            wrapY = 0 != Integer.parseInt(strings[15]);
        }
        worldInterface.changeTopology(wrapX, wrapY);
        if (strings.length > this.updateModeIndex) {
            worldInterface.updateMode(Workspace.UpdateMode.load(Integer.parseInt(strings[this.updateModeIndex])));
        } else {
            worldInterface.updateMode(Workspace.UpdateMode.CONTINUOUS);
        }
        worldInterface.setSize(width, height);
    }

    WorldDimensions getWorldDimensions(String[] strings, String version) {
        int maxx = Integer.parseInt(strings[5]);
        int maxy = Integer.parseInt(strings[6]);
        int minx = -1;
        int miny = -1;
        if (maxx != -1 && maxy != -1) {
            minx = -maxx;
            miny = -maxy;
        } else if (strings.length > 20) {
            minx = Integer.parseInt(strings[17]);
            maxx = Integer.parseInt(strings[18]);
            miny = Integer.parseInt(strings[19]);
            maxy = Integer.parseInt(strings[20]);
        }
        return new WorldDimensions(minx, maxx, miny, maxy);
    }

    int getWidth(WorldLoaderInterface world, WorldDimensions d, double patchSize, String[] strings) {
        int widgetWidth = world.calculateWidth(d.width(), patchSize);
        int minWidth = world.getMinimumWidth();
        return StrictMath.max(widgetWidth, minWidth);
    }

    int getHeight(WorldLoaderInterface world, WorldDimensions d, double patchSize, String[] strings) {
        return world.calculateHeight(d.height(), patchSize);
    }

    double adjustPatchSize(WorldLoaderInterface world, WorldDimensions d, double patchSize, String[] strings) {
        int minWidth;
        int widgetWidth = world.calculateWidth(d.width(), patchSize);
        if (widgetWidth < (minWidth = world.getMinimumWidth())) {
            patchSize = world.computePatchSize(minWidth - world.insetWidth(), d.width());
        }
        return patchSize;
    }
}

