/*
 * Decompiled with CFR 0.152.
 */
package scala;

import scala.Collection$class;
import scala.Function1;
import scala.Function1$class;
import scala.Function2;
import scala.Iterable;
import scala.Iterable$Projection$class;
import scala.Iterable$class;
import scala.Iterator;
import scala.List;
import scala.Option;
import scala.PartialFunction$class;
import scala.Predef$;
import scala.RandomAccessSeq;
import scala.RandomAccessSeq$Projection$class;
import scala.RandomAccessSeq$class;
import scala.Seq;
import scala.Seq$Projection$class;
import scala.Seq$class;
import scala.Stream;
import scala.StringBuilder;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
implements RandomAccessSeq.Projection<Integer> {
    public volatile int bitmap$0;
    private int length;
    private final int step;
    private final int end;
    private final int start;

    public Range(int start, int end, int step) {
        this.start = start;
        this.end = end;
        this.step = step;
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        Iterable$class.$init$(this);
        Collection$class.$init$(this);
        Seq$class.$init$(this);
        Iterable$Projection$class.$init$(this);
        Seq$Projection$class.$init$(this);
        RandomAccessSeq$class.$init$(this);
        RandomAccessSeq$Projection$class.$init$(this);
        if (step == 0) {
            throw new IllegalArgumentException();
        }
    }

    public boolean inInterval(int x) {
        return this.step() > 0 ? x >= this.start() && x < this.end() : x <= this.start() && x > this.end();
    }

    @Override
    public int apply(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.start() + this.step() * idx;
    }

    public int last(int base, int step) {
        return base % step != 0 ? 1 : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int length() {
        if ((this.bitmap$0 & 1) != 0) return this.length;
        Range range = this;
        synchronized (range) {
            if ((this.bitmap$0 & 1) == 0) {
                int n;
                if (this.start() < this.end() && this.step() < 0) {
                    n = 0;
                } else if (this.start() > this.end() && this.step() > 0) {
                    n = 0;
                } else {
                    int base = this.start() < this.end() ? this.end() - this.start() : this.start() - this.end();
                    Predef$.MODULE$.assert(base >= 0);
                    int step = this.step() < 0 ? -this.step() : this.step();
                    Predef$.MODULE$.assert(step >= 0);
                    n = base / step + this.last(base, step);
                }
                this.length = n;
                this.bitmap$0 |= 1;
            }
            return this.length;
        }
    }

    @Override
    public void foreach(Function1<Integer, Object> f) {
        if (this.step() > 0) {
            int until;
            int n = until = this.inInterval(this.end()) ? this.end() + 1 : this.end();
            for (int i = this.start(); i < until; i += this.step()) {
                f.apply(BoxesRunTime.boxToInteger(i));
            }
        } else {
            int until;
            int n = until = this.inInterval(this.end()) ? this.end() - 1 : this.end();
            for (int i = this.start(); i > until; i += this.step()) {
                f.apply(BoxesRunTime.boxToInteger(i));
            }
        }
    }

    public int step() {
        return this.step;
    }

    public int end() {
        return this.end;
    }

    public int start() {
        return this.start;
    }

    public void copyToArray(BoxedArray x$1, int x$2) {
        Iterable$class.copyToArray(this, x$1, x$2);
    }

    @Override
    public StringBuilder addString(StringBuilder x$1, String x$2, String x$3, String x$4) {
        return Iterable$class.addString(this, x$1, x$2, x$3, x$4);
    }

    @Override
    public String mkString() {
        return Iterable$class.mkString(this);
    }

    @Override
    public String mkString(String x$1) {
        return Iterable$class.mkString(this, x$1);
    }

    @Override
    public String mkString(String x$1, String x$2, String x$3) {
        return Iterable$class.mkString(this, x$1, x$2, x$3);
    }

    @Override
    public List toList() {
        return Iterable$class.toList(this);
    }

    @Override
    public boolean sameElements(Iterable x$1) {
        return Iterable$class.sameElements(this, x$1);
    }

    @Override
    public void copyToBuffer(Buffer x$1) {
        Iterable$class.copyToBuffer(this, x$1);
    }

    @Override
    public Object $colon$bslash(Object x$1, Function2 x$2) {
        return Iterable$class.$colon$bslash(this, x$1, x$2);
    }

    @Override
    public Object $div$colon(Object x$1, Function2 x$2) {
        return Iterable$class.$div$colon(this, x$1, x$2);
    }

    @Override
    public Object foldRight(Object x$1, Function2 x$2) {
        return Iterable$class.foldRight(this, x$1, x$2);
    }

    @Override
    public Object foldLeft(Object x$1, Function2 x$2) {
        return Iterable$class.foldLeft(this, x$1, x$2);
    }

    @Override
    public Option find(Function1 x$1) {
        return Iterable$class.find(this, x$1);
    }

    @Override
    public boolean exists(Function1 x$1) {
        return Iterable$class.exists(this, x$1);
    }

    @Override
    public boolean forall(Function1 x$1) {
        return Iterable$class.forall(this, x$1);
    }

    @Override
    public String stringPrefix() {
        return Collection$class.stringPrefix(this);
    }

    public String toString() {
        return Collection$class.toString(this);
    }

    public BoxedArray toArray() {
        return Seq$class.toArray(this);
    }

    @Override
    public boolean contains(Object x$1) {
        return Seq$class.contains(this, x$1);
    }

    @Override
    public int indexOf(Object x$1) {
        return Seq$class.indexOf(this, x$1);
    }

    @Override
    public int findIndexOf(Function1 x$1) {
        return Seq$class.findIndexOf(this, x$1);
    }

    @Override
    public boolean isDefinedAt(int x$1) {
        return Seq$class.isDefinedAt(this, x$1);
    }

    @Override
    public Option firstOption() {
        return Seq$class.firstOption(this);
    }

    @Override
    public Object first() {
        return Seq$class.first(this);
    }

    @Override
    public Object last() {
        return Seq$class.last(this);
    }

    @Override
    public boolean isEmpty() {
        return Seq$class.isEmpty(this);
    }

    @Override
    public int size() {
        return Seq$class.size(this);
    }

    @Override
    public int lengthCompare(int x$1) {
        return Seq$class.lengthCompare(this, x$1);
    }

    @Override
    public final Iterable scala$Seq$$super$takeWhile(Function1 x$1) {
        return Iterable$class.takeWhile(this, x$1);
    }

    @Override
    public final Iterable scala$Seq$$super$filter(Function1 x$1) {
        return Iterable$class.filter(this, x$1);
    }

    @Override
    public Seq.Projection filter(Function1 x$1) {
        return Seq$Projection$class.filter(this, x$1);
    }

    @Override
    public Seq.Projection takeWhile(Function1 x$1) {
        return Seq$Projection$class.takeWhile(this, x$1);
    }

    @Override
    public Seq.Projection flatMap(Function1 x$1) {
        return Seq$Projection$class.flatMap(this, x$1);
    }

    @Override
    public Stream toStream() {
        return RandomAccessSeq$class.toStream(this);
    }

    @Override
    public RandomAccessSeq $plus$plus(Iterable x$1) {
        return RandomAccessSeq$class.$plus$plus(this, x$1);
    }

    @Override
    public RandomAccessSeq slice(int x$1, int x$2) {
        return RandomAccessSeq$class.slice(this, x$1, x$2);
    }

    @Override
    public RandomAccessSeq take(int x$1) {
        return RandomAccessSeq$class.take(this, x$1);
    }

    @Override
    public RandomAccessSeq drop(int x$1) {
        return RandomAccessSeq$class.drop(this, x$1);
    }

    @Override
    public Iterator elements() {
        return RandomAccessSeq$class.elements(this);
    }

    @Override
    public RandomAccessSeq.Projection map(Function1 x$1) {
        return RandomAccessSeq$Projection$class.map(this, x$1);
    }

    public static class Inclusive
    extends Range {
        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }

        public boolean inInterval(int x) {
            return super.step() > 0 ? x >= super.start() && x <= super.end() : x <= super.start() && x >= super.end();
        }

        public int last(int base, int step) {
            return 1;
        }

        public int apply(int idx) {
            return super.apply(idx);
        }
    }
}

