/*
 * Decompiled with CFR 0.152.
 */
package scala;

import scala.Function1;
import scala.Function1$class;
import scala.Math$;
import scala.StringBuilder$;
import scala.compat.Platform$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringBuilder
implements Function1<Integer, Character> {
    public static final long serialVersionUID = -8525408645367278351L;
    private int count;
    private char[] value;
    private final String initValue;

    public StringBuilder(int initCapacity, String initValue) {
        this.initValue = initValue;
        Function1$class.$init$(this);
        if (initCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initValue == null) {
            throw new NullPointerException();
        }
        this.value = new char[initCapacity + initValue.length()];
        this.count = 0;
        this.append(initValue);
    }

    public String toString() {
        return new String(this.value(), 0, this.count());
    }

    public StringBuilder insert(int n, String string) {
        if (n < 0 || n > this.count()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        String string2 = string;
        String string3 = string2 == null || string2.equals(null) ? "null" : string;
        int n2 = string3.length();
        int n3 = this.count() + n2;
        if (n3 > this.value().length) {
            this.expandCapacity(n3);
        }
        Platform$.MODULE$.arraycopy(this.value(), n, this.value(), n + n2, this.count() - n);
        string3.getChars(0, n2, this.value(), n);
        this.count_$eq(n3);
        return this;
    }

    public StringBuilder delete(int start, int end) {
        if (start < 0 || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int end0 = end > this.count() ? this.count() : end;
        int len = end0 - start;
        if (len > 0) {
            Platform$.MODULE$.arraycopy(this.value(), start + len, this.value(), start, this.count() - end0);
            this.count_$eq(this.count() - len);
        }
        return this;
    }

    public StringBuilder append(int x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(char x) {
        int newCount = this.count() + 1;
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        this.value()[this.count()] = x;
        this.count_$eq(this.count() + 1);
        return this;
    }

    public StringBuilder append(String string) {
        String string2 = string;
        String string3 = string2 == null || string2.equals(null) ? "null" : string;
        int n = string3.length();
        if (n > 0) {
            int n2 = this.count() + n;
            if (n2 > this.value().length) {
                this.expandCapacity(n2);
            }
            string3.getChars(0, n, this.value(), this.count());
            this.count_$eq(n2);
        }
        return this;
    }

    public StringBuilder append(Object x) {
        return this.append(String.valueOf(x));
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value()[index] = ch;
    }

    @Override
    public char apply(int i) {
        return this.charAt(i);
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value()[index];
    }

    private void expandCapacity(int n) {
        int newCapacity = (this.value().length + 1) * 2;
        this.value_$eq(StringBuilder$.MODULE$.scala$StringBuilder$$copyOf(this.value(), newCapacity < 0 ? Math$.MODULE$.MAX_INT() : (n > newCapacity ? n : newCapacity)));
    }

    public StringBuilder(String string) {
        this(16, string);
    }

    public StringBuilder() {
        this(16, "");
    }

    private void count_$eq(int x$1) {
        this.count = x$1;
    }

    private int count() {
        return this.count;
    }

    private void value_$eq(char[] x$1) {
        this.value = x$1;
    }

    private char[] value() {
        return this.value;
    }
}

