/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Observable;
import org.nlogo.agent.Patch;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.ValueConstraint;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Agent
extends Observable
implements org.nlogo.api.Agent,
Comparable<Agent> {
    final World world;
    public long id = 0L;
    public Object[] variables = null;
    ValueConstraint[] variableConstraints = null;

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public long id() {
        return this.id;
    }

    Object agentKey() {
        return (double)this.id;
    }

    public Agent(World world) {
        this.world = world;
    }

    @Override
    public int compareTo(Agent a) {
        long otherId = a.id;
        return this.id < otherId ? -1 : (this.id > otherId ? 1 : 0);
    }

    abstract Agent realloc(boolean var1) throws AgentException;

    @Override
    public abstract void setVariable(int var1, Object var2) throws AgentException, LogoException;

    public ValueConstraint variableConstraint(int vn) {
        return this.variableConstraints[vn];
    }

    public void variableConstraint(int vn, ValueConstraint con) {
        this.variableConstraints[vn] = con;
    }

    public abstract Object getObserverVariable(int var1);

    public abstract Object getTurtleVariable(int var1) throws AgentException;

    public abstract Object getBreedVariable(String var1) throws AgentException;

    public abstract Object getLinkBreedVariable(String var1) throws AgentException;

    public abstract Object getLinkVariable(int var1) throws AgentException;

    public abstract Object getPatchVariable(int var1) throws AgentException;

    public abstract Object getTurtleOrLinkVariable(String var1) throws AgentException;

    public abstract void setObserverVariable(int var1, Object var2) throws AgentException, LogoException;

    public abstract void setTurtleVariable(int var1, Object var2) throws AgentException;

    public abstract void setLinkVariable(int var1, Object var2) throws AgentException;

    public abstract void setBreedVariable(String var1, Object var2) throws AgentException;

    public abstract void setLinkBreedVariable(String var1, Object var2) throws AgentException;

    public abstract void setPatchVariable(int var1, Object var2) throws AgentException;

    public abstract void setTurtleOrLinkVariable(String var1, Object var2) throws AgentException;

    public abstract Patch getPatchAtOffsets(double var1, double var3) throws AgentException;

    void wrongTypeForVariable(String name, Class<?> expectedClass, Object value) throws AgentException {
        throw new AgentException("can't set " + this.classDisplayName() + " variable " + name + "  to non-" + Dump.typeName(expectedClass) + " " + Dump.logoObject(value));
    }

    void validRGBList(LogoList rgb, boolean allowAlpha) throws AgentException {
        if (rgb.size() == 3 || allowAlpha && rgb.size() == 4) {
            try {
                for (int i = 0; i < rgb.size(); ++i) {
                    this.validRGB(((Double)rgb.get(i)).intValue());
                }
                return;
            }
            catch (ClassCastException e) {
                Exceptions.ignore(e);
            }
        }
        throw new AgentException("An rgb list must contain 3 " + (allowAlpha ? "or 4 " : "") + "numbers 0-255");
    }

    private void validRGB(int c) throws AgentException {
        if (c < 0 || c > 255) {
            throw new AgentException("RGB values must be 0-255");
        }
    }

    @Override
    public abstract String classDisplayName();

    public abstract Class<? extends Agent> getAgentClass();

    public abstract int getAgentBit();
}

