/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.LogoList;
import org.nlogo.util.MersenneTwisterFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class ArrayAgentSet
extends AgentSet {
    Agent[] agents;
    private int size = 0;
    private final int initialCapacity;
    private int capacity = 0;

    @Override
    public int count() {
        if (!(this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            int n = 0;
            AgentSet.Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }
        return this.size;
    }

    @Override
    boolean equalAgentSetsHelper(org.nlogo.api.AgentSet otherSet) {
        HashSet<Agent> set = new HashSet<Agent>();
        AgentSet.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        for (org.nlogo.api.Agent a : otherSet.agents()) {
            if (set.contains(a)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (!(this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            return !this.iterator().hasNext();
        }
        return this.size == 0;
    }

    public ArrayAgentSet(Class<? extends Agent> type, int initialCapacity, boolean removableAgents, World world) {
        super(type, world, null, removableAgents);
        this.initialCapacity = initialCapacity;
        this.agents = new Agent[initialCapacity];
        this.capacity = initialCapacity;
    }

    public ArrayAgentSet(Class<? extends Agent> type, Agent[] agents, World world) {
        super(type, world, null, false);
        this.initialCapacity = agents.length;
        this.agents = agents;
        this.capacity = this.initialCapacity;
        this.size = this.initialCapacity;
    }

    public ArrayAgentSet(Class<? extends Agent> type, Agent[] agents, String printName, World world) {
        super(type, world, printName, false);
        this.initialCapacity = agents.length;
        this.agents = agents;
        this.capacity = this.initialCapacity;
        this.size = this.initialCapacity;
    }

    ArrayAgentSet(Class<? extends Agent> type, int initialCapacity, String printName, boolean removableAgents, World world) {
        super(type, world, printName, removableAgents);
        this.initialCapacity = initialCapacity;
        this.agents = new Agent[initialCapacity];
        this.capacity = initialCapacity;
    }

    @Override
    public Agent agent(long l) {
        if (this.type == Turtle.class || this.type == Link.class) {
            Agent agent = this.agents[(int)l];
            if (agent.id == -1L) {
                this.agents[(int)l] = null;
                return null;
            }
            return agent;
        }
        return this.agents[(int)l];
    }

    @Override
    Agent getAgent(Object id) {
        return this.agents[((Double)id).intValue()];
    }

    @Override
    public void add(Agent agent) {
        if (this.size < this.capacity) {
            this.agents[this.size] = agent;
            ++this.size;
        } else {
            Agent[] newagents = new Agent[this.capacity * 2];
            System.arraycopy(this.agents, 0, newagents, 0, this.capacity);
            this.agents = newagents;
            this.capacity *= 2;
            this.add(agent);
        }
    }

    @Override
    void remove(Object id) {
        throw new IllegalStateException("Cannot call remove() from an  ArrayAgentSet");
    }

    @Override
    void clear() {
        if (!this.removableAgents) {
            throw new IllegalStateException("Cannot call remove() on an AgentSet with removableAgents set to false");
        }
        this.capacity = this.initialCapacity;
        this.agents = new Agent[this.capacity];
        this.size = 0;
    }

    @Override
    public boolean contains(Agent agent) {
        AgentSet.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != agent) continue;
            return true;
        }
        return false;
    }

    @Override
    public Agent randomOne(int n, int n2) {
        if (this.size == this.capacity && (this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            return this.agents[n2];
        }
        AgentSet.Iterator iterator = this.iterator();
        for (int i = 0; i < n2; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    @Override
    Agent[] randomTwo(int n, int n2, int n3) {
        Agent[] agentArray = new Agent[2];
        if (n3 >= n2) {
            ++n3;
        } else {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        if (this.size == this.capacity && (this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            agentArray[0] = this.agents[n2];
            agentArray[1] = this.agents[n3];
        } else {
            AgentSet.Iterator iterator = this.iterator();
            int n5 = 0;
            while (n5++ < n2) {
                iterator.next();
            }
            agentArray[0] = iterator.next();
            while (n5++ < n3) {
                iterator.next();
            }
            agentArray[1] = iterator.next();
        }
        return agentArray;
    }

    @Override
    Agent[] randomSubsetGeneral(int resultSize, int precomputedCount, MersenneTwisterFast random) {
        Agent[] result = new Agent[resultSize];
        if (precomputedCount == this.capacity) {
            int i = 0;
            int j = 0;
            while (j < resultSize) {
                if (random.nextInt(precomputedCount - i) < resultSize - j) {
                    result[j] = this.agents[i];
                    ++j;
                }
                ++i;
            }
        } else {
            AgentSet.Iterator iter = this.iterator();
            int i = 0;
            int j = 0;
            while (j < resultSize) {
                Agent next = iter.next();
                if (random.nextInt(precomputedCount - i) < resultSize - j) {
                    result[j] = next;
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public LogoList toLogoList() {
        ArrayList<Agent> result = new ArrayList<Agent>();
        AgentSet.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Agent agent = iter.next();
            if (agent == null) continue;
            result.add(agent);
        }
        Collections.sort(result);
        return new LogoList(result);
    }

    @Override
    public Agent[] toArray() {
        return this.agents;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("AgentSet");
        s = s.append("\n...... type: ");
        s = s.append(this.type == null ? "null" : this.type.toString());
        s = s.append("\n...... size: " + this.size);
        s = s.append("\n...... count(): " + this.count());
        s = s.append("\n...... capacity: " + this.capacity);
        s = s.append("\n...... agents: ");
        AgentSet.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            s = s.append("\n" + iter.next().toString());
        }
        return s.toString();
    }

    @Override
    public AgentSet.Iterator iterator() {
        if (this.type == Patch.class) {
            return new Iterator();
        }
        return new IteratorWithDead();
    }

    @Override
    public AgentSet.Iterator shufflerator(MersenneTwisterFast random) {
        return new Shufflerator(random);
    }

    private strictfp class Shufflerator
    extends Iterator {
        private int i;
        private final Agent[] copy;
        private Agent next;
        private final MersenneTwisterFast random;

        Shufflerator(MersenneTwisterFast random) {
            this.i = 0;
            this.copy = new Agent[ArrayAgentSet.this.size];
            this.random = random;
            System.arraycopy(ArrayAgentSet.this.agents, 0, this.copy, 0, ArrayAgentSet.this.size);
            while (this.i < this.copy.length && this.copy[this.i] == null) {
                ++this.i;
            }
            this.fetch();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Agent next() {
            Agent result = this.next;
            this.fetch();
            return result;
        }

        private void fetch() {
            if (this.i >= this.copy.length) {
                this.next = null;
            } else {
                if (this.i < this.copy.length - 1) {
                    int r = this.i + this.random.nextInt(this.copy.length - this.i);
                    this.next = this.copy[r];
                    this.copy[r] = this.copy[this.i];
                } else {
                    this.next = this.copy[this.i];
                }
                ++this.i;
                if (this.next == null || this.next.id == -1L) {
                    this.fetch();
                }
            }
        }
    }

    private strictfp class IteratorWithDead
    extends Iterator {
        IteratorWithDead() {
            while (this.index < ArrayAgentSet.this.size && ArrayAgentSet.this.agents[this.index].id == -1L) {
                ++this.index;
            }
        }

        public Agent next() {
            int resultIndex = this.index;
            do {
                ++this.index;
            } while (this.index < ArrayAgentSet.this.size && ArrayAgentSet.this.agents[this.index].id == -1L);
            return ArrayAgentSet.this.agents[resultIndex];
        }
    }

    public strictfp class Iterator
    implements AgentSet.Iterator {
        int index;

        public boolean hasNext() {
            return this.index < ArrayAgentSet.this.size;
        }

        public Agent next() {
            return ArrayAgentSet.this.agents[this.index++];
        }
    }
}

