/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoList;
import org.nlogo.api.Nobody;

strictfp class Exporter {
    final World world;

    Exporter(World world) {
        this.world = world;
    }

    void exportWorld(PrintWriter writer, boolean full) {
        this.exportRandomState(writer);
        this.exportGlobals(writer);
        if (full) {
            this.exportTurtles(writer);
            this.exportPatches(writer);
            this.exportLinks(writer);
        }
    }

    void exportLinks(PrintWriter writer) {
        writer.println(Dump.csv.encode("LINKS"));
        ArrayList<String> allLinkVars = new ArrayList<String>();
        Iterator<String> iter = this.world.program().linksOwn.iterator();
        while (iter.hasNext()) {
            allLinkVars.add(iter.next());
        }
        int linkVarSize = this.world.program().linksOwn.size();
        HashMap<String, Integer> breedVarIndices = new HashMap<String, Integer>();
        for (String current : this.world.program().linkBreedsOwn.keySet()) {
            List<String> breedOwns = this.world.program().linkBreedsOwn.get(current);
            for (int i = 0; i < breedOwns.size(); ++i) {
                String breedVarName = breedOwns.get(i);
                if (breedVarIndices.get(breedVarName) != null) continue;
                allLinkVars.add(breedVarName);
                breedVarIndices.put(breedVarName, allLinkVars.size() - 1);
            }
        }
        writer.println(Dump.csv.variableNameRow(allLinkVars));
        LogoList links = this.world.links().toLogoList();
        for (Link link : links) {
            if (link == null) continue;
            AgentSet breed = (AgentSet)link.getLinkVariable(6);
            String key = breed.printName();
            List<String> breedOwns = null;
            int[] thisBreedVarIndices = null;
            String[] sortedBreedOwns = null;
            if (!key.equals("LINKS")) {
                breedOwns = this.world.program().linkBreedsOwn.get(key);
                thisBreedVarIndices = new int[breedOwns.size()];
                sortedBreedOwns = new String[breedOwns.size()];
                for (int j = 0; j < breedOwns.size(); ++j) {
                    sortedBreedOwns[j] = breedOwns.get(j);
                    thisBreedVarIndices[j] = (Integer)breedVarIndices.get(breedOwns.get(j));
                }
                this.sortIndicesAndVars(sortedBreedOwns, thisBreedVarIndices);
            } else {
                thisBreedVarIndices = new int[]{};
            }
            int index = 0;
            for (int j = 0; j < allLinkVars.size(); ++j) {
                if (j > 0) {
                    writer.print(",");
                }
                if (j < linkVarSize) {
                    writer.print(Dump.csv.data(link.getLinkVariable(j)));
                    continue;
                }
                if (index >= thisBreedVarIndices.length || j != thisBreedVarIndices[index]) continue;
                writer.print(Dump.csv.data(link.getLinkVariable(this.world.linkBreedsOwnIndexOf(breed, sortedBreedOwns[index]))));
                ++index;
            }
            writer.println();
        }
        writer.println();
    }

    void exportRandomState(PrintWriter writer) {
        writer.println(Dump.csv.encode("RANDOM STATE"));
        writer.println(Dump.csv.encode(this.world.mainRNG.save()));
        writer.println();
    }

    void exportGlobals(PrintWriter writer) {
        writer.println(Dump.csv.encode("GLOBALS"));
        writer.print(Dump.csv.encode("min-pxcor") + "," + Dump.csv.encode("max-pxcor") + "," + Dump.csv.encode("min-pycor") + "," + Dump.csv.encode("max-pycor") + "," + Dump.csv.encode("perspective") + "," + Dump.csv.encode("subject") + "," + Dump.csv.encode("nextIndex") + "," + Dump.csv.encode("directed-links") + "," + Dump.csv.encode("ticks"));
        List<String> globals = this.world.program().globals;
        ArrayList<String> sortedGlobals = new ArrayList<String>(globals.size());
        HashMap<String, Integer> globalVarIndices = new HashMap<String, Integer>();
        for (int i = 0; i < globals.size(); ++i) {
            globalVarIndices.put(globals.get(i), i);
            sortedGlobals.add(globals.get(i));
        }
        Collections.sort(sortedGlobals);
        Object subject = this.world.observer().targetAgent();
        if (subject == null) {
            subject = Nobody.NOBODY;
        }
        writer.print("," + Dump.csv.variableNameRow(sortedGlobals));
        writer.println();
        writer.print(Dump.csv.encode(Integer.toString(this.world.minPxcor())) + "," + Dump.csv.encode(Integer.toString(this.world.maxPxcor())) + "," + Dump.csv.encode(Integer.toString(this.world.minPycor())) + "," + Dump.csv.encode(Integer.toString(this.world.maxPycor())) + "," + Dump.csv.encode(Integer.toString(this.world.observer().perspective().export())) + "," + Dump.csv.data(subject) + "," + Dump.csv.encode(Long.toString(this.world.nextTurtleIndex())) + "," + Dump.csv.data(this.world.links().isDirected() ? "DIRECTED" : (this.world.links().isUndirected() ? "UNDIRECTED" : "NEITHER")) + "," + Dump.csv.encode(Dump.number(this.world.tickCounter.ticks())));
        for (int i = 0; i < globals.size(); ++i) {
            writer.print(",");
            writer.print(Dump.csv.data(this.world.observer().getObserverVariable((Integer)globalVarIndices.get(sortedGlobals.get(i)))));
        }
        writer.println();
        writer.println();
    }

    void exportTurtles(PrintWriter writer) {
        writer.println(Dump.csv.encode("TURTLES"));
        ArrayList<String> allTurtleVars = new ArrayList<String>(this.world.program().turtlesOwn);
        int turtlesVarSize = this.world.program().turtlesOwn.size();
        HashMap<String, Integer> breedVarIndices = new HashMap<String, Integer>();
        for (String current : this.world.program().breedsOwn.keySet()) {
            List<String> breedOwns = this.world.program().breedsOwn.get(current);
            for (int i = 0; i < breedOwns.size(); ++i) {
                String breedVarName = breedOwns.get(i);
                if (breedVarIndices.get(breedVarName) != null) continue;
                allTurtleVars.add(breedVarName);
                breedVarIndices.put(breedVarName, allTurtleVars.size() - 1);
            }
        }
        writer.println(Dump.csv.variableNameRow(allTurtleVars));
        LogoList turtles = this.world.turtles().toLogoList();
        for (Turtle turtle2 : turtles) {
            if (turtle2 == null) continue;
            writer.print(Dump.csv.data(turtle2.getTurtleVariable(0)));
            AgentSet breed = (AgentSet)turtle2.getTurtleVariable(8);
            String key = breed.printName();
            List<String> breedOwns = null;
            int[] thisBreedVarIndices = null;
            String[] sortedBreedOwns = null;
            if (!key.equals("TURTLES")) {
                breedOwns = this.world.program().breedsOwn.get(key);
                thisBreedVarIndices = new int[breedOwns.size()];
                sortedBreedOwns = new String[breedOwns.size()];
                for (int j = 0; j < breedOwns.size(); ++j) {
                    sortedBreedOwns[j] = breedOwns.get(j);
                    thisBreedVarIndices[j] = (Integer)breedVarIndices.get(breedOwns.get(j));
                }
                this.sortIndicesAndVars(sortedBreedOwns, thisBreedVarIndices);
            } else {
                thisBreedVarIndices = new int[]{};
            }
            int index = 0;
            for (int j = 1; j < allTurtleVars.size(); ++j) {
                writer.print(",");
                if (j < turtlesVarSize) {
                    writer.print(Dump.csv.data(turtle2.getTurtleVariable(j)));
                    continue;
                }
                if (index >= thisBreedVarIndices.length || j != thisBreedVarIndices[index]) continue;
                writer.print(Dump.csv.data(turtle2.getTurtleVariable(this.world.breedsOwnIndexOf(breed, sortedBreedOwns[index]))));
                ++index;
            }
            writer.println();
        }
        writer.println();
    }

    void exportPatches(PrintWriter writer) {
        writer.println(Dump.csv.encode("PATCHES"));
        List<String> vars = this.world.program().patchesOwn;
        writer.println(Dump.csv.variableNameRow(vars));
        Agent[] patches = this.world.patches.toArray();
        for (int i = 0; i < patches.length; ++i) {
            Patch patch = (Patch)patches[i];
            if (patch == null) continue;
            for (int j = 0; j < vars.size(); ++j) {
                if (j > 0) {
                    writer.print(",");
                }
                writer.print(Dump.csv.data(patch.getPatchVariable(j)));
            }
            writer.println();
        }
        writer.println();
    }

    void sortIndicesAndVars(String[] vars, int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            int min = indices[i];
            int minIndex = i;
            for (int j = i; j < indices.length; ++j) {
                if (indices[j] >= min) continue;
                min = indices[j];
                minIndex = j;
            }
            if (i == minIndex) continue;
            int intTemp = indices[i];
            String stringTemp = vars[i];
            indices[i] = indices[minIndex];
            vars[i] = vars[minIndex];
            indices[minIndex] = intTemp;
            vars[minIndex] = stringTemp;
        }
    }
}

