/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Drawing3D;
import org.nlogo.agent.Exporter;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World3D;
import org.nlogo.api.DrawingLine3D;
import org.nlogo.api.Dump;
import org.nlogo.api.LinkStamp3D;
import org.nlogo.api.Nobody;
import org.nlogo.api.TurtleStamp3D;

strictfp class Exporter3D
extends Exporter {
    Exporter3D(World3D world) {
        super(world);
    }

    void exportWorld(PrintWriter writer, boolean full) {
        this.exportRandomState(writer);
        this.exportGlobals(writer);
        if (full) {
            this.exportTurtles(writer);
            this.exportPatches(writer);
            this.exportLinks(writer);
            this.exportDrawing(writer);
        }
    }

    void exportDrawing(PrintWriter writer) {
        writer.println(Dump.csv.encode("DRAWING"));
        writer.println(Dump.csv.encode("x0") + "," + Dump.csv.encode("y0") + "," + Dump.csv.encode("z0") + "," + Dump.csv.encode("x1") + "," + Dump.csv.encode("y1") + "," + Dump.csv.encode("z1") + "," + Dump.csv.encode("width") + "," + Dump.csv.encode("color"));
        Drawing3D drawing = ((World3D)this.world).drawing;
        for (DrawingLine3D drawingLine3D : drawing.lines()) {
            writer.print(Dump.csv.encode(Double.toString(drawingLine3D.x0())));
            writer.print("," + Dump.csv.encode(Double.toString(drawingLine3D.y0())));
            writer.print("," + Dump.csv.encode(Double.toString(drawingLine3D.z0())));
            writer.print("," + Dump.csv.encode(Double.toString(drawingLine3D.x1())));
            writer.print("," + Dump.csv.encode(Double.toString(drawingLine3D.y1())));
            writer.print("," + Dump.csv.encode(Double.toString(drawingLine3D.z1())));
            writer.print("," + Dump.csv.encode(Double.toString(drawingLine3D.width())));
            writer.print("," + Dump.csv.data(drawingLine3D.color()));
            writer.println();
        }
        writer.println(Dump.csv.encode("shape") + "," + Dump.csv.encode("xcor") + "," + Dump.csv.encode("ycor") + "," + Dump.csv.encode("zcor") + "," + Dump.csv.encode("size") + "," + Dump.csv.encode("heading") + "," + Dump.csv.encode("pitch") + "," + Dump.csv.encode("roll") + "," + Dump.csv.encode("color") + "," + Dump.csv.encode("lineThickness"));
        for (TurtleStamp3D turtleStamp3D : drawing.turtleStamps()) {
            writer.print(Dump.csv.encode(turtleStamp3D.shape()));
            writer.print("," + Dump.csv.encode(Double.toString(turtleStamp3D.xcor())));
            writer.print("," + Dump.csv.encode(Double.toString(turtleStamp3D.ycor())));
            writer.print("," + Dump.csv.encode(Double.toString(turtleStamp3D.zcor())));
            writer.print("," + Dump.csv.encode(Double.toString(turtleStamp3D.size())));
            writer.print("," + Dump.csv.encode(Double.toString(turtleStamp3D.heading())));
            writer.print("," + Dump.csv.encode(Double.toString(turtleStamp3D.pitch())));
            writer.print("," + Dump.csv.encode(Double.toString(turtleStamp3D.roll())));
            writer.print("," + Dump.csv.data(turtleStamp3D.color()));
            writer.print("," + Dump.csv.encode(Double.toString(turtleStamp3D.lineThickness())));
            writer.println();
        }
        writer.println(Dump.csv.encode("shape") + "," + Dump.csv.encode("x1") + "," + Dump.csv.encode("y1") + "," + Dump.csv.encode("z1") + "," + Dump.csv.encode("x2") + "," + Dump.csv.encode("y2") + "," + Dump.csv.encode("z2") + "," + Dump.csv.encode("color") + "," + Dump.csv.encode("lineThickness") + "," + Dump.csv.encode("directedLink") + "," + Dump.csv.encode("destSize") + "," + Dump.csv.encode("heading") + "," + Dump.csv.encode("pitch"));
        for (LinkStamp3D linkStamp3D : drawing.linkStamps()) {
            writer.print(Dump.csv.encode(linkStamp3D.shape()));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.x1())));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.y1())));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.z1())));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.x2())));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.y2())));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.z2())));
            writer.print("," + Dump.csv.data(linkStamp3D.color()));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.lineThickness())));
            writer.print("," + Dump.csv.encode(Boolean.toString(linkStamp3D.isDirectedLink())));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.linkDestinationSize())));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.heading())));
            writer.print("," + Dump.csv.encode(Double.toString(linkStamp3D.pitch())));
            writer.println();
        }
        writer.println();
    }

    void exportGlobals(PrintWriter writer) {
        writer.println(Dump.csv.encode("GLOBALS"));
        writer.print(Dump.csv.encode("min-pxcor") + "," + Dump.csv.encode("max-pxcor") + "," + Dump.csv.encode("min-pycor") + "," + Dump.csv.encode("max-pycor") + "," + Dump.csv.encode("min-pzcor") + "," + Dump.csv.encode("max-pzcor") + "," + Dump.csv.encode("perspective") + "," + Dump.csv.encode("subject") + "," + Dump.csv.encode("nextIndex") + "," + Dump.csv.encode("directed-links") + "," + Dump.csv.encode("ticks"));
        List<String> globals = this.world.program().globals;
        ArrayList<String> sortedGlobals = new ArrayList<String>(globals.size());
        HashMap<String, Integer> globalVarIndices = new HashMap<String, Integer>();
        for (int i = 0; i < globals.size(); ++i) {
            globalVarIndices.put(globals.get(i), i);
            sortedGlobals.add(globals.get(i));
        }
        Collections.sort(sortedGlobals);
        Object subject = this.world.observer().targetAgent();
        if (subject == null) {
            subject = Nobody.NOBODY;
        }
        writer.print("," + Dump.csv.variableNameRow(sortedGlobals));
        writer.println();
        writer.print(Dump.csv.encode(Integer.toString(this.world.minPxcor())) + "," + Dump.csv.encode(Integer.toString(this.world.maxPxcor())) + "," + Dump.csv.encode(Integer.toString(this.world.minPycor())) + "," + Dump.csv.encode(Integer.toString(this.world.maxPycor())) + "," + Dump.csv.encode(Integer.toString(((World3D)this.world).minPzcor())) + "," + Dump.csv.encode(Integer.toString(((World3D)this.world).maxPzcor())) + "," + Dump.csv.encode(Integer.toString(this.world.observer().perspective().export())) + "," + Dump.csv.data(subject) + "," + Dump.csv.encode(Long.toString(this.world.nextTurtleIndex())) + "," + Dump.csv.data(this.world.links().isDirected() ? "DIRECTED" : (this.world.links().isUndirected() ? "UNDIRECTED" : "NEITHER")) + "," + Dump.csv.encode(Dump.number(this.world.tickCounter.ticks())));
        for (int i = 0; i < globals.size(); ++i) {
            writer.print(",");
            writer.print(Dump.csv.data(this.world.observer().getObserverVariable((Integer)globalVarIndices.get(sortedGlobals.get(i)))));
        }
        writer.println();
        writer.println();
    }

    void exportTurtles(PrintWriter writer) {
        writer.println(Dump.csv.encode("TURTLES"));
        ArrayList<String> allTurtleVars = new ArrayList<String>(this.world.program().turtlesOwn);
        int turtlesVarSize = this.world.program().turtlesOwn.size();
        HashMap<String, Integer> breedVarIndices = new HashMap<String, Integer>();
        for (String current : this.world.program().breedsOwn.keySet()) {
            List<String> breedOwns = this.world.program().breedsOwn.get(current);
            for (int i = 0; i < breedOwns.size(); ++i) {
                String breedVarName = breedOwns.get(i);
                if (breedVarIndices.get(breedVarName) != null) continue;
                allTurtleVars.add(breedVarName);
                breedVarIndices.put(breedVarName, allTurtleVars.size() - 1);
            }
        }
        writer.println(Dump.csv.variableNameRow(allTurtleVars));
        Agent[] turtles = this.world.turtles().toArray();
        for (int i = 0; i < turtles.length; ++i) {
            Turtle turtle2 = (Turtle)turtles[i];
            if (turtle2 == null) continue;
            writer.print(Dump.csv.data(turtle2.getTurtleVariable(0)));
            AgentSet breed = (AgentSet)turtle2.getTurtleVariable(11);
            String key = breed.printName();
            List<String> breedOwns = null;
            int[] thisBreedVarIndices = null;
            String[] sortedBreedOwns = null;
            if (!key.equals("TURTLES")) {
                breedOwns = this.world.program().breedsOwn.get(key);
                thisBreedVarIndices = new int[breedOwns.size()];
                sortedBreedOwns = new String[breedOwns.size()];
                for (int j = 0; j < breedOwns.size(); ++j) {
                    sortedBreedOwns[j] = breedOwns.get(j);
                    thisBreedVarIndices[j] = (Integer)breedVarIndices.get(breedOwns.get(j));
                }
                this.sortIndicesAndVars(sortedBreedOwns, thisBreedVarIndices);
            } else {
                thisBreedVarIndices = new int[]{};
            }
            int index = 0;
            for (int j = 1; j < allTurtleVars.size(); ++j) {
                writer.print(",");
                if (j < turtlesVarSize) {
                    writer.print(Dump.csv.data(turtle2.getTurtleVariable(j)));
                    continue;
                }
                if (index >= thisBreedVarIndices.length || j != thisBreedVarIndices[index]) continue;
                writer.print(Dump.csv.data(turtle2.getTurtleVariable(this.world.breedsOwnIndexOf(breed, sortedBreedOwns[index]))));
                ++index;
            }
            writer.println();
        }
        writer.println();
    }
}

