/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Iterator;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.Shape;
import org.nlogo.api.Version;
import org.nlogo.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Link
extends Agent
implements org.nlogo.api.Link {
    final Turtle end1;
    final Turtle end2;
    public int LAST_PREDEFINED_VAR = 9;
    public int NUMBER_PREDEFINED_VARS = this.LAST_PREDEFINED_VAR + 1;
    public static final Double DEFAULT_COLOR = 5.0;
    Shape cachedShape;

    @Override
    public Turtle end1() {
        return this.end1;
    }

    @Override
    public Turtle end2() {
        return this.end2;
    }

    @Override
    public Object agentKey() {
        return this;
    }

    public Link(World world, Turtle end1, Turtle end2, int arraySize) {
        super(world);
        this.variables = new Object[arraySize];
        this.variables[0] = end1;
        this.variables[1] = end2;
        this.end1 = end1;
        this.end2 = end2;
        this.id = world.newLinkId();
        for (int i = 2; i < this.variables.length; ++i) {
            this.variables[i] = World.ZERO;
        }
        if (Version.isLoggingEnabled()) {
            Logger.logLinkBirth(this.toString(), world.links().printName());
        }
    }

    Link(World world, Turtle end1, Turtle end2, AgentSet breed) {
        super(world);
        this.variables = new Object[world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)breed)];
        this.variables[2] = Color.BOXED_BLACK;
        this.variables[0] = end1;
        this.variables[1] = end2;
        this.variables[3] = "";
        this.variables[4] = Color.BOXED_WHITE;
        this.variables[5] = Boolean.FALSE;
        this.variables[7] = World.ZERO;
        this.variables[8] = world.linkBreedShapes.breedShape(breed);
        this.variables[9] = "none";
        this.end1 = end1;
        this.end2 = end2;
        this.id = world.newLinkId();
        this.variables[6] = breed;
        world.links().add(this);
        if (breed != world.links()) {
            breed.add(this);
        }
        for (int i = this.LAST_PREDEFINED_VAR + 1; i < this.variables.length; ++i) {
            this.variables[i] = World.ZERO;
        }
        if (Version.isLoggingEnabled()) {
            Logger.logLinkBirth(this.toString(), breed.printName());
        }
    }

    public void die() {
        if (this.id == -1L) {
            return;
        }
        AgentSet breed = this.getBreed();
        if (Version.isLoggingEnabled()) {
            Logger.logLinkDeath(this.toString(), breed.printName());
        }
        this.world.links().remove(this.agentKey());
        if (breed != this.world.links()) {
            breed.remove(this.agentKey());
        }
        this.world.linkManager.cleanup(this);
        this.id = -1L;
    }

    @Override
    Agent realloc(boolean compiling) {
        return this.realloc(compiling, null);
    }

    Agent realloc(boolean compiling, AgentSet oldBreed) {
        int oldpos;
        String name;
        int i;
        if (compiling && this.getBreed() != this.world.links() && this.world.getLinkBreed(this.getBreed().printName()) == null) {
            return this;
        }
        Object[] oldvars = this.variables;
        this.variables = new Object[this.world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)this.getBreed())];
        int linksOwnSize = this.world.getVariablesArraySize((org.nlogo.api.Link)null, (org.nlogo.api.AgentSet)this.world.links());
        int numberToCopyDirectly = compiling ? this.NUMBER_PREDEFINED_VARS : linksOwnSize;
        System.arraycopy(oldvars, 0, this.variables, 0, numberToCopyDirectly);
        if (compiling) {
            for (i = this.NUMBER_PREDEFINED_VARS; i < linksOwnSize; ++i) {
                name = this.world.linksOwnNameAt(i);
                oldpos = this.world.oldLinksOwnIndexOf(name);
                if (oldpos == -1) {
                    this.variables[i] = World.ZERO;
                    continue;
                }
                this.variables[i] = oldvars[oldpos];
                oldvars[oldpos] = null;
            }
        }
        for (i = linksOwnSize; i < this.variables.length; ++i) {
            name = this.world.linkBreedsOwnNameAt(this.getBreed(), i);
            int n = oldpos = compiling ? this.world.oldLinkBreedsOwnIndexOf(this.getBreed(), name) : this.world.linkBreedsOwnIndexOf(oldBreed, name);
            if (oldpos == -1) {
                this.variables[i] = World.ZERO;
                continue;
            }
            this.variables[i] = oldvars[oldpos];
            oldvars[oldpos] = null;
        }
        return null;
    }

    @Override
    public Object getVariable(int vn) {
        return this.getLinkVariable(vn);
    }

    @Override
    public Object getTurtleOrLinkVariable(String varName) {
        return this.getLinkVariable(this.world.program.linksOwn.indexOf(varName));
    }

    @Override
    public void setVariable(int vn, Object value) throws AgentException {
        this.setLinkVariable(vn, value);
    }

    @Override
    public Object getObserverVariable(int vn) {
        return this.world.observer().getObserverVariable(vn);
    }

    @Override
    public Object getLinkVariable(int vn) {
        return this.variables[vn];
    }

    @Override
    public void setObserverVariable(int vn, Object value) throws AgentException, LogoException {
        this.world.observer().setObserverVariable(vn, value);
    }

    @Override
    public void setTurtleOrLinkVariable(String varName, Object value) throws AgentException {
        this.setLinkVariable(this.world.program.linksOwn.indexOf(varName), value);
    }

    @Override
    public void setLinkVariable(int n, Object object) throws AgentException {
        if (n > this.LAST_PREDEFINED_VAR) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 2: {
                    if (object instanceof Double) {
                        this.colorDouble((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.color((LogoList)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], Double.class, object);
                    break;
                }
                case 3: {
                    this.label(object);
                    break;
                }
                case 4: {
                    if (object instanceof Double) {
                        this.labelColor((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], Double.class, object);
                    break;
                }
                case 5: {
                    if (object instanceof Boolean) {
                        this.hidden((Boolean)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], Boolean.class, object);
                    break;
                }
                case 6: {
                    if (object instanceof AgentSet) {
                        AgentSet agentSet = (AgentSet)object;
                        if (agentSet != this.world.links() && !this.world.isLinkBreed(agentSet)) {
                            throw new AgentException("can't set BREED to a non-link-breed agentset");
                        }
                        if (this.world.getLink(this.end1.agentKey(), this.end2.agentKey(), agentSet) != null) {
                            throw new AgentException("there is already a " + this.world.getLinkBreedSingular(agentSet) + " with endpoints " + this.end1.toString() + " and " + this.end2.toString());
                        }
                        if (!this.world.linkManager.checkBreededCompatibility(agentSet == this.world.links())) {
                            throw new AgentException("You cannot have both breeded and unbreeded links in the same world.");
                        }
                        this.setBreed(agentSet);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], AgentSet.class, object);
                    break;
                }
                case 7: {
                    if (object instanceof Double) {
                        this.lineThickness((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], Double.class, object);
                    break;
                }
                case 8: {
                    if (object instanceof String) {
                        String string = this.world.checkLinkShapeName((String)object);
                        if (string == null) {
                            throw new AgentException("\"" + (String)object + "\" is not a currently defined shape");
                        }
                        this.shape(string);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], String.class, object);
                    break;
                }
                case 9: {
                    if (object instanceof String) {
                        this.mode((String)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], String.class, object);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AgentException("you can't change a link's endpoints");
                }
                default: {
                    return;
                }
            }
        }
    }

    @Override
    public Object getTurtleVariable(int vn) throws AgentException {
        throw new AgentException("a link can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getBreedVariable(String name) throws AgentException {
        throw new AgentException("a link can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getLinkBreedVariable(String name) throws AgentException {
        this.mustOwn(name);
        int vn = this.world.linkBreedsOwnIndexOf(this.getBreed(), name);
        return this.getLinkVariable(vn);
    }

    @Override
    public Object getPatchVariable(int vn) throws AgentException {
        throw new AgentException("a link can't access a patch variable without specifying which patch");
    }

    @Override
    public void setTurtleVariable(int vn, Object value) throws AgentException {
        throw new AgentException("a link can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException("a link can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setLinkBreedVariable(String name, Object value) throws AgentException {
        this.mustOwn(name);
        int vn = this.world.linkBreedsOwnIndexOf(this.getBreed(), name);
        this.setLinkVariable(vn, value);
    }

    @Override
    public void setPatchVariable(int vn, Object value) throws AgentException {
        throw new AgentException("a link can't set a patch variable without specifying which turtle");
    }

    void mustOwn(String name) throws AgentException {
        if (name != null && !this.world.linkBreedOwns(this.getBreed(), name)) {
            throw new AgentException(this.getBreed().printName() + " breed does not own variable " + name);
        }
    }

    @Override
    public double x1() {
        return this.end1.xcor();
    }

    @Override
    public double y1() {
        return this.end1.ycor();
    }

    @Override
    public double x2() {
        return this.world.topology.shortestPathX(this.end1.xcor(), this.end2.xcor());
    }

    @Override
    public double y2() {
        return this.world.topology.shortestPathY(this.end1.ycor(), this.end2.ycor());
    }

    @Override
    public double midpointX() {
        double x1 = this.x1();
        double x2 = this.x2();
        return Topology.wrap((x1 + x2) / 2.0, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor + 0.5);
    }

    @Override
    public double midpointY() {
        double y1 = this.y1();
        double y2 = this.y2();
        return Topology.wrap((y1 + y2) / 2.0, (double)this.world.minPycor - 0.5, (double)this.world.maxPycor + 0.5);
    }

    @Override
    public double heading() {
        try {
            return this.world.protractor.towards(this.end1, this.end2, true);
        }
        catch (AgentException e) {
            return 0.0;
        }
    }

    @Override
    public double lineThickness() {
        return (Double)this.variables[7];
    }

    public void lineThickness(Double value) {
        this.variables[7] = value;
    }

    @Override
    public boolean isDirectedLink() {
        return ((AgentSet)this.variables[6]).isDirected();
    }

    @Override
    public double linkDestinationSize() {
        return this.end2.size();
    }

    @Override
    public double size() {
        return this.world.protractor.distance(this.end1, this.end2, true);
    }

    @Override
    public String shape() {
        return (String)this.variables[8];
    }

    public void shape(String shape) {
        this.variables[8] = shape;
        this.cachedShape = null;
    }

    public String mode() {
        return (String)this.variables[9];
    }

    public void mode(String mode) {
        this.world.tieManager.setTieMode(this, mode);
        this.variables[9] = mode;
    }

    public boolean isTied() {
        return !this.variables[9].equals("none");
    }

    public void untie() {
        this.mode("none");
    }

    @Override
    public Object color() {
        return this.variables[2];
    }

    public void colorDouble(Double boxedColor) {
        double c = boxedColor;
        if (c < 0.0 || c >= 140.0) {
            c = Color.modulateDouble(c);
            boxedColor = c;
        }
        this.variables[2] = boxedColor;
    }

    public void colorDoubleUnchecked(Double boxedColor) {
        this.variables[2] = boxedColor;
    }

    public void color(LogoList rgb) throws AgentException {
        this.validRGBList(rgb, true);
        this.variables[2] = rgb;
    }

    public AgentSet bothEnds() {
        ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Turtle.class, 2, false, this.world);
        ((AgentSet)arrayAgentSet).add(this.end1);
        ((AgentSet)arrayAgentSet).add(this.end2);
        return arrayAgentSet;
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        throw new AgentException("links can't access patches via relative coordinates");
    }

    public Object label() {
        return this.variables[3];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables[3]);
    }

    public void label(Object label) {
        this.variables[3] = label;
    }

    @Override
    public boolean hidden() {
        return (Boolean)this.variables[5];
    }

    public void hidden(boolean hidden) {
        this.variables[5] = hidden ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public AgentSet getBreed() {
        return (AgentSet)this.variables[6];
    }

    @Override
    public Object labelColor() {
        return this.variables[4];
    }

    public void labelColor(double labelColor) {
        this.variables[4] = Color.modulateDouble(labelColor);
    }

    public void labelColor(LogoList rgb) throws AgentException {
        this.validRGBList(rgb, true);
        this.variables[4] = rgb;
    }

    public String toString() {
        return this.world.getLinkBreedSingular(this.getBreed()).toLowerCase() + " " + this.end1.id + " " + this.end2.id;
    }

    @Override
    public String classDisplayName() {
        return this.world.getLinkBreedSingular(this.getBreed()).toLowerCase();
    }

    public Class<Link> getAgentClass() {
        return Link.class;
    }

    @Override
    public int getAgentBit() {
        return 8;
    }

    public void setBreed(AgentSet breed) {
        AgentSet oldBreed = null;
        if (this.variables[6] instanceof AgentSet) {
            oldBreed = (AgentSet)this.variables[6];
            if (breed == oldBreed) {
                return;
            }
            if (oldBreed != this.world.links()) {
                ((AgentSet)this.variables[6]).remove(this.agentKey());
            }
        }
        if (breed != this.world.links()) {
            breed.add(this);
        }
        this.variables[6] = breed;
        this.shape(this.world.linkBreedShapes.breedShape(breed));
        this.realloc(false, oldBreed);
    }

    @Override
    public int getBreedIndex() {
        AgentSet mybreed = this.getBreed();
        if (mybreed == this.world.links()) {
            return 0;
        }
        int j = 1;
        Iterator<Object> iter = this.world.program().linkBreeds.values().iterator();
        while (iter.hasNext()) {
            if (mybreed == (AgentSet)iter.next()) {
                return j;
            }
            ++j;
        }
        return 0;
    }

    @Override
    public int compareTo(Agent a) {
        if (a == this) {
            return 0;
        }
        Link otherLink = (Link)a;
        if (this.end1.id < otherLink.end1.id) {
            return -1;
        }
        if (this.end1.id > otherLink.end1.id) {
            return 1;
        }
        if (this.end2.id < otherLink.end2.id) {
            return -1;
        }
        if (this.end2.id > otherLink.end2.id) {
            return 1;
        }
        if (this.getBreed() == otherLink.getBreed()) {
            return 0;
        }
        if (this.getBreed() == this.world.links()) {
            return -1;
        }
        if (otherLink.getBreed() == this.world.links()) {
            return 1;
        }
        return this.world.compareLinkBreeds(this.getBreed(), otherLink.getBreed());
    }
}

