/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Turtle;
import org.nlogo.api.LogoList;
import org.nlogo.util.MersenneTwisterFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class NetworkMetrics {
    private final LinkManager linkManager;

    NetworkMetrics(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public Set<Turtle> inNetworkRadius(Turtle sourceNode, AgentSet sourceSet, double radius, AgentSet linkBreed) {
        HashSet<Turtle> seen = new HashSet<Turtle>();
        HashSet<Turtle> visited = new HashSet<Turtle>();
        LinkedList<Turtle> queue = new LinkedList<Turtle>();
        queue.addLast(sourceNode);
        seen.add(sourceNode);
        queue.addLast(null);
        int layer = 0;
        while ((double)layer <= radius) {
            Turtle curNode = (Turtle)queue.removeFirst();
            if (curNode == null) {
                if (queue.isEmpty()) break;
                ++layer;
                queue.addLast(null);
                continue;
            }
            visited.add(curNode);
            AgentSet neighborSet = this.linkManager.findLinkedWith(curNode, linkBreed);
            AgentSet.Iterator it = neighborSet.iterator();
            while (it.hasNext()) {
                Turtle toAdd = (Turtle)it.next();
                if (seen.contains(toAdd)) continue;
                seen.add(toAdd);
                queue.add(toAdd);
            }
        }
        queue.clear();
        seen.clear();
        HashSet<Turtle> result = new HashSet<Turtle>();
        for (Turtle node : visited) {
            if (!sourceSet.contains(node)) continue;
            result.add(node);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public int networkDistance(Turtle sourceNode, Turtle destNode, AgentSet linkBreed) {
        isDirectedBreed = linkBreed.isDirected();
        seen = new HashSet<Turtle>();
        queue = new LinkedList<Turtle>();
        queue.addLast(sourceNode);
        seen.add(sourceNode);
        queue.addLast(null);
        layer = 0;
        block0: while (true) {
            if ((curNode = (Turtle)queue.removeFirst()) == null) {
                if (queue.isEmpty()) break;
                ++layer;
                queue.addLast(null);
                continue;
            }
            if (curNode == destNode) {
                return layer;
            }
            neighborSet = isDirectedBreed != false ? this.linkManager.findLinkedFrom(curNode, linkBreed) : this.linkManager.findLinkedWith(curNode, linkBreed);
            it = neighborSet.iterator();
            while (true) {
                if (it.hasNext()) ** break;
                continue block0;
                toAdd = (Turtle)it.next();
                if (seen.contains(toAdd)) continue;
                seen.add(toAdd);
                queue.add(toAdd);
            }
            break;
        }
        return -1;
    }

    public LogoList networkShortestPathNodes(MersenneTwisterFast random, Turtle sourceNode, Turtle destNode, AgentSet linkBreed) {
        LogoList path = new LogoList();
        if (sourceNode.equals(destNode)) {
            path.add(sourceNode);
            return path;
        }
        boolean isDirectedBreed = linkBreed.isDirected();
        HashMap<Turtle, Turtle> seenParents = new HashMap<Turtle, Turtle>();
        LinkedList<Turtle> queue = new LinkedList<Turtle>();
        queue.addLast(sourceNode);
        seenParents.put(sourceNode, null);
        while (!queue.isEmpty()) {
            Turtle curNode = (Turtle)queue.removeFirst();
            AgentSet neighborSet = isDirectedBreed ? this.linkManager.findLinkedFrom(curNode, linkBreed) : this.linkManager.findLinkedWith(curNode, linkBreed);
            AgentSet.Iterator it = neighborSet.shufflerator(random);
            while (it.hasNext()) {
                Turtle toAdd = (Turtle)it.next();
                if (toAdd.equals(destNode)) {
                    path = path.fput(destNode);
                    Turtle agt = curNode;
                    while (agt != null) {
                        path = path.fput(agt);
                        agt = (Turtle)seenParents.get(agt);
                    }
                    return path;
                }
                if (seenParents.containsKey(toAdd)) continue;
                seenParents.put(toAdd, curNode);
                queue.add(toAdd);
            }
        }
        return path;
    }

    public LogoList networkShortestPathLinks(MersenneTwisterFast random, Turtle sourceNode, Turtle destNode, AgentSet linkBreed) {
        LogoList pathNodes = this.networkShortestPathNodes(random, sourceNode, destNode, linkBreed);
        LogoList pathLinks = new LogoList();
        if (pathNodes.size() <= 1) {
            return pathLinks;
        }
        Iterator<Object> it = pathNodes.iterator();
        Turtle t1 = (Turtle)it.next();
        while (it.hasNext()) {
            Turtle t2 = (Turtle)it.next();
            pathLinks.add(this.linkManager.findLink(t1, t2, linkBreed, true));
            t1 = t2;
        }
        return pathLinks;
    }

    /*
     * Unable to fully structure code
     */
    public double averagePathLength(AgentSet nodeSet, AgentSet linkBreed) {
        seen = new HashSet<Turtle>();
        queue = new LinkedList<Turtle>();
        totalSum = 0L;
        it2 = nodeSet.iterator();
        while (it2.hasNext()) {
            agt = (Turtle)it2.next();
            nodeSetVisitedCount = 0;
            seen.clear();
            seen.add(agt);
            queue.addLast(agt);
            queue.addLast(null);
            layer = 0;
            block1: while (true) {
                if ((curNode = (Turtle)queue.removeFirst()) == null) {
                    if (queue.isEmpty()) break;
                    ++layer;
                    queue.addLast(null);
                    continue;
                }
                if (nodeSet.contains(curNode)) {
                    totalSum += (long)layer;
                    ++nodeSetVisitedCount;
                }
                neighborSet = this.linkManager.findLinkedWith(curNode, linkBreed);
                it = neighborSet.iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block1;
                    toAdd = (Turtle)it.next();
                    if (seen.contains(toAdd)) continue;
                    seen.add(toAdd);
                    queue.add(toAdd);
                }
                break;
            }
            if (nodeSetVisitedCount == nodeSet.count()) continue;
            return -1.0;
        }
        nodeCount = nodeSet.count();
        if (nodeCount == 1) {
            return 0.0;
        }
        return (double)totalSum / (double)(nodeCount * (nodeCount - 1));
    }
}

