/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.HeadingSmoother;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Link;
import org.nlogo.api.LogoException;
import org.nlogo.api.Perspective;
import org.nlogo.api.ValueConstraint;
import org.nlogo.api.Vect;
import org.nlogo.api.Version;
import org.nlogo.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Observer
extends Agent
implements org.nlogo.api.Observer {
    final HeadingSmoother headingSmoother = new HeadingSmoother();
    Perspective perspective = Perspective.OBSERVE;
    org.nlogo.api.Agent targetAgent = null;
    double oxcor;
    double oycor;
    double ozcor;
    double heading;
    double pitch;
    double roll;
    Vect rotationPoint;
    int followDistance = 5;

    public Observer(World world) {
        super(world);
        this.resetPerspective();
    }

    @Override
    Agent realloc(boolean forRecompile) {
        int i;
        Object[] oldvars = this.variables;
        Object[] newvars = new Object[this.world.getVariablesArraySize(this)];
        ValueConstraint[] newcons = new ValueConstraint[this.world.getVariablesArraySize(this)];
        for (i = 0; newvars.length != i; ++i) {
            newvars[i] = World.ZERO;
            newcons[i] = null;
        }
        if (oldvars != null && forRecompile) {
            for (i = 0; i < oldvars.length && i < this.world.oldGlobals.size(); ++i) {
                String name = this.world.oldGlobals.get(i);
                int newpos = this.world.observerOwnsIndexOf(name);
                if (newpos == -1) continue;
                newvars[newpos] = oldvars[i];
            }
        }
        this.variables = newvars;
        this.variableConstraints = newcons;
        return null;
    }

    @Override
    public Object getVariable(int vn) {
        return this.variables[vn];
    }

    @Override
    public Object getObserverVariable(int vn) {
        return this.variables[vn];
    }

    @Override
    public Object getTurtleVariable(int vn) throws AgentException {
        throw new AgentException("the observer can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getTurtleOrLinkVariable(String varName) throws AgentException {
        throw new AgentException("the observer can't access a turtle or link variable without specifying which agent");
    }

    @Override
    public Object getBreedVariable(String name) throws AgentException {
        throw new AgentException("the observer can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getLinkVariable(int vn) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public Object getLinkBreedVariable(String name) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public Object getPatchVariable(int vn) throws AgentException {
        throw new AgentException("the observer can't access a patch variable without specifying which patch");
    }

    @Override
    public void setVariable(int vn, Object value) throws AgentException, LogoException {
        this.setObserverVariable(vn, value);
    }

    public void assertVariableConstraint(int vn, Object value) throws AgentException, LogoException {
        ValueConstraint con = this.variableConstraint(vn);
        if (con != null) {
            con.assertConstraint(value);
        }
    }

    @Override
    public void setObserverVariable(int vn, Object value) throws AgentException, LogoException {
        this.assertVariableConstraint(vn, value);
        if (Version.isLoggingEnabled()) {
            Logger.logGlobal(this.world.program().globals.get(vn).toString(), value, !value.equals(this.variables[vn]));
        }
        this.variables[vn] = value;
    }

    @Override
    public void setTurtleVariable(int vn, Object value) throws AgentException {
        throw new AgentException("the observer can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException("the observer can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setPatchVariable(int vn, Object value) throws AgentException {
        throw new AgentException("the observer can't set a patch variable without specifying which turtle");
    }

    @Override
    public void setLinkVariable(int vn, Object value) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public void setLinkBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public void setTurtleOrLinkVariable(String varName, Object value) throws AgentException {
        throw new AgentException("the observer can't access a turtle or link variable without specifying which agent");
    }

    @Override
    public Perspective perspective() {
        return this.perspective;
    }

    public void perspective(Perspective perspective) {
        this.perspective = perspective;
    }

    @Override
    public org.nlogo.api.Agent targetAgent() {
        return this.targetAgent;
    }

    public void targetAgent(org.nlogo.api.Agent agent) {
        this.targetAgent = agent;
    }

    @Override
    public double oxcor() {
        return this.oxcor;
    }

    @Override
    public double oycor() {
        return this.oycor;
    }

    @Override
    public double ozcor() {
        return this.ozcor;
    }

    public double followOffsetX() {
        if (this.perspective == Perspective.FOLLOW || this.perspective == Perspective.RIDE) {
            return this.oxcor - ((double)this.world.minPxcor() - 0.5 + (double)this.world.worldWidth() / 2.0);
        }
        return 0.0;
    }

    public double followOffsetY() {
        if (this.perspective == Perspective.FOLLOW || this.perspective == Perspective.RIDE) {
            return this.oycor - ((double)this.world.minPycor() - 0.5 + (double)this.world.worldHeight() / 2.0);
        }
        return 0.0;
    }

    @Override
    public double heading() {
        return this.heading;
    }

    public void heading(double heading) {
        this.heading = (heading % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double pitch() {
        return this.pitch;
    }

    public void pitch(double pitch) {
        this.pitch = (pitch % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double roll() {
        return this.roll;
    }

    public void roll(double roll) {
        this.roll = (roll % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double dist() {
        return StrictMath.sqrt((this.rotationPoint.x() - this.oxcor) * (this.rotationPoint.x() - this.oxcor) + (this.rotationPoint.y() - this.oycor) * (this.rotationPoint.y() - this.oycor) + (this.rotationPoint.z() - this.ozcor) * (this.rotationPoint.z() - this.ozcor));
    }

    public void setRotationPoint(double x, double y, double z) {
        this.rotationPoint = new Vect(x, y, z);
    }

    public void setRotationPoint(org.nlogo.api.Agent agent) {
        if (agent instanceof org.nlogo.api.Turtle) {
            org.nlogo.api.Turtle t = (org.nlogo.api.Turtle)agent;
            this.setRotationPoint(t.xcor(), t.ycor(), 0.0);
        } else if (agent instanceof Link) {
            Link link = (Link)agent;
            this.setRotationPoint(link.midpointX(), link.midpointY(), 0.0);
        } else {
            org.nlogo.api.Patch p = (org.nlogo.api.Patch)agent;
            this.setRotationPoint(p.pxcor(), p.pycor(), 0.0);
        }
    }

    @Override
    public int followDistance() {
        return this.followDistance;
    }

    public void followDistance(int followDistance) {
        this.followDistance = followDistance;
    }

    public void oxyandzcor(double oxcor, double oycor, double ozcor) {
        this.oxcor = oxcor;
        this.oycor = oycor;
        this.ozcor = ozcor;
    }

    @Override
    public double dx() {
        double value = StrictMath.cos(StrictMath.toRadians(this.pitch)) * StrictMath.sin(StrictMath.toRadians(this.heading));
        if (StrictMath.abs(value) < 3.2E-15) {
            value = 0.0;
        }
        return value;
    }

    @Override
    public double dy() {
        double value = StrictMath.cos(StrictMath.toRadians(this.pitch)) * StrictMath.cos(StrictMath.toRadians(this.heading));
        if (StrictMath.abs(value) < 3.2E-15) {
            value = 0.0;
        }
        return value;
    }

    @Override
    public double dz() {
        double value = StrictMath.sin(StrictMath.toRadians(this.pitch));
        if (StrictMath.abs(value) < 3.2E-15) {
            value = 0.0;
        }
        return value;
    }

    public void face(org.nlogo.api.Agent agent) {
        try {
            this.heading(this.world.protractor.towards(this, agent, false));
        }
        catch (AgentException ex) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor.towardsPitch(this, agent, false));
        }
        catch (AgentException ex) {
            this.pitch(0.0);
        }
        this.setRotationPoint(agent);
    }

    public void face(double x, double y) {
        try {
            this.heading(this.world.protractor.towards(this, x, y, false));
        }
        catch (AgentException ex) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor.towardsPitch(this, x, y, 0.0, false));
        }
        catch (AgentException ex) {
            this.pitch(0.0);
        }
        this.setRotationPoint(x, y, 0.0);
    }

    public void moveto(Agent otherAgent) throws AgentException {
        if (otherAgent instanceof Turtle) {
            Turtle t = (Turtle)otherAgent;
            this.oxyandzcor(t.xcor(), t.ycor(), 0.0);
        } else if (otherAgent instanceof Patch) {
            Patch p = (Patch)otherAgent;
            this.oxyandzcor(p.pxcor, p.pycor, 0.0);
        } else {
            throw new AgentException("you can't move-to a link");
        }
        this.face(this.rotationPoint.x(), this.rotationPoint.y());
    }

    @Override
    public void setPerspective(Perspective perspective, org.nlogo.api.Agent agent) {
        this.perspective = perspective;
        this.targetAgent = agent;
        this.updatePosition();
    }

    public boolean updatePosition() {
        boolean changed = false;
        if (this.perspective == Perspective.OBSERVE) {
            return false;
        }
        if (this.perspective == Perspective.WATCH) {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            this.setRotationPoint(this.targetAgent);
            this.face(this.targetAgent);
        } else {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            Turtle turtle2 = (Turtle)this.targetAgent;
            this.oxyandzcor(turtle2.xcor(), turtle2.ycor(), 0.0);
            double newHeading = this.headingSmoother.follow(this.targetAgent);
            if (this.perspective == Perspective.FOLLOW) {
                changed = this.heading != newHeading;
                this.heading(newHeading);
            } else {
                this.heading(turtle2.heading());
            }
            this.pitch(0.0);
            this.roll(0.0);
        }
        return changed;
    }

    public void resetPerspective() {
        this.setPerspective(Perspective.OBSERVE, null);
        this.home();
    }

    public void home() {
        this.oxcor = (double)this.world.minPxcor() + (double)(this.world.maxPxcor() - this.world.minPxcor()) / 2.0;
        this.oycor = (double)this.world.minPycor() + (double)(this.world.maxPycor() - this.world.minPycor()) / 2.0;
        this.ozcor = (double)StrictMath.max(this.world.worldWidth(), this.world.worldHeight()) * 1.5;
        this.heading = 0.0;
        this.pitch = 90.0;
        this.roll = 0.0;
        this.setRotationPoint(this.oxcor, this.oycor, 0.0);
    }

    public boolean atHome2D() {
        return this.perspective == Perspective.OBSERVE && this.oxcor == 0.0 && this.oycor == 0.0;
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        return this.world.getPatchAt(dx, dy);
    }

    public String toString() {
        return "observer";
    }

    @Override
    public String classDisplayName() {
        return "observer";
    }

    public Class<Observer> getAgentClass() {
        return Observer.class;
    }

    @Override
    public int getAgentBit() {
        return 1;
    }

    @Override
    public String shape() {
        return "";
    }

    @Override
    public double size() {
        return 0.0;
    }
}

