/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Patch
extends Agent
implements org.nlogo.api.Patch {
    public static final int VAR_PXCOR = 0;
    public static final int VAR_PYCOR = 1;
    public int NUMBER_PREDEFINED_VARS = 5;
    public final List<Turtle> turtlesHere = new ArrayList<Turtle>(0);
    public AgentSet patchNeighbors;
    public AgentSet patchNeighbors4;
    double pcolor = 0.0;
    public final int pxcor;
    public final int pycor;

    void topologyChanged() {
        this.patchNeighbors = null;
        this.patchNeighbors4 = null;
    }

    Patch(World world, int id, int pxcor, int pycor, int numVariables) {
        super(world);
        this.id = id;
        this.pxcor = pxcor;
        this.pycor = pycor;
        this.variables = new Object[numVariables];
        block6: for (int i = 0; i < numVariables; ++i) {
            switch (i) {
                case 0: {
                    this.variables[i] = (double)pxcor;
                    continue block6;
                }
                case 1: {
                    this.variables[i] = (double)pycor;
                    continue block6;
                }
                case 3: {
                    this.variables[i] = "";
                    continue block6;
                }
                case 4: {
                    this.variables[i] = Color.BOXED_WHITE;
                    continue block6;
                }
                default: {
                    this.variables[i] = World.ZERO;
                }
            }
        }
    }

    Patch(World world, int pxcor, int pycor) {
        super(world);
        this.pxcor = pxcor;
        this.pycor = pycor;
    }

    @Override
    Agent realloc(boolean forRecompile) {
        int i;
        Object[] oldvars = this.variables;
        Object[] newvars = new Object[this.world.getVariablesArraySize(this)];
        for (i = 0; newvars.length != i; ++i) {
            newvars[i] = i < this.NUMBER_PREDEFINED_VARS ? oldvars[i] : World.ZERO;
        }
        if (forRecompile) {
            for (i = this.NUMBER_PREDEFINED_VARS; i < oldvars.length && i < this.world.oldPatchesOwn.size(); ++i) {
                String name = this.world.oldPatchesOwn.get(i);
                int newpos = this.world.patchesOwnIndexOf(name);
                if (newpos == -1) continue;
                newvars[newpos] = oldvars[i];
            }
        }
        this.variables = newvars;
        return null;
    }

    @Override
    public Object getObserverVariable(int vn) {
        return this.world.observer().getObserverVariable(vn);
    }

    @Override
    public Object getTurtleVariable(int vn) throws AgentException {
        throw new AgentException("a patch can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getLinkVariable(int vn) throws AgentException {
        throw new AgentException("a patch can't access a link variable without specifying which link");
    }

    @Override
    public Object getTurtleOrLinkVariable(String varName) throws AgentException {
        throw new AgentException("a patch can't access a turtle or link variable without specifying which agent");
    }

    @Override
    public Object getLinkBreedVariable(String name) throws AgentException {
        throw new AgentException("a patch can't access a link variable without specifying which link");
    }

    @Override
    public Object getBreedVariable(String name) throws AgentException {
        throw new AgentException("a patch can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getVariable(int vn) {
        return this.getPatchVariable(vn);
    }

    @Override
    public void setObserverVariable(int vn, Object value) throws AgentException, LogoException {
        this.world.observer().setObserverVariable(vn, value);
    }

    @Override
    public void setTurtleVariable(int vn, Object value) throws AgentException {
        throw new AgentException("a patch can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException("a patch can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setLinkVariable(int vn, Object value) throws AgentException {
        throw new AgentException("a patch can't access a link variable without specifying which link");
    }

    @Override
    public void setTurtleOrLinkVariable(String varName, Object value) throws AgentException {
        throw new AgentException("a patch can't access a turtle or link variable without specifying which agent");
    }

    @Override
    public void setLinkBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException("a patch can't access a link variable without specifying which link");
    }

    @Override
    public void setVariable(int vn, Object value) throws AgentException {
        this.setPatchVariable(vn, value);
    }

    @Override
    public void setPatchVariable(int n, Object object) throws AgentException {
        if (n > 4) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 2: {
                    if (object instanceof Double) {
                        this.pcolor((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.pcolor((LogoList)object, 2, false);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(false)[n], Double.class, object);
                    break;
                }
                case 3: {
                    this.label(object);
                    break;
                }
                case 4: {
                    if (object instanceof Double) {
                        this.labelColor((double)((Double)object));
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object, 4);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(false)[n], Double.class, object);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AgentException("you can't change a patch's coordinates");
                }
                default: {
                    throw new IllegalStateException("unknown variable " + n);
                }
            }
        }
    }

    @Override
    public Object getPatchVariable(int vn) {
        if (vn == 2 && this.variables[2] == null) {
            this.variables[2] = this.pcolor;
        }
        return this.variables[vn];
    }

    public double getPatchVariableDouble(int vn) {
        switch (vn) {
            case 0: {
                return this.pxcor;
            }
            case 1: {
                return this.pycor;
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        Patch target = this.world.getTopology().getPatchAt((double)this.pxcor + dx, (double)this.pycor + dy);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    public Patch fastGetPatchAt(int x, int y) {
        return this.world.fastGetPatchAt(x, y);
    }

    public AgentSet getNeighbors() {
        if (this.patchNeighbors == null) {
            this.patchNeighbors = this.world.getTopology().getNeighbors(this);
        }
        return this.patchNeighbors;
    }

    public AgentSet getNeighbors4() {
        if (this.patchNeighbors4 == null) {
            this.patchNeighbors4 = this.world.getTopology().getNeighbors4(this);
        }
        return this.patchNeighbors4;
    }

    public Turtle sprout(int c, int heading, AgentSet breed) {
        Turtle child = new Turtle(this.world, breed, (Double)this.variables[0], (Double)this.variables[1]);
        double color = 5 + 10 * c;
        child.colorDoubleUnchecked(color);
        child.heading(heading);
        return child;
    }

    public double pcolorDouble() {
        if (this.variables[2] == null || this.variables[2] instanceof Double) {
            return this.pcolor;
        }
        throw new IllegalStateException("pcolor is not a double");
    }

    @Override
    public Object pcolor() {
        if (this.variables[2] == null) {
            this.variables[2] = this.pcolor;
        }
        return this.variables[2];
    }

    public void pcolor(double pcolor) {
        if (pcolor < 0.0 || pcolor >= 140.0) {
            pcolor = Color.modulateDouble(pcolor);
        }
        if (this.pcolor != pcolor) {
            this.pcolor = pcolor;
            this.variables[2] = null;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(pcolor);
            this.world.patchColorsDirty = true;
            if (pcolor != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolor(Double boxedColor) {
        double color = boxedColor;
        if (color < 0.0 || color >= 140.0) {
            if (this.pcolor != (color = Color.modulateDouble(color))) {
                this.pcolor = color;
                this.variables[2] = null;
                this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
                this.world.patchColorsDirty = true;
                if (this.pcolor != 0.0) {
                    this.world.patchesAllBlack = false;
                }
            }
        } else if (this.pcolor != color) {
            this.pcolor = color;
            this.variables[2] = boxedColor;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
            this.world.patchColorsDirty = true;
            if (this.pcolor != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolorDoubleUnchecked(Double boxedColor) {
        double color = boxedColor;
        if (color != this.pcolor) {
            this.pcolor = color;
            this.variables[2] = boxedColor;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(color);
            this.world.patchColorsDirty = true;
            if (color != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolor(LogoList rgb) throws AgentException {
        this.pcolor(rgb, 2, true);
    }

    public void pcolor(LogoList rgb, int varIndex, boolean allowAlpha) throws AgentException {
        this.validRGBList(rgb, allowAlpha);
        this.pcolor = Double.NaN;
        if (!(this.variables[varIndex] instanceof LogoList) || !rgb.equals(this.variables[varIndex])) {
            this.variables[varIndex] = rgb;
            this.world.patchColors[(int)this.id] = Color.getRGBInt(((Double)rgb.get(0)).intValue(), ((Double)rgb.get(1)).intValue(), ((Double)rgb.get(2)).intValue());
            this.world.patchColorsDirty = true;
            this.world.patchesAllBlack = false;
        }
    }

    @Override
    public int pxcor() {
        return this.pxcor;
    }

    @Override
    public int pycor() {
        return this.pycor;
    }

    public Object label() {
        return this.variables[3];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables[3]);
    }

    public void label(Object label) {
        if (label instanceof String && ((String)label).length() == 0) {
            if (this.hasLabel()) {
                --this.world.patchesWithLabels;
            }
        } else if (!this.hasLabel()) {
            ++this.world.patchesWithLabels;
        }
        this.variables[3] = label;
    }

    @Override
    public Object labelColor() {
        return this.variables[4];
    }

    public void labelColor(double labelColor) {
        this.variables[4] = Color.modulateDouble(labelColor);
    }

    public void labelColor(Double labelColor) {
        this.variables[4] = labelColor;
    }

    public void labelColor(LogoList rgb, int varIndex) throws AgentException {
        this.validRGBList(rgb, true);
        this.variables[varIndex] = rgb;
    }

    public String toString() {
        return "patch " + this.pxcor + " " + this.pycor;
    }

    @Override
    public String classDisplayName() {
        return "patch";
    }

    public Class<Patch> getAgentClass() {
        return Patch.class;
    }

    @Override
    public int getAgentBit() {
        return 4;
    }

    @Override
    public String shape() {
        return "";
    }

    @Override
    public double size() {
        return 1.0;
    }

    public Patch getPatchNorth() {
        return this.world.getTopology().getPN(this);
    }

    public Patch getPatchSouth() {
        return this.world.getTopology().getPS(this);
    }

    public Patch getPatchEast() {
        return this.world.getTopology().getPE(this);
    }

    public Patch getPatchWest() {
        return this.world.getTopology().getPW(this);
    }

    public Patch getPatchNorthWest() {
        return this.world.getTopology().getPNW(this);
    }

    public Patch getPatchSouthWest() {
        return this.world.getTopology().getPSW(this);
    }

    public Patch getPatchSouthEast() {
        return this.world.getTopology().getPSE(this);
    }

    public Patch getPatchNorthEast() {
        return this.world.getTopology().getPNE(this);
    }
}

