/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology;
import org.nlogo.agent.TrigTables;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

public strictfp class Protractor
implements org.nlogo.api.Protractor {
    private final World world;

    Protractor(World world) {
        this.world = world;
    }

    public double distanceToLink(Link link, double x, double y) {
        double ydiff;
        double xdiff;
        double[] p;
        double y2;
        double x2;
        double y1;
        double x1 = link.x1();
        if (this.inBounds(x1, y1 = link.y1(), x2 = link.x2(), y2 = link.y2(), (p = this.closestPoint(x, y, x1, y1, xdiff = x2 - x1, ydiff = y2 - y1))[0], p[1])) {
            return this.distance(p[0], p[1], x, y, true);
        }
        double tmpx = x;
        double tmpy = y;
        if (x2 < (double)this.world.minPxcor) {
            x -= (double)this.world.worldWidth;
        } else if (x2 > (double)this.world.maxPxcor) {
            x += (double)this.world.worldWidth;
        }
        p = this.closestPoint(x, y, x1, y1, xdiff, ydiff);
        if (this.inBounds(x1, y1, x2, y2, p[0], p[1])) {
            return this.distance(p[0], p[1], x, y, true);
        }
        if (y2 < (double)this.world.minPycor) {
            y -= (double)this.world.worldHeight;
        } else if (y2 > (double)this.world.maxPycor) {
            y += (double)this.world.worldHeight;
        }
        p = this.closestPoint(x, y, x1, y1, xdiff, ydiff);
        if (this.inBounds(x1, y1, x2, y2, p[0], p[1])) {
            return this.distance(p[0], p[1], x, y, true);
        }
        x = tmpx;
        y = tmpy;
        p = this.closestPoint(x, y, x1, y1, xdiff, ydiff);
        if (this.inBounds(x1, y1, x2, y2, p[0], p[1])) {
            return this.distance(p[0], p[1], x, y, true);
        }
        return StrictMath.min(this.distance(x1, y1, x, y, true), this.distance(x2, y2, x, y, true));
    }

    private double[] closestPoint(double x, double y, double x1, double y1, double xdiff, double ydiff) {
        double u = ((x - x1) * xdiff + (y - y1) * ydiff) / (xdiff * xdiff + ydiff * ydiff);
        double xprime = x1 + u * xdiff;
        double yprime = y1 + u * ydiff;
        return new double[]{xprime, yprime};
    }

    public boolean inBounds(double x1, double y1, double x2, double y2, double x, double y) {
        double left;
        double right;
        double bottom;
        double top;
        if (y1 > y2) {
            top = y1;
            bottom = y2;
        } else {
            top = y2;
            bottom = y1;
        }
        if (x1 > x2) {
            right = x1;
            left = x2;
        } else {
            right = x2;
            left = x1;
        }
        return x <= right && x >= left && y <= top && y >= bottom;
    }

    public double distance(org.nlogo.api.Agent agent, double x2, double y2, boolean wrap) {
        double y1;
        double x1;
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            x1 = turtle2.xcor();
            y1 = turtle2.ycor();
        } else {
            if (agent instanceof Link) {
                return this.distanceToLink((Link)agent, x2, y2);
            }
            Patch patch = (Patch)agent;
            x1 = patch.pxcor;
            y1 = patch.pycor;
        }
        return this.distance(x1, y1, x2, y2, wrap);
    }

    public double distance(org.nlogo.api.Agent agent1, org.nlogo.api.Agent agent2, boolean wrap) {
        double y1;
        double x1;
        if (agent1 instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent1;
            x1 = turtle2.xcor();
            y1 = turtle2.ycor();
        } else {
            Patch patch = (Patch)agent1;
            x1 = patch.pxcor;
            y1 = patch.pycor;
        }
        return this.distance(agent2, x1, y1, wrap);
    }

    public double distance(double x1, double y1, double x2, double y2, boolean wrap) {
        double distanceWrap;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double distanceNoWrap = this.world.rootsTable.gridRoot(dx * dx + dy * dy);
        if (wrap && (distanceWrap = this.world.topology.distanceWrap(dx, dy, x1, y1, x2, y2)) < distanceNoWrap) {
            return distanceWrap;
        }
        return distanceNoWrap;
    }

    public Patch getPatchAtHeadingAndDistance(Agent a, double heading, double distance) throws AgentException {
        if (a instanceof Turtle) {
            Turtle t = (Turtle)a;
            return this.getPatchAtHeadingAndDistance(t.xcor(), t.ycor(), heading, distance);
        }
        Patch p = (Patch)a;
        return this.getPatchAtHeadingAndDistance(p.pxcor, p.pycor, heading, distance);
    }

    public Patch getPatchAtHeadingAndDistance(double x, double y, double heading, double distance) throws AgentException {
        double sin;
        double cos;
        int integerHeading = (int)heading;
        if (heading == (double)integerHeading) {
            cos = TrigTables.cos[integerHeading];
            sin = TrigTables.sin[integerHeading];
        } else {
            double headingRadians = StrictMath.toRadians(heading);
            cos = StrictMath.cos(headingRadians);
            sin = StrictMath.sin(headingRadians);
            if (StrictMath.abs(cos) < 3.2E-15) {
                cos = 0.0;
            }
            if (StrictMath.abs(sin) < 3.2E-15) {
                sin = 0.0;
            }
        }
        return this.world.getPatchAt(x + distance * sin, y + distance * cos);
    }

    public double towards(org.nlogo.api.Agent fromAgent, org.nlogo.api.Agent toAgent, boolean wrap) throws AgentException {
        double y;
        double x;
        if (fromAgent == toAgent) {
            throw new AgentException("no heading is defined from an agent to itself");
        }
        if (toAgent instanceof Turtle) {
            Turtle turtle2 = (Turtle)toAgent;
            x = turtle2.xcor();
            y = turtle2.ycor();
        } else if (toAgent instanceof Link) {
            Link link = (Link)toAgent;
            x = link.midpointX();
            y = link.midpointY();
        } else {
            Patch patch = (Patch)toAgent;
            x = patch.pxcor;
            y = patch.pycor;
        }
        return this.towards(fromAgent, x, y, wrap);
    }

    public double towards(org.nlogo.api.Agent fromAgent, double toX, double toY, boolean wrap) throws AgentException {
        double fromY;
        double fromX;
        if (fromAgent instanceof Turtle) {
            Turtle turtle2 = (Turtle)fromAgent;
            fromX = turtle2.xcor();
            fromY = turtle2.ycor();
        } else if (fromAgent instanceof Observer) {
            Observer obs = (Observer)fromAgent;
            fromX = obs.oxcor();
            fromY = obs.oycor();
        } else if (fromAgent instanceof Patch) {
            Patch patch = (Patch)fromAgent;
            fromX = patch.pxcor;
            fromY = patch.pycor;
        } else {
            throw new IllegalStateException("In towards: fromAgent must not be a link");
        }
        return this.towards(fromX, fromY, toX, toY, wrap);
    }

    public double towards(double fromX, double fromY, double toX, double toY, boolean wrap) throws AgentException {
        if (fromX == toX && fromY == toY) {
            throw new AgentException("no heading is defined from a point (" + fromX + "," + fromY + ") to that same point");
        }
        double dx = toX - fromX;
        double dy = toY - fromY;
        if (wrap) {
            return this.world.topology.towardsWrap(dx, dy);
        }
        if (dx == 0.0) {
            return dy > 0.0 ? 0.0 : 180.0;
        }
        if (dy == 0.0) {
            return dx > 0.0 ? 90.0 : 270.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-dy, dx))) % 360.0;
    }

    public double towardsPitch(org.nlogo.api.Agent fromAgent, org.nlogo.api.Agent toAgent, boolean wrap) throws AgentException {
        double z;
        double y;
        double x;
        if (fromAgent == toAgent) {
            throw new AgentException("no pitch is defined from an agent to itself");
        }
        if (toAgent instanceof Turtle) {
            Turtle turtle2 = (Turtle)toAgent;
            x = turtle2.xcor();
            y = turtle2.ycor();
            z = 0.0;
        } else if (toAgent instanceof Link) {
            Link link = (Link)toAgent;
            x = link.midpointX();
            y = link.midpointY();
            z = 0.0;
        } else {
            Patch patch = (Patch)toAgent;
            x = patch.pxcor;
            y = patch.pycor;
            z = 0.0;
        }
        return this.towardsPitch(fromAgent, x, y, z, wrap);
    }

    public double towardsPitch(org.nlogo.api.Agent fromAgent, double toX, double toY, double toZ, boolean wrap) throws AgentException {
        if (fromAgent instanceof Observer) {
            Observer obs = (Observer)fromAgent;
            double fromX = obs.oxcor();
            double fromY = obs.oycor();
            double fromZ = obs.ozcor();
            return this.towardsPitch(fromX, fromY, fromZ, toX, toY, toZ, wrap);
        }
        throw new IllegalStateException("In towardsPitch: fromAgent must be the observer");
    }

    public double towardsPitch(double fromX, double fromY, double fromZ, double toX, double toY, double toZ, boolean wrap) throws AgentException {
        if (fromX == toX && fromY == toY && fromZ == toZ) {
            throw new AgentException("no pitch is defined from a point (" + fromX + "," + fromY + "," + fromZ + ") to that same point");
        }
        double dx = toX - fromX;
        double dy = toY - fromY;
        double dz = toZ - fromZ;
        if (wrap) {
            dx = Topology.wrap(dx, (double)this.world.minPxcor - 0.5, (double)this.world.maxPxcor + 0.5);
            dy = Topology.wrap(dy, (double)this.world.minPycor - 0.5, (double)this.world.maxPycor + 0.5);
        }
        return StrictMath.toDegrees(StrictMath.atan(dz / StrictMath.sqrt(dx * dx + dy * dy)));
    }
}

