/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Iterator;
import java.util.Set;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.TrigTables;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.Shape;
import org.nlogo.api.Version;
import org.nlogo.log.Logger;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Turtle
extends Agent
implements org.nlogo.api.Turtle {
    public int LAST_PREDEFINED_VAR = 12;
    public int NUMBER_PREDEFINED_VARS = this.LAST_PREDEFINED_VAR + 1;
    Patch currentPatch = null;
    double heading = 0.0;
    double cachedHeading = 0.0;
    double cachedSine = 0.0;
    double cachedCosine = 1.0;
    double xcor;
    double ycor;
    Shape cachedShape;

    void id(long id) {
        this.id = id;
        this.variables[0] = (double)id;
    }

    void initvars(Double xcor, Double ycor, AgentSet breed) {
        this.variables[1] = Color.BOXED_BLACK;
        this.heading = 0.0;
        this.variables[2] = World.ZERO;
        this.xcor = xcor;
        this.variables[3] = xcor;
        this.ycor = ycor;
        this.variables[4] = ycor;
        this.variables[5] = this.world.turtleBreedShapes.breedShape(breed);
        this.variables[6] = "";
        this.variables[7] = Color.BOXED_WHITE;
        this.variables[8] = breed;
        this.variables[9] = Boolean.FALSE;
        this.variables[10] = World.ONE;
        this.variables[11] = World.ONE;
        this.variables[12] = "up";
    }

    public Turtle(World world, AgentSet breed, Double xcor, Double ycor) {
        this(world, breed, xcor, ycor, true);
    }

    private Turtle(World world, AgentSet breed, Double xcor, Double ycor, boolean getId) {
        super(world);
        this.variables = new Object[world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)breed)];
        if (getId) {
            this.id(world.newTurtleId());
            world.turtles().add(this);
        }
        this.initvars(xcor, ycor, breed);
        for (int i = this.LAST_PREDEFINED_VAR + 1; i < this.variables.length; ++i) {
            this.variables[i] = World.ZERO;
        }
        if (breed != world.turtles()) {
            breed.add(this);
        }
        this.getPatchHere().turtlesHere.add(this);
        if (Version.isLoggingEnabled()) {
            Logger.logTurtleBirth(this.toString(), breed.printName());
        }
    }

    Turtle(World world, long id) {
        this(world, world.turtles(), World.ZERO, World.ZERO, false);
        this.id(id);
        world.turtles().add(this);
    }

    Turtle(World world) {
        super(world);
    }

    public Turtle hatch() {
        Turtle child = new Turtle(this.world);
        child.heading = this.heading;
        child.xcor = this.xcor;
        child.ycor = this.ycor;
        child.variables = (Object[])this.variables.clone();
        child.id(this.world.newTurtleId());
        this.world.turtles().add(child);
        if (this.getBreed() != this.world.turtles()) {
            this.getBreed().add(child);
        }
        child.getPatchHere().turtlesHere.add(child);
        if (Version.isLoggingEnabled()) {
            Logger.logTurtleBirth(this.toString(), this.getBreed().printName());
        }
        return child;
    }

    public void die() {
        if (this.id == -1L) {
            return;
        }
        if (Version.isLoggingEnabled()) {
            Logger.logTurtleDeath(this.toString(), this.getBreed().printName());
        }
        this.world.linkManager.cleanup(this);
        Patch patch = this.getPatchHere();
        patch.turtlesHere.remove(this);
        AgentSet breed = this.getBreed();
        if (breed != this.world.turtles()) {
            breed.remove(this.agentKey());
        }
        this.world.removeLineThickness(this);
        this.world.turtles().remove(this.agentKey());
        this.id(-1L);
        Observer observer = this.world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
    }

    @Override
    public double lineThickness() {
        if (this.world != null) {
            return this.world.lineThickness(this);
        }
        return 0.0;
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        Patch target = this.world.getTopology().getPatchAt(this.xcor + dx, this.ycor + dy);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    @Override
    Agent realloc(boolean compiling) {
        return this.realloc(compiling, null);
    }

    Agent realloc(boolean compiling, AgentSet oldBreed) {
        int oldpos;
        String name;
        int i;
        if (compiling && this.getBreed() != this.world.turtles() && this.world.getBreed(this.getBreed().printName()) == null) {
            return this;
        }
        Object[] oldvars = this.variables;
        this.variables = new Object[this.world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)this.getBreed())];
        int turtlesOwnSize = this.world.getVariablesArraySize((org.nlogo.api.Turtle)null, (org.nlogo.api.AgentSet)this.world.turtles());
        int numberToCopyDirectly = compiling ? this.NUMBER_PREDEFINED_VARS : turtlesOwnSize;
        System.arraycopy(oldvars, 0, this.variables, 0, numberToCopyDirectly);
        if (compiling) {
            for (i = this.NUMBER_PREDEFINED_VARS; i < turtlesOwnSize; ++i) {
                name = this.world.turtlesOwnNameAt(i);
                oldpos = this.world.oldTurtlesOwnIndexOf(name);
                if (oldpos == -1) {
                    this.variables[i] = World.ZERO;
                    continue;
                }
                this.variables[i] = oldvars[oldpos];
                oldvars[oldpos] = null;
            }
        }
        for (i = turtlesOwnSize; i < this.variables.length; ++i) {
            name = this.world.breedsOwnNameAt(this.getBreed(), i);
            int n = oldpos = compiling ? this.world.oldBreedsOwnIndexOf(this.getBreed(), name) : this.world.breedsOwnIndexOf(oldBreed, name);
            if (oldpos == -1) {
                this.variables[i] = World.ZERO;
                continue;
            }
            this.variables[i] = oldvars[oldpos];
            oldvars[oldpos] = null;
        }
        return null;
    }

    @Override
    public void jump(double distance) throws AgentException {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int integerHeading = (int)this.heading;
            if (this.heading == (double)integerHeading) {
                this.cachedCosine = TrigTables.cos[integerHeading];
                this.cachedSine = TrigTables.sin[integerHeading];
            } else {
                double headingRadians = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(headingRadians);
                this.cachedSine = StrictMath.sin(headingRadians);
            }
        }
        this.xandycor(this.xcor + distance * this.cachedSine, this.ycor + distance * this.cachedCosine);
    }

    public Patch getPatchAtHeadingAndDistance(double delta, double distance) throws AgentException {
        double h = this.heading + delta;
        if (h < 0.0 || h >= 360.0) {
            h = (h % 360.0 + 360.0) % 360.0;
        }
        return this.world.protractor.getPatchAtHeadingAndDistance(this, h, distance);
    }

    @Override
    public Patch getPatchHere() {
        if (this.currentPatch == null) {
            this.currentPatch = this.world.getPatchAtWrap(this.xcor, this.ycor);
        }
        return this.currentPatch;
    }

    private void mustOwn(String name) throws AgentException {
        if (name != null && !this.world.breedOwns(this.getBreed(), name)) {
            throw new AgentException(this.getBreed().printName() + " breed does not own variable " + name);
        }
    }

    @Override
    public Object getVariable(int vn) {
        return this.getTurtleVariable(vn);
    }

    @Override
    public void setVariable(int vn, Object value) throws AgentException {
        this.setTurtleVariable(vn, value);
    }

    @Override
    public Object getObserverVariable(int vn) {
        return this.world.observer().getObserverVariable(vn);
    }

    @Override
    public Object getTurtleOrLinkVariable(String varName) {
        return this.getTurtleVariable(this.world.program.turtlesOwn.indexOf(varName));
    }

    @Override
    public Object getTurtleVariable(int vn) {
        if (vn == 0) {
            if (this.variables[0] == null) {
                this.variables[0] = (double)this.id;
            }
        } else if (vn == 2) {
            if (this.variables[2] == null) {
                this.variables[2] = this.heading;
            }
        } else if (vn == 3) {
            if (this.variables[3] == null) {
                this.variables[3] = this.xcor;
            }
        } else if (vn == 4 && this.variables[4] == null) {
            this.variables[4] = this.ycor;
        }
        return this.variables[vn];
    }

    public double getTurtleVariableDouble(int vn) {
        switch (vn) {
            case 0: {
                return this.id;
            }
            case 2: {
                return this.heading;
            }
            case 3: {
                return this.xcor;
            }
            case 4: {
                return this.ycor;
            }
            case 10: {
                return this.size();
            }
            case 11: {
                return this.penSize();
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    @Override
    public Object getLinkBreedVariable(String name) throws AgentException {
        throw new AgentException("a turtle can't access a link variable without specifying which link");
    }

    @Override
    public Object getBreedVariable(String name) throws AgentException {
        this.mustOwn(name);
        int vn = this.world.breedsOwnIndexOf(this.getBreed(), name);
        return this.getTurtleVariable(vn);
    }

    @Override
    public Object getLinkVariable(int vn) throws AgentException {
        throw new AgentException("a turtle can't access a link variable without specifying which link");
    }

    @Override
    public Object getPatchVariable(int vn) {
        return this.getPatchHere().getPatchVariable(vn);
    }

    @Override
    public void setObserverVariable(int vn, Object value) throws AgentException, LogoException {
        this.world.observer().setObserverVariable(vn, value);
    }

    @Override
    public void setTurtleOrLinkVariable(String varName, Object value) throws AgentException {
        this.setTurtleVariable(this.world.program.turtlesOwn.indexOf(varName), value);
    }

    @Override
    public void setTurtleVariable(int n, Object object) throws AgentException {
        if (n > this.LAST_PREDEFINED_VAR) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 1: {
                    if (object instanceof Double) {
                        this.colorDouble((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.color((LogoList)object, 1);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 2: {
                    if (object instanceof Double) {
                        this.heading((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 3: {
                    if (object instanceof Double) {
                        this.xcor((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 4: {
                    if (object instanceof Double) {
                        this.ycor((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 5: {
                    if (object instanceof String) {
                        String string = this.world.checkTurtleShapeName((String)object);
                        if (string == null) {
                            throw new AgentException("\"" + (String)object + "\" is not a currently defined shape");
                        }
                        this.shape(string);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], String.class, object);
                    break;
                }
                case 6: {
                    this.label(object);
                    break;
                }
                case 7: {
                    if (object instanceof Double) {
                        this.labelColor((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object, 7);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 8: {
                    if (object instanceof AgentSet) {
                        AgentSet agentSet = (AgentSet)object;
                        if (agentSet != this.world.turtles() && !this.world.isBreed(agentSet)) {
                            throw new AgentException("can't set BREED to a non-breed agentset");
                        }
                        this.setBreed(agentSet);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], AgentSet.class, object);
                    break;
                }
                case 9: {
                    if (object instanceof Boolean) {
                        this.hidden((Boolean)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Boolean.class, object);
                    break;
                }
                case 10: {
                    if (object instanceof Double) {
                        this.size((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 12: {
                    if (object instanceof String) {
                        this.penMode((String)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], String.class, object);
                    break;
                }
                case 11: {
                    if (object instanceof Double) {
                        this.penSize((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 0: {
                    throw new AgentException("you can't change a turtle's ID number");
                }
                default: {
                    throw new IllegalStateException("unknown variable " + n);
                }
            }
        }
    }

    @Override
    public void setBreedVariable(String name, Object value) throws AgentException {
        this.mustOwn(name);
        int vn = this.world.breedsOwnIndexOf(this.getBreed(), name);
        this.setTurtleVariable(vn, value);
    }

    @Override
    public void setPatchVariable(int vn, Object value) throws AgentException {
        this.getPatchHere().setPatchVariable(vn, value);
    }

    @Override
    public void setLinkVariable(int vn, Object value) throws AgentException {
        throw new AgentException("a turtle can't set a link variable without specifying which link");
    }

    @Override
    public void setLinkBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException("a turtle can't set a link variable without specifying which link");
    }

    @Override
    public Object color() {
        return this.variables[1];
    }

    public void colorDouble(Double boxedColor) {
        double c = boxedColor;
        if (c < 0.0 || c >= 140.0) {
            c = Color.modulateDouble(c);
            boxedColor = c;
        }
        this.variables[1] = boxedColor;
    }

    public void colorDoubleUnchecked(Double boxedColor) {
        this.variables[1] = boxedColor;
    }

    public void color(LogoList rgb, int varIndex) throws AgentException {
        this.validRGBList(rgb, true);
        this.variables[varIndex] = rgb;
    }

    public void turnRight(double delta) {
        this.heading(this.heading + delta);
    }

    @Override
    public double heading() {
        return this.heading;
    }

    @Override
    public void heading(double heading) {
        double originalHeading = this.heading;
        this.headingHelper(heading);
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleTurned(this, heading, originalHeading);
        }
    }

    public void heading(double heading, Set<Turtle> seenTurtles) {
        double originalHeading = this.heading;
        this.headingHelper(heading);
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleTurned(this, heading, originalHeading, seenTurtles);
        }
    }

    private void headingHelper(double heading) {
        if (heading < 0.0 || heading >= 360.0) {
            heading = (heading % 360.0 + 360.0) % 360.0;
        }
        this.heading = heading;
        this.variables[2] = null;
        Observer observer = this.world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
    }

    public void heading(Double heading) {
        double originalHeading = this.heading;
        double h = heading;
        double wrapped = h < 0.0 || h >= 360.0 ? (h % 360.0 + 360.0) % 360.0 : h;
        this.heading = wrapped;
        this.variables[2] = h == wrapped ? heading : null;
        Observer observer = this.world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleTurned(this, h, originalHeading);
        }
    }

    void drawLine(double x0, double y0, double x1, double y1) {
        if (!(this.penMode().equals("up") || x0 == x1 && y0 == y1)) {
            this.world.drawLine(x0, y0, x1, y1, this.variables[1], this.penSize(), this.penMode());
        }
    }

    public void moveTo(Agent otherAgent) throws AgentException {
        double y;
        double x;
        if (otherAgent instanceof Turtle) {
            Turtle t = (Turtle)otherAgent;
            x = t.xcor();
            y = t.ycor();
        } else if (otherAgent instanceof Patch) {
            Patch p = (Patch)otherAgent;
            x = p.pxcor;
            y = p.pycor;
        } else {
            throw new AgentException("you can't move-to a link");
        }
        this.xandycor(this.shortestPathX(x), this.shortestPathY(y));
    }

    public double shortestPathY(double y) throws AgentException {
        if (!this.penMode().equals("down")) {
            return y;
        }
        double yprime = (y = this.world.wrapY(y)) > this.ycor ? y - (double)this.world.worldHeight() : y + (double)this.world.worldHeight();
        if (!this.world.wrappingAllowedInY()) {
            yprime = y;
        }
        if (StrictMath.abs(y - this.ycor) > StrictMath.abs(yprime - this.ycor)) {
            y = yprime;
        }
        return y;
    }

    public double shortestPathX(double x) throws AgentException {
        if (!this.penMode().equals("down")) {
            return x;
        }
        double xprime = (x = this.world.wrapX(x)) > this.xcor ? x - (double)this.world.worldWidth() : x + (double)this.world.worldWidth();
        if (!this.world.wrappingAllowedInX()) {
            xprime = x;
        }
        if (StrictMath.abs(x - this.xcor) > StrictMath.abs(xprime - this.xcor)) {
            x = xprime;
        }
        return x;
    }

    @Override
    public double xcor() {
        return this.xcor;
    }

    public void xcor(Double xcor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double x = xcor;
        double oldX = this.xcor;
        double wrapped = this.world.wrapX(x);
        this.drawLine(this.xcor, this.ycor, this.shortestPathX(x), this.ycor);
        this.xcor = wrapped;
        this.variables[3] = x == wrapped ? xcor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, x, this.ycor, oldX, this.ycor);
        }
    }

    @Override
    public double ycor() {
        return this.ycor;
    }

    public void ycor(Double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double y = ycor;
        double oldY = this.ycor;
        double wrapped = this.world.wrapY(y);
        this.drawLine(this.xcor, this.ycor, this.xcor, this.shortestPathY(y));
        this.ycor = wrapped;
        this.variables[4] = y == wrapped ? ycor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, this.xcor, y, this.xcor, oldY);
        }
    }

    public void xandycor(double xcor, double ycor) throws AgentException {
        double oldX = this.xcor;
        double oldY = this.ycor;
        this.xandycorHelper(xcor, ycor);
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, xcor, ycor, oldX, oldY);
        }
    }

    public void xandycor(double xcor, double ycor, Set<Turtle> seenTurtles) throws AgentException {
        double oldX = this.xcor;
        double oldY = this.ycor;
        this.xandycorHelper(xcor, ycor);
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, xcor, ycor, oldX, oldY, seenTurtles);
        }
    }

    public void xandycorHelper(double xcor, double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double newX = this.world.wrapX(xcor);
        double newY = this.world.wrapY(ycor);
        this.drawLine(this.xcor, this.ycor, xcor, ycor);
        this.xcor = newX;
        this.ycor = newY;
        this.variables[3] = null;
        this.variables[4] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
    }

    public void xandycor(Double xcor, Double ycor) throws AgentException {
        Observer observer;
        Patch originalPatch = this.getPatchHere();
        double x = xcor;
        double y = ycor;
        double oldX = this.xcor;
        double oldY = this.ycor;
        double wrappedX = this.world.wrapX(x);
        double wrappedY = this.world.wrapY(y);
        this.drawLine(this.xcor, this.ycor, x, y);
        this.xcor = wrappedX;
        this.ycor = wrappedY;
        this.variables[3] = x == wrappedX ? xcor : null;
        this.variables[4] = y == wrappedY ? ycor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, x, y, oldX, oldY);
        }
    }

    public void moveToPatchCenter() {
        Patch p = this.getPatchHere();
        double x = p.pxcor;
        double y = p.pycor;
        double oldX = this.xcor;
        double oldY = this.ycor;
        this.drawLine(oldX, oldY, x, y);
        if (x != oldX || y != oldY) {
            this.xcor = x;
            this.ycor = y;
            this.variables[3] = p.variables[0];
            this.variables[4] = p.variables[1];
            Observer observer = this.world.observer();
            if (this == observer.targetAgent()) {
                observer.updatePosition();
            }
            if (this.world.tieManager.tieCount > 0) {
                this.world.tieManager.turtleMoved(this, x, y, oldX, oldY);
            }
        }
    }

    public void face(Agent agent, boolean wrap) {
        try {
            this.heading(this.world.protractor.towards(this, agent, wrap));
        }
        catch (AgentException ex) {
            Exceptions.ignore(ex);
        }
    }

    public void face(double x, double y, boolean wrap) {
        try {
            this.heading(this.world.protractor.towards(this, x, y, wrap));
        }
        catch (AgentException ex) {
            Exceptions.ignore(ex);
        }
    }

    public static double subtractHeadings(double h1, double h2) {
        double diff;
        if (h1 < 0.0 || h1 >= 360.0) {
            h1 = (h1 % 360.0 + 360.0) % 360.0;
        }
        if (h2 < 0.0 || h2 >= 360.0) {
            h2 = (h2 % 360.0 + 360.0) % 360.0;
        }
        if ((diff = h1 - h2) > -180.0 && diff <= 180.0) {
            return diff;
        }
        if (diff > 0.0) {
            return diff - 360.0;
        }
        return diff + 360.0;
    }

    public void home() {
        try {
            this.xandycor(World.ZERO, World.ZERO);
        }
        catch (AgentException e) {
            throw new IllegalStateException(e);
        }
    }

    public double dx() {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int integerHeading = (int)this.heading;
            if (this.heading == (double)integerHeading) {
                this.cachedCosine = TrigTables.cos[integerHeading];
                this.cachedSine = TrigTables.sin[integerHeading];
            } else {
                double headingRadians = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(headingRadians);
                this.cachedSine = StrictMath.sin(headingRadians);
            }
        }
        return this.cachedSine;
    }

    public double dy() {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int integerHeading = (int)this.heading;
            if (this.heading == (double)integerHeading) {
                this.cachedCosine = TrigTables.cos[integerHeading];
                this.cachedSine = TrigTables.sin[integerHeading];
            } else {
                double headingRadians = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(headingRadians);
                this.cachedSine = StrictMath.sin(headingRadians);
            }
        }
        return this.cachedCosine;
    }

    @Override
    public String shape() {
        return (String)this.variables[5];
    }

    public void shape(String shape) {
        this.variables[5] = shape;
        this.cachedShape = null;
    }

    public Object label() {
        return this.variables[6];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables[6]);
    }

    public void label(Object label) {
        this.variables[6] = label;
    }

    @Override
    public Object labelColor() {
        return this.variables[7];
    }

    public void labelColor(double labelColor) {
        this.variables[7] = Color.modulateDouble(labelColor);
    }

    public void labelColor(LogoList rgb, int valueIndex) throws AgentException {
        this.validRGBList(rgb, true);
        this.variables[valueIndex] = rgb;
    }

    @Override
    public AgentSet getBreed() {
        return (AgentSet)this.variables[8];
    }

    @Override
    public int getBreedIndex() {
        AgentSet mybreed = this.getBreed();
        if (mybreed == this.world.turtles()) {
            return 0;
        }
        int j = 0;
        Iterator<Object> iter = this.world.program().breeds.values().iterator();
        while (iter.hasNext()) {
            if (mybreed == (AgentSet)iter.next()) {
                return j;
            }
            ++j;
        }
        return 0;
    }

    public void setBreed(AgentSet breed) {
        AgentSet oldBreed = null;
        if (this.variables[8] instanceof AgentSet) {
            oldBreed = (AgentSet)this.variables[8];
            if (breed == oldBreed) {
                return;
            }
            if (oldBreed != this.world.turtles()) {
                ((AgentSet)this.variables[8]).remove(this.agentKey());
            }
        }
        if (breed != this.world.turtles()) {
            breed.add(this);
        }
        this.variables[8] = breed;
        this.shape(this.world.turtleBreedShapes.breedShape(breed));
        this.realloc(false, oldBreed);
    }

    @Override
    public Shape cachedShape() {
        return this.cachedShape;
    }

    @Override
    public void cachedShape(Shape newShape) {
        this.cachedShape = newShape;
    }

    @Override
    public boolean hidden() {
        return (Boolean)this.variables[9];
    }

    public void hidden(boolean hidden) {
        this.variables[9] = hidden ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public double size() {
        return (Double)this.variables[10];
    }

    public void size(double size) {
        this.variables[10] = size;
    }

    public double penSize() {
        return (Double)this.variables[11];
    }

    public void penSize(double penSize) {
        this.variables[11] = penSize;
    }

    public String penMode() {
        return (String)this.variables[12];
    }

    public void penMode(String penMode) {
        this.variables[12] = penMode;
    }

    public String toString() {
        return this.world.getBreedSingular(this.getBreed()).toLowerCase() + " " + this.id;
    }

    @Override
    public String classDisplayName() {
        return this.world.getBreedSingular(this.getBreed()).toLowerCase();
    }

    public Class<Turtle> getAgentClass() {
        return Turtle.class;
    }

    @Override
    public int getAgentBit() {
        return 2;
    }
}

