/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Drawing3D;
import org.nlogo.agent.Exporter3D;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Importer3D;
import org.nlogo.agent.InRadiusOrCone3D;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager3D;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Observer3D;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.TieManager3D;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Torus3D;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.Program;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldDimensions3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class World3D
extends World
implements org.nlogo.api.World3D {
    Drawing3D drawing;
    int worldDepth;
    int maxPzcor;
    int minPzcor;
    Double minPzcorBoxed;
    Double maxPzcorBoxed;
    Double worldDepthBoxed;
    private double[][][] patchScratch3d;

    @Override
    public org.nlogo.api.Protractor3D protractor3D() {
        return (org.nlogo.api.Protractor3D)((Object)this.protractor);
    }

    public World3D() {
        this.linkManager = new LinkManager3D(this);
        this.tieManager = new TieManager3D(this, this.linkManager);
        this.drawing = new Drawing3D(this);
        this.inRadiusOrCone = new InRadiusOrCone3D(this);
        this.protractor = new Protractor3D(this);
    }

    @Override
    Observer createObserver() {
        return new Observer3D(this);
    }

    @Override
    public void changeTopology(boolean xWrapping, boolean yWrapping) {
        this.topology = new Torus3D(this);
    }

    public boolean wrappingAllowedInZ() {
        return true;
    }

    @Override
    public double wrappedObserverZ(double z) {
        z = ((Topology3D)((Object)this.topology)).wrapZ(z - this.followOffsetZ());
        return z;
    }

    @Override
    public double followOffsetZ() {
        return ((Observer3D)this.observer).followOffsetZ();
    }

    @Override
    public void diffuse4(double param, int vn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int worldDepth() {
        return this.worldDepth;
    }

    @Override
    public int maxPzcor() {
        return this.maxPzcor;
    }

    @Override
    public int minPzcor() {
        return this.minPzcor;
    }

    @Override
    public double wrapZ(double z) {
        return Topology.wrap(z, (double)this.minPzcor - 0.5, (double)this.maxPzcor + 0.5);
    }

    public int roundZ(double z) {
        if ((z = ((Topology3D)((Object)this.topology)).wrapZ(z)) > 0.0) {
            return (int)(z + 0.5);
        }
        int intPart = (int)z;
        double fractPart = (double)intPart - z;
        return fractPart > 0.5 ? intPart - 1 : intPart;
    }

    public Patch getPatchAtWrap(double x, double y, double z) {
        int yc;
        double fractPart;
        int intPart;
        int xc;
        x = Topology.wrap(x, (double)this.minPxcor() - 0.5, (double)this.maxPxcor() + 0.5);
        y = Topology.wrap(y, (double)this.minPycor() - 0.5, (double)this.maxPycor() + 0.5);
        z = Topology.wrap(z, (double)this.minPzcor() - 0.5, (double)this.maxPzcor() + 0.5);
        if (x > 0.0) {
            xc = (int)(x + 0.5);
        } else {
            intPart = (int)x;
            fractPart = (double)intPart - x;
            int n = xc = fractPart > 0.5 ? intPart - 1 : intPart;
        }
        if (y > 0.0) {
            yc = (int)(y + 0.5);
        } else {
            intPart = (int)y;
            fractPart = (double)intPart - y;
            int n = yc = fractPart > 0.5 ? intPart - 1 : intPart;
        }
        int zc = z > 0.0 ? (int)(z + 0.5) : ((fractPart = (double)(intPart = (int)z) - z) > 0.5 ? intPart - 1 : intPart);
        int patchid = this.worldWidth * this.worldHeight * (this.maxPzcor - zc) + this.worldWidth * (this.maxPycor - yc) + xc - this.minPxcor;
        return (Patch)this.patches.toArray()[patchid];
    }

    public boolean validPatchCoordinates(int xc, int yc, int zc) {
        return xc >= this.minPxcor && xc <= this.maxPxcor && yc >= this.minPycor && yc <= this.maxPycor && zc >= this.minPzcor && zc <= this.maxPzcor;
    }

    public Patch fastGetPatchAt(int xc, int yc, int zc) {
        return (Patch)this.patches.toArray()[this.worldWidth * this.worldHeight * (this.maxPzcor - zc) + this.worldWidth * (this.maxPycor - yc) + xc - this.minPxcor];
    }

    @Override
    public Patch fastGetPatchAt(int xc, int yc) {
        return this.fastGetPatchAt(xc, yc, 0);
    }

    @Override
    public void createPatches(int minPxcor, int maxPxcor, int minPycor, int maxPycor) {
        this.createPatches(minPxcor, maxPxcor, minPycor, maxPycor, 0, 0);
    }

    @Override
    public Program newProgram() {
        return new Program(true);
    }

    @Override
    public Program newProgram(List<String> interfaceGlobals) {
        return new Program(interfaceGlobals, true);
    }

    public void createPatches(int n, int n2, int n3, int n4, int n5, int n6) {
        this.patchScratch = null;
        this.patchScratch3d = null;
        this.minPxcor = n;
        this.maxPxcor = n2;
        this.minPycor = n3;
        this.maxPycor = n4;
        this.minPzcor = n5;
        this.maxPzcor = n6;
        this.worldWidth = n2 - n + 1;
        this.worldHeight = n4 - n3 + 1;
        this.worldDepth = n6 - n5 + 1;
        this.rootsTable = new RootsTable(this.worldWidth, this.worldHeight);
        this.worldWidthBoxed = this.worldWidth;
        this.worldHeightBoxed = this.worldHeight;
        this.worldDepthBoxed = this.worldDepth;
        this.minPxcorBoxed = n;
        this.minPycorBoxed = n3;
        this.minPzcorBoxed = n5;
        this.maxPxcorBoxed = n2;
        this.maxPycorBoxed = n4;
        this.maxPzcorBoxed = n6;
        if (this.program.breeds != null) {
            Iterator<Object> iterator = this.program.breeds.values().iterator();
            while (iterator.hasNext()) {
                ((AgentSet)iterator.next()).clear();
            }
        }
        this.turtles = new TreeAgentSet(Turtle.class, "TURTLES", this);
        this.links = new TreeAgentSet(Link.class, "LINKS", this);
        int n7 = n;
        int n8 = n4;
        int n9 = n6;
        Agent[] agentArray = new Agent[this.worldWidth * this.worldHeight * this.worldDepth];
        this.patchColors = new int[this.worldWidth * this.worldHeight * this.worldDepth];
        Arrays.fill(this.patchColors, Color.getARGBbyPremodulatedColorNumber(0.0));
        this.patchColorsDirty = true;
        int n10 = this.program().patchesOwn.size();
        this.observer.resetPerspective();
        for (int i = 0; this.worldWidth * this.worldHeight * this.worldDepth != i; ++i) {
            Patch3D patch3D = new Patch3D(this, i, n7, n8, n9, n10);
            if (++n7 == n2 + 1) {
                n7 = n;
                if (--n8 == n3 - 1) {
                    n8 = n4;
                    --n9;
                }
            }
            agentArray[i] = patch3D;
        }
        this.patches = new ArrayAgentSet(Patch.class, agentArray, "patches", (World)this);
        this.patchesWithLabels = 0;
        this.patchesAllBlack = true;
    }

    @Override
    public void exportWorld(PrintWriter writer, boolean full) {
        new Exporter3D(this).exportWorld(writer, full);
    }

    @Override
    public void importWorld(Importer.ErrorHandler errorHandler, ImporterUser importerUser, Importer.StringReader stringReader, BufferedReader reader) throws IOException {
        new Importer3D(errorHandler, this, importerUser, stringReader).importWorld(reader);
    }

    @Override
    public Turtle getOrCreateTurtle(long id) {
        Turtle turtle2 = this.getTurtle(id);
        if (turtle2 == null) {
            turtle2 = new Turtle3D(this, id);
        }
        return turtle2;
    }

    public double[][][] getPatchScratch3d() {
        if (this.patchScratch3d == null) {
            this.patchScratch3d = new double[this.worldWidth][this.worldHeight][this.worldDepth];
        }
        return this.patchScratch3d;
    }

    @Override
    public WorldDimensions getDimensions() {
        return new WorldDimensions3D(this.minPxcor, this.maxPxcor, this.minPycor, this.maxPycor, this.minPzcor, this.maxPzcor);
    }

    @Override
    public Patch getPatchAt(double x, double y) throws AgentException {
        return this.getPatchAt(x, y, 0.0);
    }

    @Override
    public Patch3D getPatchAt(double x, double y, double z) throws AgentException {
        int xc = this.roundX(x);
        int yc = this.roundY(y);
        int zc = this.roundZ(z);
        int id = this.worldWidth * this.worldHeight * (this.maxPzcor - zc) + this.worldWidth * (this.maxPycor - yc) + xc - this.minPxcor;
        return (Patch3D)this.patches.toArray()[id];
    }

    @Override
    public Turtle createTurtle(AgentSet breed) {
        return new Turtle3D(this, breed, ZERO, ZERO, ZERO);
    }

    @Override
    public Turtle createTurtle(AgentSet breed, int c, int h) {
        Turtle3D baby = new Turtle3D(this, breed, ZERO, ZERO, ZERO);
        baby.colorDoubleUnchecked(Double.valueOf(5 + 10 * c));
        baby.heading(h);
        return baby;
    }

    @Override
    public Object getDrawing() {
        return this.drawing;
    }

    @Override
    public boolean sendPixels() {
        return false;
    }

    @Override
    void drawLine(double x0, double y0, double x1, double y1, Object color, double size, String mode) {
        this.drawing.drawLine(x0, y0, 0.0, x1, y1, 0.0, size, color);
    }

    void drawLine(double x0, double y0, double z0, double x1, double y1, double z1, Object color, double size) {
        this.drawing.drawLine(x0, y0, z0, x1, y1, z1, size, color);
    }

    @Override
    public void clearAll() {
        super.clearAll();
        this.drawing.clear();
    }

    @Override
    public void clearDrawing() {
        this.drawing.clear();
    }

    @Override
    public void stamp(Agent agent, boolean erase) {
        if (!erase) {
            this.drawing.stamp(agent);
        }
    }
}

