/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

public strictfp final class Approximate {
    private Approximate() {
        throw new IllegalStateException();
    }

    public static double approximate(double n, int places) {
        if (places >= 17) {
            return n;
        }
        double multiplier = StrictMath.pow(10.0, places);
        double result = StrictMath.floor(n * multiplier + 0.5) / multiplier;
        return places > 0 ? result : (double)StrictMath.round(result);
    }

    public static double approximateCeiling(double n, int places) {
        if (places >= 17) {
            return n;
        }
        double multiplier = StrictMath.pow(10.0, places);
        double result = StrictMath.ceil(n * multiplier) / multiplier;
        return places > 0 ? result : (double)StrictMath.round(result);
    }

    public static double approximateFloor(double n, int places) {
        if (places >= 17) {
            return n;
        }
        double multiplier = StrictMath.pow(10.0, places);
        double result = StrictMath.floor(n * multiplier) / multiplier;
        return places > 0 ? result : (double)StrictMath.round(result);
    }
}

