/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CSV {
    private final ObjectDumper dumper;
    public static final int CELL_WIDTH = 10000;
    public static final int MAX_COLUMNS = 2;

    public CSV(ObjectDumper dumper) {
        this.dumper = dumper;
    }

    public String blank() {
        return "";
    }

    public String data(Object obj) {
        return this.encode(this.dumper.dump(obj));
    }

    public String number(double d) {
        return this.encode(this.dumper.dump(d));
    }

    public String number(int i) {
        return this.encode(this.dumper.dump(i));
    }

    public String dataRow(Object[] objs) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < objs.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.data(objs[i]));
        }
        return buf.toString();
    }

    public String header(String s) {
        return this.encode(s);
    }

    public String headerRow(String[] strings) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.encode(strings[i]));
        }
        return buf.toString();
    }

    public String encode(String s) {
        if (s == null) {
            s = "null";
        }
        StringBuilder result = new StringBuilder();
        result.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            result.append(c);
            if (c != '\"') continue;
            result.append('\"');
        }
        result.append('\"');
        return result.toString();
    }

    public void stringToCSV(PrintWriter writer, String text) {
        int i = 0;
        while (i < text.length()) {
            String line = "";
            int k = 0;
            while (k < 2 && i < text.length()) {
                int end = StrictMath.min(i + 10000, text.length());
                line = line + text.substring(i, end);
                if ((i += 10000) >= text.length() || ++k >= 2) continue;
                line = line + ",";
            }
            writer.println(this.data(line));
        }
    }

    public String variableNameRow(List<String> v) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < v.size(); ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.encode(v.get(i)).toLowerCase());
        }
        return result.toString();
    }

    public static interface ObjectDumper {
        public String dump(Object var1);
    }
}

