/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.CSV;
import org.nlogo.api.ExtensionObject;
import org.nlogo.api.Link;
import org.nlogo.api.LogoList;
import org.nlogo.api.Nobody;
import org.nlogo.api.Observer;
import org.nlogo.api.Patch;
import org.nlogo.api.StringUtils;
import org.nlogo.api.Turtle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Dump {
    public static final CSV csv = new CSV(new CSV.ObjectDumper(){

        public String dump(Object obj) {
            if (obj instanceof Integer) {
                return obj.toString();
            }
            return Dump.logoObject(obj, true, true);
        }
    });

    private Dump() {
        throw new IllegalStateException();
    }

    public static boolean isKnownType(Object obj) {
        return obj instanceof ExtensionObject || obj instanceof Boolean || obj instanceof Double || obj instanceof String || obj instanceof AgentSet || obj instanceof Agent || obj instanceof Nobody || obj instanceof List;
    }

    public static String logoObject(Object obj) {
        return Dump.logoObject(obj, false, false);
    }

    public static String logoObject(Object obj, boolean readable, boolean exporting) {
        if (obj instanceof ExtensionObject) {
            return Dump.extensionObject((ExtensionObject)obj, readable, exporting, exporting);
        }
        if (obj instanceof Integer) {
            throw new IllegalArgumentException("Integer: " + obj);
        }
        if (obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof Double) {
            return Dump.number((Double)obj);
        }
        if (obj instanceof String) {
            if (readable) {
                return "\"" + StringUtils.escapeString((String)obj) + "\"";
            }
            return (String)obj;
        }
        if (obj instanceof AgentSet) {
            return Dump.agentset((AgentSet)obj, exporting);
        }
        if (obj instanceof Agent) {
            return Dump.agent((Agent)obj, exporting);
        }
        if (obj instanceof Nobody) {
            return "nobody";
        }
        if (obj instanceof List) {
            return Dump.list((List)obj, readable, exporting);
        }
        if (obj == null) {
            return "<null>";
        }
        return "<" + obj.getClass().getName() + ">";
    }

    public static String extensionObject(ExtensionObject obj, boolean readable, boolean exporting, boolean reference) {
        return "{{" + obj.getExtensionName() + ":" + obj.getNLTypeName() + " " + obj.dump(readable, exporting, reference) + "}}";
    }

    public static String number(Double obj) {
        double d = obj;
        long l = (long)d;
        return (double)l == d && l >= -9007199254740992L && l <= 0x20000000000000L ? Long.toString(l) : Double.toString(d);
    }

    public static String number(double d) {
        long l = (long)d;
        return (double)l == d && l >= -9007199254740992L && l <= 0x20000000000000L ? Long.toString(l) : Double.toString(d);
    }

    public static String map(Map<?, ?> map2) {
        return Dump.map(map2, false, false);
    }

    public static String map(Map<?, ?> map2, boolean readable, boolean exporting) {
        StringBuilder buff = new StringBuilder();
        for (String key : map2.keySet()) {
            Object value = map2.get(key);
            if (value == null) {
                buff.append(key + " = null\n");
                continue;
            }
            if (value instanceof AgentSet) {
                buff.append(key + " = \n" + Dump.agentset((AgentSet)value, exporting));
                continue;
            }
            if (value instanceof Agent) {
                buff.append(key + " = \n" + Dump.agent((Agent)value, exporting));
                continue;
            }
            if (value instanceof List) {
                buff.append(key + " = \n" + Dump.list((List)value, readable, exporting));
                continue;
            }
            buff.append(key + " = " + value + "\n");
        }
        return buff.toString();
    }

    public static String list(List<?> list) {
        return Dump.list(list, false, false);
    }

    public static String list(List<?> list, boolean readable, boolean exporting) {
        return Dump.iterator(list.iterator(), readable, exporting);
    }

    public static String list(List<?> list, String prefix, String suffix, String delimiter) {
        return Dump.iterator(list.iterator(), prefix, suffix, delimiter, false, false);
    }

    public static String list(List<?> list, String prefix, String suffix, String delimiter, boolean readable, boolean exporting) {
        return Dump.iterator(list.iterator(), prefix, suffix, delimiter, readable, exporting);
    }

    public static String iterator(Iterator<?> iter) {
        return Dump.iterator(iter, "[", "]", " ", false, false);
    }

    public static String iterator(Iterator<?> iter, boolean readable, boolean exporting) {
        return Dump.iterator(iter, "[", "]", " ", readable, exporting);
    }

    public static String iterator(Iterator<?> iter, String prefix, String suffix, String delimiter, boolean readable, boolean exporting) {
        StringBuilder buff = new StringBuilder();
        buff.append(prefix);
        boolean firstOne = true;
        while (iter.hasNext()) {
            if (firstOne) {
                firstOne = false;
            } else {
                buff.append(delimiter);
            }
            buff.append(Dump.logoObject(iter.next(), readable, exporting));
        }
        buff.append(suffix);
        return buff.toString();
    }

    public static String agentset(AgentSet agentSet, boolean bl) {
        String string = agentSet.printName();
        if (string != null) {
            string = string.toLowerCase();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            if (string != null) {
                return string;
            }
            stringBuilder.append("(agentset, " + agentSet.count() + " ");
            if (Turtle.class.isAssignableFrom(agentSet.type())) {
                if (agentSet.count() == 1) {
                    stringBuilder.append("turtle");
                } else {
                    stringBuilder.append("turtles");
                }
            } else if (Patch.class.isAssignableFrom(agentSet.type())) {
                if (agentSet.count() == 1) {
                    stringBuilder.append("patch");
                } else {
                    stringBuilder.append("patches");
                }
            } else if (Observer.class.isAssignableFrom(agentSet.type())) {
                stringBuilder.append("observer");
            } else if (Link.class.isAssignableFrom(agentSet.type())) {
                if (agentSet.count() == 1) {
                    stringBuilder.append("link");
                } else {
                    stringBuilder.append("links");
                }
            } else {
                throw new IllegalStateException();
            }
            stringBuilder.append(")");
        } else {
            stringBuilder.append("{");
            if (Turtle.class.isAssignableFrom(agentSet.type())) {
                if (string != null) {
                    if (agentSet == agentSet.world().turtles()) {
                        stringBuilder.append("all-" + string);
                    } else {
                        stringBuilder.append("breed " + string);
                    }
                } else {
                    stringBuilder.append("turtles");
                    for (Agent agent : agentSet.agents()) {
                        stringBuilder.append(" " + ((Turtle)agent).id());
                    }
                }
            } else if (Link.class.isAssignableFrom(agentSet.type())) {
                if (string != null) {
                    if (agentSet == agentSet.world().links()) {
                        stringBuilder.append("all-" + string);
                    } else {
                        stringBuilder.append("breed " + string);
                    }
                } else {
                    stringBuilder.append("links");
                    for (Agent agent : agentSet.agents()) {
                        Link link = (Link)agent;
                        stringBuilder.append(" [" + link.end1().id() + " " + link.end2().id() + " " + Dump.agentset(link.getBreed(), true) + "]");
                    }
                }
            } else if (Patch.class.isAssignableFrom(agentSet.type())) {
                if (string != null) {
                    stringBuilder.append("all-" + string);
                } else {
                    stringBuilder.append("patches");
                    for (Agent agent : agentSet.agents()) {
                        Patch patch = (Patch)agent;
                        stringBuilder.append(" [" + patch.pxcor() + " " + patch.pycor() + "]");
                    }
                }
            } else if (Observer.class.isAssignableFrom(agentSet.type())) {
                stringBuilder.append("observer");
            } else {
                throw new IllegalStateException();
            }
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    public static String agent(Agent agent, boolean exporting) {
        String openParen = "(";
        String closeParen = ")";
        if (exporting) {
            openParen = "{";
            closeParen = "}";
        }
        if (agent instanceof Observer) {
            return "observer";
        }
        if (agent instanceof Turtle || agent instanceof Patch || agent instanceof Link) {
            if (agent.id() == -1L) {
                return "nobody";
            }
            return openParen + agent.toString() + closeParen;
        }
        throw new IllegalArgumentException(agent.toString());
    }

    public static String typeName(Object obj) {
        if (obj instanceof Agent) {
            return Dump.typeName(obj.getClass());
        }
        if (obj instanceof ExtensionObject) {
            return ((ExtensionObject)obj).getNLTypeName();
        }
        return Dump.typeName(obj.getClass());
    }

    public static String typeName(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return "true/false";
        }
        if (clazz == Double.class) {
            return "number";
        }
        if (clazz == String.class) {
            return "string";
        }
        if (AgentSet.class.isAssignableFrom(clazz)) {
            return "agentset";
        }
        if (Turtle.class.isAssignableFrom(clazz)) {
            return "turtle";
        }
        if (Patch.class.isAssignableFrom(clazz)) {
            return "patch";
        }
        if (Link.class.isAssignableFrom(clazz)) {
            return "link";
        }
        if (Observer.class.isAssignableFrom(clazz)) {
            return "observer";
        }
        if (Agent.class.isAssignableFrom(clazz)) {
            return "agent";
        }
        if (LogoList.class.isAssignableFrom(clazz)) {
            return "list";
        }
        if (Nobody.class.isAssignableFrom(clazz)) {
            return "nobody";
        }
        return clazz.getName();
    }
}

