/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import org.nlogo.api.AgentSet;
import org.nlogo.api.ExtensionObject;
import org.nlogo.api.Link;
import org.nlogo.api.LogoList;
import org.nlogo.api.Nobody;
import org.nlogo.api.Turtle;

public strictfp final class Equality {
    private Equality() {
        throw new IllegalStateException();
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof Double && o2 instanceof Double) {
            return ((Double)o1).doubleValue() == ((Double)o2).doubleValue();
        }
        if (o1 instanceof LogoList && o2 instanceof LogoList) {
            LogoList v1 = (LogoList)o1;
            LogoList v2 = (LogoList)o2;
            if (v1.size() != v2.size()) {
                return false;
            }
            for (int i = 0; i < v1.size(); ++i) {
                if (Equality.equals(v1.get(i), v2.get(i))) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof Turtle && o2 instanceof Turtle) {
            return ((Turtle)o1).id() == ((Turtle)o2).id();
        }
        if (o1 instanceof Nobody) {
            return o2 instanceof Nobody || o2 instanceof Turtle && ((Turtle)o2).id() == -1L || o2 instanceof Link && ((Link)o2).id() == -1L;
        }
        if (o2 instanceof Nobody) {
            return o1 instanceof Turtle && ((Turtle)o1).id() == -1L || o1 instanceof Link && ((Link)o1).id() == -1L;
        }
        if (o1 instanceof AgentSet && o2 instanceof AgentSet) {
            return ((AgentSet)o1).equalAgentSets((AgentSet)o2);
        }
        if (o1 instanceof ExtensionObject) {
            return ((ExtensionObject)o1).recursivelyEqual(o2);
        }
        if (o2 instanceof ExtensionObject) {
            return ((ExtensionObject)o2).recursivelyEqual(o1);
        }
        return o1.equals(o2);
    }
}

