/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import org.nlogo.api.GraphicsInterface;

public strictfp class Graphics2DWrapper
implements GraphicsInterface {
    private static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");
    private static final boolean IS_QUARTZ = IS_MAC && Boolean.getBoolean("apple.awt.graphics.UseQuartz");
    private final Graphics2D g;
    private final LinkedList<AffineTransform> transforms = new LinkedList();
    private final LinkedList<Stroke> strokes = new LinkedList();

    public Graphics2DWrapper(Graphics2D g) {
        this.g = g;
    }

    public String location(double x, double y) {
        return "(" + (this.g.getTransform().getTranslateX() + x) + " , " + (this.g.getTransform().getTranslateY() + y) + ")";
    }

    public void draw(Shape shape) {
        this.g.draw(shape);
    }

    public void drawImage(BufferedImage image) {
        this.g.drawImage(image, null, 0, 0);
    }

    public void drawImage(Image image, int x, int y, int width, int height) {
        this.g.drawImage(image, x, y, width, height, null);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.g.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    public void drawLabel(String label, double x, double y, double patchSize) {
        FontMetrics fm = this.g.getFontMetrics();
        this.g.translate(x - (double)fm.stringWidth(label), 0.0);
        if (patchSize >= (double)(fm.getMaxAscent() + fm.getMaxDescent())) {
            this.g.translate(0.0, y - (double)fm.getMaxDescent());
        } else {
            double centerAdjustment = StrictMath.min(0.0, patchSize / 4.0 - (double)(fm.getMaxAscent() / 4));
            this.g.translate(0.0, y - centerAdjustment);
        }
        this.g.drawString(label, 0, 0);
    }

    public void fillCircle(double x, double y, double xDiameter, double yDiameter, double scale, double angle) {
        double sizeCorrection = 0.0;
        double xCorrection = 0.0;
        double yCorrection = 0.0;
        if (IS_QUARTZ) {
            sizeCorrection = 300.0 / scale;
            yCorrection = xCorrection = -0.5 * sizeCorrection;
        }
        this.g.fill(new Ellipse2D.Double(x + xCorrection, y + yCorrection, xDiameter + sizeCorrection, yDiameter + sizeCorrection));
    }

    public void drawCircle(double x, double y, double xDiameter, double yDiameter, double scale, double angle) {
        double sizeCorrection = 0.0;
        double xCorrection = 0.0;
        double yCorrection = 0.0;
        if (!IS_QUARTZ) {
            sizeCorrection = -300.0 / scale;
            xCorrection = this.getXCorrection(sizeCorrection, angle);
            yCorrection = this.getYCorrection(sizeCorrection, angle);
        }
        this.g.draw(new Ellipse2D.Double(x + xCorrection, y + yCorrection, xDiameter + sizeCorrection, yDiameter + sizeCorrection));
    }

    public void fillRect(double x, double y, double width, double height, double scale, double angle) {
        double sizeCorrection = 0.0;
        double xCorrection = 0.0;
        double yCorrection = 0.0;
        if (IS_QUARTZ) {
            sizeCorrection = 300.0 / scale;
            xCorrection = this.getXCorrection(sizeCorrection, angle);
            yCorrection = this.getYCorrection(sizeCorrection, angle);
        }
        this.g.fill(new Rectangle2D.Double(x + xCorrection, y + yCorrection, width + sizeCorrection, height + sizeCorrection));
    }

    public void drawRect(double x, double y, double width, double height, double scale, double angle) {
        double sizeCorrection = 0.0;
        if (!IS_QUARTZ) {
            sizeCorrection = -300.0 / scale;
        }
        this.g.draw(new Rectangle2D.Double(x, y, width + sizeCorrection, height + sizeCorrection));
    }

    private double getXCorrection(double sizeCorrection, double angle) {
        return angle == 0.0 ? 0.0 : sizeCorrection * (StrictMath.cos((angle + 135.0) / 180.0 * Math.PI) + 0.7071067811865476) / -1.4142135623730951;
    }

    private double getYCorrection(double sizeCorrection, double angle) {
        return angle == 0.0 ? 0.0 : sizeCorrection * (StrictMath.sin((angle - 45.0) / 180.0 * Math.PI) + 0.7071067811865476) / -1.4142135623730951;
    }

    public void fill(Shape shape) {
        this.g.fill(shape);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x, y, width, height);
    }

    public void pop() {
        this.g.setTransform(this.transforms.removeLast());
        this.g.setStroke(this.strokes.removeLast());
    }

    public void push() {
        this.transforms.addLast(this.g.getTransform());
        this.strokes.addLast(this.g.getStroke());
    }

    public void rotate(double theta) {
        this.g.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.g.rotate(theta, x, y);
    }

    public void rotate(double theta, double x, double y, double offset) {
        if (IS_MAC) {
            offset -= 1.0;
        }
        this.g.rotate(theta, x + offset / 2.0, y + offset / 2.0);
    }

    public void scale(double x, double y) {
        this.g.scale(x, y);
    }

    public void scale(double x, double y, double shapeWidth) {
        if (IS_MAC) {
            x -= 1.0;
            y -= 1.0;
        }
        this.g.scale(x / shapeWidth, y / shapeWidth);
    }

    public void antiAliasing(boolean on) {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, on ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void setInterpolation() {
        if (IS_MAC) {
            this.g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
    }

    public void setStrokeControl() {
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public void setColor(Color c) {
        this.g.setColor(c);
    }

    public void setComposite(Composite comp) {
        this.g.setComposite(comp);
    }

    public void setStroke(double width) {
        this.g.setStroke(new BasicStroke((float)StrictMath.max(1.0, width)));
    }

    public void setStrokeFromLineThickness(double lineThickness, double scale, double cellSize, double shapeWidth) {
        if (IS_MAC) {
            scale -= 1.0;
        }
        this.setStroke(shapeWidth / scale * (lineThickness == 0.0 ? 1.0 : lineThickness * cellSize));
    }

    public void setStroke(float width, float[] dashes) {
        this.g.setStroke(new BasicStroke(width, 1, 1, 1.0f, dashes, 0.0f));
    }

    public void setPenWidth(double penSize) {
        float width = (float)StrictMath.max(1.0, penSize);
        if (((BasicStroke)this.g.getStroke()).getLineWidth() != width) {
            this.g.setStroke(new BasicStroke(width, 1, 0));
        }
    }

    public void translate(double x, double y) {
        this.g.translate(x, y);
    }

    public void drawPolygon(int[] xcors, int[] ycors, int length2) {
        this.g.drawPolygon(xcors, ycors, length2);
    }

    public void fillPolygon(int[] xcors, int[] ycors, int length2) {
        this.g.fillPolygon(xcors, ycors, length2);
    }

    public void drawPolyline(int[] xcors, int[] ycors, int length2) {
        this.g.drawPolyline(xcors, ycors, length2);
    }

    public void dispose() {
        this.g.dispose();
    }
}

