/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class JavaLibraryPath {
    private JavaLibraryPath() {
        throw new IllegalStateException();
    }

    public static void setLibraryPath(Class<?> myClass, String dirName) {
        try {
            String filesep = System.getProperty("file.separator");
            String basedir = new File(myClass.getProtectionDomain().getCodeSource().getLocation().getFile()).getParent();
            String libdir = basedir + filesep + dirName + filesep;
            String osname = System.getProperty("os.name");
            if (osname.equals("Mac OS X")) {
                libdir = libdir + osname;
            } else if (osname.startsWith("Windows")) {
                libdir = libdir + "Windows";
            } else {
                String arch = System.getProperty("os.arch");
                libdir = arch.endsWith("86") ? libdir + "-x86" : libdir + osname + "-" + arch;
                libdir = libdir.replaceAll("LinuxLinux", "Linux");
            }
            JavaLibraryPath.add(new File(libdir));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void add(File file) throws IOException, IllegalAccessException, NoSuchFieldException {
        String string = System.getProperty("java.library.path");
        string = string == null || string.length() < 1 ? file.getCanonicalPath() : string + File.pathSeparator + file.getCanonicalPath();
        Field field = System.class.getDeclaredField("props");
        field.setAccessible(true);
        Properties properties = (Properties)field.get(null);
        properties.put("java.library.path", string);
        Field field2 = ClassLoader.class.getDeclaredField("usr_paths");
        field2.setAccessible(true);
        String[] stringArray = (String[])field2.get(null);
        String[] stringArray2 = new String[stringArray == null ? 1 : stringArray.length + 1];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        stringArray2[stringArray2.length - 1] = file.getAbsolutePath();
        field2.set(null, stringArray2);
    }
}

