/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.nlogo.api.File;

public strictfp class LocalFile
extends File {
    private final String filepath;
    private String suffix = null;
    private File.Mode mode = File.Mode.NONE;
    private PrintWriter w = null;
    private BufferedReader buffReader;

    public LocalFile(String filepath) {
        this.filepath = filepath;
    }

    public LocalFile(String filepath, String suffix) {
        String tmps;
        String tmpf;
        this.filepath = filepath != null && suffix != null ? ((tmpf = filepath.toLowerCase()).endsWith(tmps = suffix.toLowerCase()) ? filepath.substring(0, tmpf.lastIndexOf(tmps)) : filepath) : filepath;
        this.suffix = suffix;
    }

    public File.Mode getMode() {
        return this.mode;
    }

    public PrintWriter getPrintWriter() {
        return this.w;
    }

    public BufferedReader getBufferedReader() {
        return this.buffReader;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getPath());
    }

    public void open(File.Mode mode) throws IOException {
        if (this.w != null || this.buffReader != null) {
            throw new IOException("Attempted to open an already open file");
        }
        String fullpath = this.suffix == null ? this.filepath : this.filepath + this.suffix;
        switch (mode) {
            case READ: {
                this.pos = 0L;
                this.eof = false;
                this.buffReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(new java.io.File(fullpath)))));
                this.mode = mode;
                break;
            }
            case WRITE: {
                this.w = new PrintWriter(new FileWriter(fullpath));
                this.mode = mode;
                break;
            }
            case APPEND: {
                this.w = new PrintWriter(new FileWriter(fullpath, true));
                this.mode = mode;
                break;
            }
        }
    }

    public void print(String str) throws IOException {
        if (this.w == null) {
            throw new IOException("Attempted to print to an unopened File");
        }
        this.w.print(str);
    }

    public void println(String line) throws IOException {
        if (this.w == null) {
            throw new IOException("Attempted to println to an unopened File");
        }
        this.w.println(line);
    }

    public void println() throws IOException {
        if (this.w == null) {
            throw new IOException("Attempted to println to an unopened File");
        }
        this.w.println();
    }

    public void flush() {
        if (this.w != null) {
            this.w.flush();
        }
    }

    public void close(boolean ok) throws IOException {
        if (this.w == null && this.buffReader == null) {
            return;
        }
        switch (this.mode) {
            case WRITE: 
            case APPEND: {
                this.w.close();
                this.w = null;
                break;
            }
            case READ: {
                this.buffReader.close();
                this.buffReader = null;
                break;
            }
        }
        this.mode = File.Mode.NONE;
    }

    public String getAbsolutePath() {
        return this.suffix == null ? new java.io.File(this.filepath).getAbsolutePath() : new java.io.File(this.filepath + this.suffix).getAbsolutePath();
    }

    public String getPath() {
        return this.suffix == null ? new java.io.File(this.filepath).getPath() : new java.io.File(this.filepath + this.suffix).getPath();
    }

    public static String readFile(java.io.File file) throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))));
        while ((line = in.readLine()) != null) {
            buffer.append(line + "\n");
        }
        return buffer.toString();
    }
}

