/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class LogoList
extends AbstractSequentialList<Object>
implements Serializable {
    static final long serialVersionUID = 0L;
    private Cell head;
    private Cell tail;
    private int size = 0;
    public static final LogoList EMPTY = new LogoList();

    public LogoList() {
        this.head = null;
        this.tail = null;
    }

    public LogoList(Collection<?> collection) {
        for (Object obj : collection) {
            ++this.size;
            Cell cell = new Cell(obj, null);
            if (this.tail != null) {
                this.tail.cdr = cell;
            }
            this.tail = cell;
            if (this.head != null) continue;
            this.head = cell;
        }
    }

    public LogoList(Object ... objs) {
        for (Object obj : objs) {
            ++this.size;
            Cell cell = new Cell(obj, null);
            if (this.tail != null) {
                this.tail.cdr = cell;
            }
            this.tail = cell;
            if (this.head != null) continue;
            this.head = cell;
        }
    }

    private LogoList(Cell head, int size) {
        this.head = head;
        this.tail = null;
        this.size = size;
    }

    private LogoList(Cell head, Cell tail, int size) {
        this.head = head;
        this.tail = tail;
        this.size = size;
    }

    @Override
    public java.util.Iterator<Object> iterator() {
        return new Iterator(this.head);
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        Iterator result = new Iterator(this.head);
        for (int i = 0; i < index; ++i) {
            result.next();
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, Object obj) {
        this.tail = this.head == null ? (this.head = new Cell(obj, null)) : (this.tail.cdr = new Cell(obj, null));
        ++this.size;
    }

    public Object first() {
        if (this.head == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.head.car;
    }

    public LogoList fput(Object obj) {
        return new LogoList(new Cell(obj, this.head), this.tail, this.size + 1);
    }

    public LogoList lput(Object obj) {
        if (this.head == null) {
            return new LogoList(new Cell(obj, null), this.size + 1);
        }
        Cell newHead = null;
        Cell lastCell = null;
        Cell cell = this.head;
        while (cell != null) {
            Cell newCell = new Cell(cell.car, null);
            if (lastCell != null) {
                lastCell.cdr = newCell;
            }
            lastCell = newCell;
            if (newHead == null) {
                newHead = newCell;
            }
            cell = cell.cdr;
        }
        lastCell.cdr = new Cell(obj, null);
        return new LogoList(newHead, this.size + 1);
    }

    public LogoList reverse() {
        if (this.size <= 1) {
            return this;
        }
        Cell result = null;
        Cell cell = this.head;
        while (cell != null) {
            result = new Cell(cell.car, result);
            cell = cell.cdr;
        }
        return new LogoList(result, this.size);
    }

    public LogoList replaceItem(int index, Object obj) {
        if (this.head == null) {
            return null;
        }
        Cell newHead = null;
        Cell lastCell = null;
        int i = 0;
        Cell cell = this.head;
        while (cell != null) {
            Cell newCell = new Cell(i == index ? obj : cell.car, null);
            if (lastCell != null) {
                lastCell.cdr = newCell;
            }
            lastCell = newCell;
            if (newHead == null) {
                newHead = newCell;
            }
            if (i == index) {
                newCell.cdr = cell.cdr;
                return new LogoList(newHead, this.size);
            }
            cell = cell.cdr;
            ++i;
        }
        return null;
    }

    public LogoList logoSublist(int start, int stop) {
        if (this.head == null || start == this.size) {
            return EMPTY;
        }
        if (stop == this.size) {
            int i = 0;
            Cell cell = this.head;
            while (cell != null) {
                if (i == start) {
                    return new LogoList(cell, stop - start);
                }
                cell = cell.cdr;
                ++i;
            }
            throw new IllegalStateException();
        }
        int i = 0;
        Cell newHead = null;
        Cell lastCell = null;
        Cell cell = this.head;
        while (cell != null) {
            if (i >= start) {
                if (i >= stop) break;
                Cell newCell = new Cell(cell.car, null);
                if (newHead == null) {
                    newHead = newCell;
                }
                if (lastCell != null) {
                    lastCell.cdr = newCell;
                }
                lastCell = newCell;
            }
            cell = cell.cdr;
            ++i;
        }
        return new LogoList(newHead, stop - start);
    }

    public LogoList butFirst() {
        return new LogoList(this.head.cdr, this.size - 1);
    }

    public LogoList butLast() {
        Cell newHead = null;
        Cell lastCell = null;
        Cell cell = this.head;
        while (cell.cdr != null) {
            Cell newCell = new Cell(cell.car, null);
            if (lastCell != null) {
                lastCell.cdr = newCell;
            }
            lastCell = newCell;
            if (newHead == null) {
                newHead = newCell;
            }
            cell = cell.cdr;
        }
        return new LogoList(newHead, this.size - 1);
    }

    public LogoList removeItem(int index) {
        Cell newHead = null;
        Cell lastCell = null;
        int i = 0;
        Cell cell = this.head;
        while (cell != null) {
            if (i != index) {
                Cell newCell = new Cell(cell.car, null);
                if (lastCell != null) {
                    lastCell.cdr = newCell;
                }
                lastCell = newCell;
                if (newHead == null) {
                    newHead = newCell;
                }
            }
            cell = cell.cdr;
            ++i;
        }
        return new LogoList(newHead, this.size - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp class Iterator
    implements ListIterator<Object> {
        private Cell cell;

        Iterator(Cell cell) {
            this.cell = cell;
        }

        @Override
        public boolean hasNext() {
            return this.cell != null;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            if (this.cell == null) {
                throw new NoSuchElementException();
            }
            Object result = this.cell.car;
            this.cell = this.cell.cdr;
            return result;
        }

        @Override
        public void add(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private strictfp static class Cell
    implements Serializable {
        final Object car;
        Cell cdr;

        Cell(Object car, Cell cdr) {
            this.car = car;
            this.cdr = cdr;
        }
    }
}

