/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Program {
    public final List<String> turtlesOwn = new ArrayList<String>();
    public final List<String> patchesOwn = new ArrayList<String>();
    public final List<String> linksOwn = new ArrayList<String>();
    public final List<String> globals = new ArrayList<String>();
    public final Map<String, Object> breeds = new LinkedHashMap<String, Object>();
    public final Map<String, String> breedsSingular = new LinkedHashMap<String, String>();
    public final Map<String, Object> linkBreeds = new LinkedHashMap<String, Object>();
    public final Map<String, String> linkBreedsSingular = new LinkedHashMap<String, String>();
    public final Map<String, List<String>> breedsOwn = new LinkedHashMap<String, List<String>>();
    public final Map<String, List<String>> linkBreedsOwn = new LinkedHashMap<String, List<String>>();
    public List<String> interfaceGlobals;
    public final boolean is3D;

    public Program(boolean is3D) {
        this(new ArrayList<String>(), is3D);
    }

    public Program(List<String> interfaceGlobals, boolean is3D) {
        this.interfaceGlobals = interfaceGlobals;
        this.is3D = is3D;
        this.globals.addAll(Arrays.asList(AgentVariables.getImplicitObserverVariables()));
        for (String s : interfaceGlobals) {
            this.globals.add(s.toUpperCase());
        }
        this.turtlesOwn.addAll(Arrays.asList(AgentVariables.getImplicitTurtleVariables(is3D)));
        this.patchesOwn.addAll(Arrays.asList(AgentVariables.getImplicitPatchVariables(is3D)));
        this.linksOwn.addAll(Arrays.asList(AgentVariables.getImplicitLinkVariables()));
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        buf.append("globals " + Dump.list(this.globals) + "\n");
        buf.append("interfaceGlobals " + Dump.list(this.interfaceGlobals) + "\n");
        buf.append("turtles-own " + Dump.list(this.turtlesOwn) + "\n");
        buf.append("patches-own " + Dump.list(this.patchesOwn) + "\n");
        buf.append("links-own " + Dump.list(this.linksOwn) + "\n");
        buf.append("breeds " + Dump.map(this.breeds) + "\n");
        buf.append("breeds-own " + Dump.map(this.breedsOwn) + "\n");
        buf.append("link-breeds " + Dump.map(this.linkBreeds) + "\n");
        buf.append("link-breeds-own " + Dump.map(this.linkBreedsOwn) + "\n");
        return buf.toString();
    }
}

