/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import org.junit.Assert;
import org.junit.Test;
import org.nlogo.api.File;

public class TestFile {
    @Test
    public void testRestoreInnerNewLines() {
        Assert.assertEquals((Object)"foo\n\"foo\\n\"", (Object)File.restoreLines("foo\\n\"foo\\\\n\""));
    }

    @Test
    public void testRestoreInitialLineBreaks() {
        Assert.assertEquals((Object)"\n\n\nfoo", (Object)File.restoreLines("\\n\\n\\nfoo"));
    }

    @Test
    public void testRestoreConsecutiveLineBreaks() {
        Assert.assertEquals((Object)"foo\n\nbar", (Object)File.restoreLines("foo\\n\\nbar"));
    }

    @Test
    public void testRestoreLineBreak() {
        Assert.assertEquals((Object)"foo\nbar", (Object)File.restoreLines("foo\\nbar"));
    }

    @Test
    public void testRestoreSimple() {
        Assert.assertEquals((Object)"foo", (Object)File.restoreLines("foo"));
    }

    @Test
    public void testRestoreBlank() {
        Assert.assertEquals(null, (Object)File.restoreLines(""));
    }

    @Test
    public void testStripInnerNewLines() {
        Assert.assertEquals((Object)"foo\\n\\\"foo\\\\n\\\"", (Object)File.stripLines("foo\n\"foo\\n\""));
    }

    @Test
    public void testStripTrailingLineBreak() {
        Assert.assertEquals((Object)"foo\\n", (Object)File.stripLines("foo\n"));
    }

    @Test
    public void testStripConsecutiveLineBreaks() {
        Assert.assertEquals((Object)"foo\\n\\nbar", (Object)File.stripLines("foo\n\nbar"));
    }

    @Test
    public void testStripLineBreak() {
        Assert.assertEquals((Object)"foo\\nbar", (Object)File.stripLines("foo\nbar"));
    }

    @Test
    public void testStripSimple() {
        Assert.assertEquals((Object)"foo", (Object)File.stripLines("foo"));
    }

    @Test
    public void testStripBlank() {
        Assert.assertNull((Object)File.stripLines(""));
    }
}

