/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import org.junit.Assert;
import org.junit.Test;
import org.nlogo.api.Vect;

public class TestVect {
    @Test
    public void testRotateX() {
        Assert.assertEquals((Object)this.v(0.0, -1.0, 0.0), (Object)this.v(0.0, 0.0, 1.0).rotateX(90.0));
        Assert.assertEquals((Object)this.v(0.0, 1.0, 0.0), (Object)this.v(0.0, 0.0, 1.0).rotateX(-90.0));
        Assert.assertEquals((Object)this.v(1.0, -0.9999999999999999, 1.0), (Object)this.v(1.0, 1.0, 1.0).rotateX(90.0));
    }

    @Test
    public void testInvert() {
        Assert.assertEquals((Object)this.v(-1.0, -2.0, -3.0), (Object)this.v(1.0, 2.0, 3.0).invert());
    }

    @Test
    public void testCorrect() {
        Assert.assertEquals((Object)this.v(0.1, 0.1, 0.1), (Object)this.v(0.1, 0.1, 0.1).correct());
        Assert.assertEquals((Object)this.v(0.0, 0.0, 0.0), (Object)this.v(1.0E-16, 1.0E-16, 1.0E-16).correct());
    }

    @Test
    public void testNormalize3() {
        Assert.assertEquals((Object)this.v(0.0, 0.0, 1.0), (Object)this.v(0.0, 0.0, 2.0).normalize());
    }

    @Test
    public void testNormalize2() {
        Assert.assertEquals((Object)this.v(0.0, 1.0, 0.0), (Object)this.v(0.0, 2.0, 0.0).normalize());
    }

    @Test
    public void testNormalize1() {
        Assert.assertEquals((Object)this.v(1.0, 0.0, 0.0), (Object)this.v(2.0, 0.0, 0.0).normalize());
    }

    @Test
    public void testNormalize0() {
        Assert.assertEquals((Object)this.v(0.0, 0.0, 0.0), (Object)this.v(0.0, 0.0, 0.0).normalize());
    }

    @Test
    public void testInequality() {
        Vect vect = this.v(1.0, 0.0, 0.0);
        Vect vect2 = this.v(0.0, 0.0, 0.0);
        Assert.assertFalse((!(vect != null ? !((Object)vect).equals(vect2) : vect2 != null) ? 1 : 0) != 0);
        Vect vect3 = this.v(0.0, 1.0, 0.0);
        Vect vect4 = this.v(0.0, 0.0, 0.0);
        Assert.assertFalse((!(vect3 != null ? !((Object)vect3).equals(vect4) : vect4 != null) ? 1 : 0) != 0);
        Vect vect5 = this.v(0.0, 0.0, 1.0);
        Vect vect6 = this.v(0.0, 0.0, 0.0);
        Assert.assertFalse((!(vect5 != null ? !((Object)vect5).equals(vect6) : vect6 != null) ? 1 : 0) != 0);
        Vect vect7 = this.v(0.0, 0.0, 0.0);
        Vect vect8 = this.v(1.0, 0.0, 0.0);
        Assert.assertFalse((!(vect7 != null ? !((Object)vect7).equals(vect8) : vect8 != null) ? 1 : 0) != 0);
        Vect vect9 = this.v(0.0, 0.0, 0.0);
        Vect vect10 = this.v(0.0, 1.0, 0.0);
        Assert.assertFalse((!(vect9 != null ? !((Object)vect9).equals(vect10) : vect10 != null) ? 1 : 0) != 0);
        Vect vect11 = this.v(0.0, 0.0, 0.0);
        Vect vect12 = this.v(0.0, 0.0, 1.0);
        Assert.assertFalse((!(vect11 != null ? !((Object)vect11).equals(vect12) : vect12 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testMagnitude() {
        Assert.assertEquals((double)0.0, (double)this.v(0.0, 0.0, 0.0).magnitude(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)this.v(1.0, 0.0, 0.0).magnitude(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)this.v(0.0, 1.0, 0.0).magnitude(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)this.v(0.0, 0.0, 1.0).magnitude(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)this.v(0.0, 3.0, 4.0).magnitude(), (double)0.0);
        Assert.assertEquals((double)9.0, (double)this.v(8.0, 4.0, 1.0).magnitude(), (double)0.0);
    }

    @Test
    public void testEquality() {
        Vect vect;
        Vect vect2 = vect = this.v(1.0, 2.0, 3.0);
        Assert.assertTrue((!(vect2 != null ? !((Object)vect2).equals(vect) : vect != null) ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"[1.0 2.0 3.0]", (Object)this.v(1.0, 2.0, 3.0).toString());
        Assert.assertEquals((Object)"[1.1 2.2 3.3]", (Object)this.v(1.1, 2.2, 3.3).toString());
    }

    public Vect v(double x, double y, double z) {
        return new Vect(x, y, z);
    }
}

