/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Utils {
    private Utils() {
        throw new IllegalStateException();
    }

    public static Frame getFrame(Component comp) {
        Component top = Utils.getTopAncestor(comp);
        if (top instanceof Frame) {
            return (Frame)top;
        }
        if (top instanceof Window && top.getParent() != null) {
            return Utils.getFrame(top.getParent());
        }
        return null;
    }

    public static Component getTopAncestor(Component comp) {
        Component top = comp;
        Container parent = top.getParent();
        while (!(top instanceof Window) && null != parent) {
            top = parent;
            parent = top.getParent();
        }
        return top;
    }

    public static Container findAncestorOfClass(Component component, Class<?> theClass) {
        if (component == null) {
            return null;
        }
        if (theClass.isInstance(component)) {
            return (Container)component;
        }
        return Utils.findAncestorOfClass(component.getParent(), theClass);
    }

    public static Color mixColors(Color c1, Color c2, double mix) {
        mix = StrictMath.min(mix, 1.0);
        mix = StrictMath.max(mix, 0.0);
        return new Color((int)((double)c1.getRed() * mix + (double)c2.getRed() * (1.0 - mix)), (int)((double)c1.getGreen() * mix + (double)c2.getGreen() * (1.0 - mix)), (int)((double)c1.getBlue() * mix + (double)c2.getBlue() * (1.0 - mix)));
    }

    public static String shortenStringToFit(String name, int availableWidth, FontMetrics metrics) {
        if (metrics.stringWidth(name) > availableWidth) {
            name = name + "...";
            while (metrics.stringWidth(name) > availableWidth && name.length() > 3) {
                name = name.substring(0, name.length() - 4) + "...";
            }
        }
        return name;
    }

    public static List<String> breakLines(String text, FontMetrics metrics, int width) {
        ArrayList<String> result = new ArrayList<String>();
        while (text.length() > 0) {
            int spaceIndex;
            int index;
            for (index = 0; index < text.length() && (metrics.stringWidth(text.substring(0, index + 1)) < width || text.charAt(index) == ' '); ++index) {
                if (text.charAt(index) != '\n') continue;
                text = text.substring(0, index) + ' ' + text.substring(index + 1);
                ++index;
                break;
            }
            if (index == 0) {
                result.add(text);
                return result;
            }
            if (index < text.length() && (spaceIndex = text.substring(0, index).lastIndexOf(32)) >= 0) {
                index = spaceIndex + 1;
            }
            String thisLine = text.substring(0, index);
            text = index < text.length() ? text.substring(index, text.length()) : "";
            result.add(thisLine);
        }
        if (result.isEmpty()) {
            result.add("");
        }
        return result;
    }

    public static void center(Window window, Window parent) {
        Rectangle availBounds;
        int y;
        int x;
        if (parent == null) {
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            x = center.x - window.getWidth() / 2;
            y = center.y - window.getHeight() / 2;
            availBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        } else {
            x = parent.getLocation().x + parent.getWidth() / 2 - window.getPreferredSize().width / 2;
            y = parent.getLocation().y + parent.getHeight() / 2 - window.getPreferredSize().height / 2;
            availBounds = parent.getGraphicsConfiguration().getBounds();
        }
        x = StrictMath.min(x, availBounds.x + availBounds.width - window.getWidth());
        y = StrictMath.min(y, availBounds.y + availBounds.height - window.getHeight());
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static boolean button1Mask(MouseEvent e) {
        return (e.getModifiers() & 0x10) != 0;
    }

    public static String platformFont() {
        if (System.getProperty("os.name").startsWith("Mac")) {
            return "Lucida Grande";
        }
        return "Sans-serif";
    }

    public static String platformMonospacedFont() {
        if (System.getProperty("os.name").startsWith("Mac")) {
            return "Monaco";
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            for (int i = 0; i < fonts.length; ++i) {
                if (!fonts[i].equalsIgnoreCase("Lucida Console")) continue;
                return fonts[i];
            }
            return "Monospaced";
        }
        return "Monospaced";
    }

    public static void adjustDefaultFont(Component comp) {
        if (System.getProperty("os.name").startsWith("Mac")) {
            comp.setFont(new Font(Utils.platformFont(), 0, 11));
        } else if (!System.getProperty("os.name").startsWith("Windows")) {
            comp.setFont(new Font(Utils.platformFont(), 0, 12));
        }
    }

    public static void mustBeEventDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("not event thread: " + Thread.currentThread());
        }
    }

    public static void invokeLater(Runnable r) {
        EventQueue.invokeLater(r);
    }

    public static void invokeAndWait(Runnable r) throws InterruptedException {
        try {
            EventQueue.invokeAndWait(r);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static BufferedImage paintToImage(Component comp) {
        BufferedImage image = new BufferedImage(comp.getWidth(), comp.getHeight(), 2);
        comp.printAll(image.getGraphics());
        return image;
    }

    public static String AWTColorToHex(Color c) {
        String s = Integer.toHexString(c.getRGB());
        s = s.substring(s.length() - 6);
        return s;
    }

    public static String colorize(String s, Color c) {
        String str = "<font color=\"#" + Utils.AWTColorToHex(c) + "\">" + s + "</font>";
        return str;
    }
}

