/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LogoList;
import org.nlogo.api.Token;
import org.nlogo.api.TokenType;
import org.nlogo.compiler.CompilerExceptionThrowers$;
import org.nlogo.compiler.ConstantParser$;
import org.nlogo.prim._link;
import org.nlogo.prim._links;
import org.nlogo.prim._patch;
import org.nlogo.prim._patches;
import org.nlogo.prim._turtle;
import org.nlogo.prim._turtles;
import org.nlogo.util.JCL$;
import scala.Iterator;
import scala.List$;
import scala.MatchError;
import scala.Predef$;
import scala.StringBuilder;
import scala.Tuple3;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantParser {
    private final Pattern EXTENSION_TYPE_PATTERN;
    private final String SET_TYPE_OBSERVER;
    private final String SET_TYPE_BREED;
    private final String SET_TYPE_ALLLINKS;
    private final String SET_TYPE_ALLTURTLES;
    private final String SET_TYPE_ALLPATCHES;
    private final String NOT_A_BREED;
    private final String NOT_AN_AGENTSET;
    private final String MISSING_CLOSE_BRACKET;
    private final String ILLEGAL_AGENT_CONSTANT;
    private final String EXTRA_STUFF_AFTER_NUMBER;
    private final String EXTRA_STUFF_AFTER_CONSTANT;
    private final String EXPECTED_OPEN_BRACKET;
    private final String EXPECTED_OPEN_BRACE;
    private final String EXPECTED_INT_ETC;
    private final String EXPECTED_NUMBER;
    private final String EXPECTED_CONSTANT;
    private final String EXPECTED_CLOSE_PAREN;
    private final String EXPECTED_CLOSE_BRACE;
    private final String EXPECTED_BREED;
    private final String BAD_TURTLE_ARG;
    private final String BAD_LINK_SET_ARGS;
    private final String BAD_TURTLE_SET_ARGS;
    private final String BAD_LINK_ARGS;
    private final String BAD_PATCH_ARGS;
    private final String BAD_PATCH_SET_ARGS;
    private final String BAD_AGENT;
    private final ExtensionManager extensionManager;
    private final World world;

    public ConstantParser(World world, ExtensionManager extensionManager) {
        this.world = world;
        this.extensionManager = extensionManager;
        this.BAD_AGENT = "Not an agent";
        this.BAD_PATCH_SET_ARGS = "Patch agentsets are given by a set of 2 element integer lists containing a patch's pxcor and pycor";
        this.BAD_PATCH_ARGS = "pxcor and pycor must be floats";
        this.BAD_LINK_ARGS = "end1 and end2 must be floats";
        this.BAD_TURTLE_SET_ARGS = "Turtle agentsets are given by a set of turtles' who numbers";
        this.BAD_LINK_SET_ARGS = "Link agentsets are given by a set of links' endpoints and breeds";
        this.BAD_TURTLE_ARG = "a turtle's who number must be an integer";
        this.EXPECTED_BREED = "Expected breed";
        this.EXPECTED_CLOSE_BRACE = "Expected closing brace.";
        this.EXPECTED_CLOSE_PAREN = "Expected a closing parenthesis.";
        this.EXPECTED_CONSTANT = "Expected a constant.";
        this.EXPECTED_NUMBER = "Expected a number.";
        this.EXPECTED_INT_ETC = "Expected number, list, string or boolean";
        this.EXPECTED_OPEN_BRACE = "Expected open brace.";
        this.EXPECTED_OPEN_BRACKET = "Internal error: Expected an opening bracket here.";
        this.EXTRA_STUFF_AFTER_CONSTANT = "Extra characters after constant.";
        this.EXTRA_STUFF_AFTER_NUMBER = "Extra characters after number.";
        this.ILLEGAL_AGENT_CONSTANT = "Can only have constant agents and agentsets if importing.";
        this.MISSING_CLOSE_BRACKET = "No closing bracket for this open bracket.";
        this.NOT_AN_AGENTSET = " is not an agentset";
        this.NOT_A_BREED = " is not a breed";
        this.SET_TYPE_ALLPATCHES = "ALL-PATCHES";
        this.SET_TYPE_ALLTURTLES = "ALL-TURTLES";
        this.SET_TYPE_ALLLINKS = "ALL-LINKS";
        this.SET_TYPE_BREED = "BREED";
        this.SET_TYPE_OBSERVER = "OBSERVER";
        this.EXTENSION_TYPE_PATTERN = Pattern.compile("\\{\\{(\\S*):(\\S*)\\s(.*)\\}\\}");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parseConstantAgentOrAgentSet(Token token, Iterator<Token> iterator) {
        Object object;
        block29: {
            block28: {
                block27: {
                    Token token3;
                    block26: {
                        String string;
                        block25: {
                            World world = this.world;
                            CompilerExceptionThrowers$.MODULE$.cAssert(world != null && !world.equals(null), this.ILLEGAL_AGENT_CONSTANT(), token);
                            token3 = iterator.next();
                            CompilerExceptionThrowers$.MODULE$.cAssert(List$.MODULE$.apply(ScalaRunTime$.MODULE$.boxArray(new TokenType[]{TokenType.VARIABLE, TokenType.IDENT, TokenType.REPORTER})).contains((Object)token3.tyype()), this.EXPECTED_BREED(), token3);
                            TokenType tokenType = token3.tyype();
                            TokenType tokenType2 = TokenType.VARIABLE;
                            if (!(tokenType == null ? tokenType2 != null : !((Object)((Object)tokenType)).equals((Object)tokenType2))) break block25;
                            TokenType tokenType3 = token3.tyype();
                            TokenType tokenType4 = TokenType.IDENT;
                            if (tokenType3 != null ? !((Object)((Object)tokenType3)).equals((Object)tokenType4) : tokenType4 != null) break block26;
                        }
                        if ((string = (String)token3.value()).equalsIgnoreCase(this.SET_TYPE_BREED())) {
                            AgentSet agentSet;
                            AgentSet agentSet2;
                            Token token5 = iterator.next();
                            TokenType tokenType = token5.tyype();
                            TokenType tokenType5 = TokenType.IDENT;
                            CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType5) : tokenType5 != null), this.EXPECTED_BREED(), token5);
                            Token token6 = iterator.next();
                            TokenType tokenType4 = token6.tyype();
                            TokenType tokenType7 = TokenType.CLOSE_BRACE;
                            CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType4 != null ? !((Object)((Object)tokenType4)).equals((Object)tokenType7) : tokenType7 != null), this.EXPECTED_CLOSE_BRACE(), token6);
                            String string3 = (String)token5.value();
                            AgentSet agentSet3 = agentSet2 = this.world.getBreed(string3);
                            AgentSet agentSet4 = agentSet = agentSet3 == null || agentSet3.equals(null) ? this.world.getLinkBreed(string3) : agentSet2;
                            CompilerExceptionThrowers$.MODULE$.cAssert(agentSet4 != null && !agentSet4.equals(null), new StringBuilder().append((Object)string3).append((Object)this.NOT_A_BREED()).toString(), token3);
                            object = agentSet;
                            return object;
                        }
                        if (List$.MODULE$.apply(ScalaRunTime$.MODULE$.boxArray(new String[]{this.SET_TYPE_ALLTURTLES(), this.SET_TYPE_ALLPATCHES(), this.SET_TYPE_ALLLINKS()})).contains(string.toUpperCase())) {
                            String string2;
                            Token token7 = iterator.next();
                            TokenType tokenType = token7.tyype();
                            TokenType tokenType8 = TokenType.CLOSE_BRACE;
                            CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType8) : tokenType8 != null), this.EXPECTED_CLOSE_BRACE(), token7);
                            String string3 = string2 = string.toUpperCase();
                            String string5 = this.SET_TYPE_ALLTURTLES();
                            if (!(string3 != null ? !string3.equals(string5) : string5 != null)) {
                                object = this.world.turtles();
                                return object;
                            }
                            String string4 = string2;
                            String string7 = this.SET_TYPE_ALLLINKS();
                            if (!(string4 != null ? !string4.equals(string7) : string7 != null)) {
                                object = this.world.links();
                                return object;
                            }
                            String string6 = string2;
                            String string9 = this.SET_TYPE_ALLPATCHES();
                            if (string6 == null) {
                                if (string9 != null) {
                                    throw new MatchError(string2);
                                }
                            } else if (!string6.equals(string9)) throw new MatchError(string2);
                            object = this.world.patches();
                            return object;
                        }
                        if (string.equalsIgnoreCase(this.SET_TYPE_OBSERVER())) {
                            Token token8 = iterator.next();
                            TokenType tokenType = token8.tyype();
                            TokenType tokenType9 = TokenType.CLOSE_BRACE;
                            CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType9) : tokenType9 != null), this.EXPECTED_CLOSE_BRACE(), token8);
                            ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Observer.class, 1, false, this.world);
                            arrayAgentSet.add(this.world.observer());
                            object = arrayAgentSet;
                            return object;
                        }
                        if (this.world.program().breedsSingular.containsKey(string.toUpperCase())) {
                            Token token4 = iterator.next();
                            TokenType tokenType = token4.tyype();
                            TokenType tokenType10 = TokenType.CONSTANT;
                            if (tokenType == null) {
                                if (tokenType10 != null) {
                                    throw CompilerExceptionThrowers$.MODULE$.exception(this.BAD_TURTLE_ARG(), token4);
                                }
                            } else if (!((Object)((Object)tokenType)).equals((Object)tokenType10)) throw CompilerExceptionThrowers$.MODULE$.exception(this.BAD_TURTLE_ARG(), token4);
                            if (!(token4.value() instanceof Double)) throw CompilerExceptionThrowers$.MODULE$.exception(this.BAD_TURTLE_ARG(), token4);
                            Token token9 = iterator.next();
                            TokenType tokenType5 = token9.tyype();
                            TokenType tokenType12 = TokenType.CLOSE_BRACE;
                            CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType5 != null ? !((Object)((Object)tokenType5)).equals((Object)tokenType12) : tokenType12 != null), this.EXPECTED_CLOSE_BRACE(), token9);
                            object = this.world.getOrCreateTurtle(Predef$.MODULE$.int2long(((Double)token4.value()).intValue()));
                            return object;
                        }
                        if (!this.world.program().linkBreedsSingular.containsKey(string.toUpperCase())) throw CompilerExceptionThrowers$.MODULE$.exception(new StringBuilder().append((Object)string).append((Object)this.NOT_AN_AGENTSET()).toString(), token3);
                        Double d = this.parseEnd(iterator);
                        Double d2 = this.parseEnd(iterator);
                        Token token10 = iterator.next();
                        TokenType tokenType = token10.tyype();
                        TokenType tokenType13 = TokenType.CLOSE_BRACE;
                        CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType13) : tokenType13 != null), this.EXPECTED_CLOSE_BRACE(), token10);
                        object = this.world.getOrCreateLink(d, d2, this.world.getLinkBreed(this.world.program().linkBreedsSingular.get(string.toUpperCase())));
                        return object;
                    }
                    if (token3.value() instanceof _turtles) break block27;
                    if (token3.value() instanceof _links) break block28;
                    if (!(token3.value() instanceof _patches)) {
                        if (!List$.MODULE$.apply(ScalaRunTime$.MODULE$.boxArray(new Class[]{_turtle.class, _patch.class, _link.class, org.nlogo.prim.threed._patch.class})).contains(token3.value().getClass())) throw CompilerExceptionThrowers$.MODULE$.exception(new StringBuilder().append((Object)token3.name()).append((Object)this.NOT_AN_AGENTSET()).toString(), token3);
                        Agent agent = this.parseConstantAgent(token3, iterator);
                        Token token13 = iterator.next();
                        TokenType tokenType = token13.tyype();
                        TokenType tokenType21 = TokenType.CLOSE_BRACE;
                        CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType21) : tokenType21 != null), this.EXPECTED_CLOSE_BRACE(), token13);
                        object = agent;
                        return object;
                    }
                    break block29;
                }
                ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Turtle.class, 1, false, this.world);
                Token token11 = iterator.next();
                while (true) {
                    TokenType tokenType = token11.tyype();
                    TokenType tokenType14 = TokenType.CLOSE_BRACE;
                    if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType14) : tokenType14 != null)) {
                        object = arrayAgentSet;
                        return object;
                    }
                    Object object2 = this.readConstantPrefix(token11, iterator);
                    CompilerExceptionThrowers$.MODULE$.cAssert(object2 instanceof Double, this.BAD_TURTLE_SET_ARGS(), token11);
                    arrayAgentSet.add(this.world.getOrCreateTurtle(Predef$.MODULE$.int2long(((Double)object2).intValue())));
                    token11 = iterator.next();
                }
            }
            ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Link.class, 1, false, this.world);
            Token token12 = iterator.next();
            while (true) {
                Link link;
                TokenType tokenType = token12.tyype();
                TokenType tokenType15 = TokenType.CLOSE_BRACE;
                if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType15) : tokenType15 != null)) {
                    object = arrayAgentSet;
                    return object;
                }
                TokenType tokenType6 = token12.tyype();
                TokenType tokenType17 = TokenType.OPEN_BRACKET;
                CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType6 != null ? !((Object)((Object)tokenType6)).equals((Object)tokenType17) : tokenType17 != null), this.BAD_LINK_SET_ARGS(), token12);
                LogoList logoList = (LogoList)this.readConstantPrefix(token12, iterator);
                CompilerExceptionThrowers$.MODULE$.cAssert(logoList.size() == 3 && logoList.get(0) instanceof Double && logoList.get(1) instanceof Double && logoList.get(2) instanceof AgentSet, this.BAD_LINK_SET_ARGS(), token12);
                Link link2 = link = this.world.getOrCreateLink((Double)logoList.get(0), (Double)logoList.get(1), (AgentSet)logoList.get(2));
                if (link2 != null && !link2.equals(null)) {
                    arrayAgentSet.add(link);
                }
                token12 = iterator.next();
            }
        }
        ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Patch.class, 1, false, this.world);
        Token token2 = iterator.next();
        while (true) {
            TokenType tokenType = token2.tyype();
            TokenType tokenType18 = TokenType.CLOSE_BRACE;
            if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType18) : tokenType18 != null)) {
                object = arrayAgentSet;
                return object;
            }
            TokenType tokenType7 = token2.tyype();
            TokenType tokenType20 = TokenType.OPEN_BRACKET;
            CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType7 != null ? !((Object)((Object)tokenType7)).equals((Object)tokenType20) : tokenType20 != null), this.BAD_PATCH_SET_ARGS(), token2);
            LogoList logoList = (LogoList)this.readConstantPrefix(token2, iterator);
            CompilerExceptionThrowers$.MODULE$.cAssert(logoList.size() == 2 && JCL$.MODULE$.iterableFromJava(logoList).forall(new $anonfun$parseConstantAgentOrAgentSet$1(this)), this.BAD_PATCH_SET_ARGS(), token2);
            try {
                arrayAgentSet.add(this.world.getPatchAt(Predef$.MODULE$.int2double(((Double)logoList.get(0)).intValue()), Predef$.MODULE$.int2double(((Double)logoList.get(1)).intValue())));
                token2 = iterator.next();
            }
            catch (AgentException agentException) {
                throw CompilerExceptionThrowers$.MODULE$.exception("Invalid patch coordinates in one of the agents of this set.", token2);
            }
        }
    }

    private Double parseEnd(Iterator<Token> tokens) {
        Token token = tokens.next();
        TokenType tokenType = token.tyype();
        TokenType tokenType2 = TokenType.CONSTANT;
        CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null) && token.value() instanceof Double, this.BAD_LINK_ARGS(), token);
        return (Double)token.value();
    }

    private double parsePcor(Iterator<Token> tokens) {
        Token token = tokens.next();
        TokenType tokenType = token.tyype();
        TokenType tokenType2 = TokenType.CONSTANT;
        CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null) && token.value() instanceof Double, this.BAD_PATCH_ARGS(), token);
        return Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble(token.value()));
    }

    /*
     * Loose catch block
     */
    private Agent parseConstantAgent(Token token, Iterator<Token> iterator) {
        double d;
        double d2;
        block12: {
            Agent agent;
            block10: {
                Object object;
                block11: {
                    block8: {
                        Token token2;
                        block9: {
                            World world = this.world;
                            CompilerExceptionThrowers$.MODULE$.cAssert(world != null && !world.equals(null), this.ILLEGAL_AGENT_CONSTANT(), token);
                            object = token.value();
                            if (object instanceof _patch) {
                                d2 = this.parsePcor(iterator);
                                d = this.parsePcor(iterator);
                                Patch patch = null;
                                agent = patch = this.world.getPatchAt(d2, d);
                            }
                            if (!(object instanceof _turtle)) break block8;
                            token2 = iterator.next();
                            TokenType tokenType = token2.tyype();
                            TokenType tokenType2 = TokenType.CONSTANT;
                            if ((tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null) || !(token2.value() instanceof Double)) break block9;
                            agent = this.world.getOrCreateTurtle(((Double)token2.value()).longValue());
                            break block10;
                        }
                        throw CompilerExceptionThrowers$.MODULE$.exception(this.BAD_TURTLE_ARG(), token2);
                    }
                    if (!(object instanceof _link)) break block11;
                    agent = this.world.getOrCreateLink(this.parseEnd(iterator), this.parseEnd(iterator), this.world.links());
                    break block10;
                }
                if (!(object instanceof org.nlogo.prim.threed._patch)) break block12;
                double d3 = this.parsePcor(iterator);
                double d4 = this.parsePcor(iterator);
                double d5 = this.parsePcor(iterator);
                Tuple3<Double, Double, Double> tuple3 = new Tuple3<Double, Double, Double>(BoxesRunTime.boxToDouble(d3), BoxesRunTime.boxToDouble(d4), BoxesRunTime.boxToDouble(d5));
                double d6 = BoxesRunTime.unboxToDouble(tuple3._1());
                double d7 = BoxesRunTime.unboxToDouble(tuple3._2());
                double d8 = BoxesRunTime.unboxToDouble(tuple3._3());
                Patch3D patch3D = null;
                try {
                    patch3D = ((World3D)this.world).getPatchAt(d6, d7, d8);
                    agent = patch3D;
                }
                catch (AgentException agentException) {
                    throw CompilerExceptionThrowers$.MODULE$.exception(new StringBuilder().append((Object)"Invalid patch coordinates ( ").append(BoxesRunTime.boxToDouble(d6)).append((Object)" , ").append(BoxesRunTime.boxToDouble(d7)).append((Object)" , ").append(BoxesRunTime.boxToDouble(d8)).append((Object)" ) ").toString(), token);
                }
            }
            return agent;
        }
        throw CompilerExceptionThrowers$.MODULE$.exception(this.BAD_AGENT(), token);
        catch (AgentException agentException) {
            throw CompilerExceptionThrowers$.MODULE$.exception(new StringBuilder().append((Object)"Invalid patch coordinates ( ").append(BoxesRunTime.boxToDouble(d2)).append((Object)" , ").append(BoxesRunTime.boxToDouble(d)).append((Object)" ) ").toString(), token);
        }
    }

    private Object parseConstantLiteral(Token token) {
        World world = this.world;
        CompilerExceptionThrowers$.MODULE$.cAssert(world != null && !world.equals(null), this.ILLEGAL_AGENT_CONSTANT(), token);
        Matcher matcher = this.EXTENSION_TYPE_PATTERN().matcher((String)token.value());
        return matcher.matches() ? this.extensionManager.readExtensionObject(matcher.group(1), matcher.group(2), matcher.group(3)) : token.value();
    }

    public LogoList parseConstantList(Token openBracket, Iterator<Token> tokens) {
        LogoList list = new LogoList();
        boolean done = false;
        while (!done) {
            Serializable serializable;
            Token token = tokens.next();
            TokenType tokenType = token.tyype();
            TokenType tokenType2 = TokenType.CLOSE_BRACKET;
            TokenType tokenType3 = tokenType;
            if (!(tokenType2 != null ? !((Object)((Object)tokenType2)).equals((Object)tokenType3) : tokenType3 != null)) {
                done = true;
                serializable = BoxedUnit.UNIT;
                continue;
            }
            TokenType tokenType4 = TokenType.EOF;
            TokenType tokenType5 = tokenType;
            if (!(tokenType4 != null ? !((Object)((Object)tokenType4)).equals((Object)tokenType5) : tokenType5 != null)) {
                throw CompilerExceptionThrowers$.MODULE$.exception(this.MISSING_CLOSE_BRACKET(), openBracket);
            }
            serializable = BoxesRunTime.boxToBoolean(list.add(this.readConstantPrefix(token, tokens)));
        }
        return list;
    }

    private Object readConstantPrefix(Token token, Iterator<Token> tokens) {
        while (true) {
            TokenType tokenType;
            block8: {
                Object object;
                block4: {
                    block7: {
                        block6: {
                            block5: {
                                block3: {
                                    tokenType = token.tyype();
                                    TokenType tokenType2 = TokenType.LITERAL;
                                    TokenType tokenType3 = tokenType;
                                    if (tokenType2 != null ? !((Object)((Object)tokenType2)).equals((Object)tokenType3) : tokenType3 != null) break block3;
                                    object = this.parseConstantLiteral(token);
                                    break block4;
                                }
                                TokenType tokenType4 = TokenType.CONSTANT;
                                TokenType tokenType5 = tokenType;
                                if (tokenType4 != null ? !((Object)((Object)tokenType4)).equals((Object)tokenType5) : tokenType5 != null) break block5;
                                object = token.value();
                                break block4;
                            }
                            TokenType tokenType6 = TokenType.OPEN_BRACKET;
                            TokenType tokenType7 = tokenType;
                            if (tokenType6 != null ? !((Object)((Object)tokenType6)).equals((Object)tokenType7) : tokenType7 != null) break block6;
                            object = this.parseConstantList(token, tokens);
                            break block4;
                        }
                        TokenType tokenType8 = TokenType.OPEN_BRACE;
                        TokenType tokenType9 = tokenType;
                        if (tokenType8 != null ? !((Object)((Object)tokenType8)).equals((Object)tokenType9) : tokenType9 != null) break block7;
                        object = this.parseConstantAgentOrAgentSet(token, tokens);
                        break block4;
                    }
                    TokenType tokenType10 = TokenType.OPEN_PAREN;
                    TokenType tokenType11 = tokenType;
                    if (tokenType10 != null ? !((Object)((Object)tokenType10)).equals((Object)tokenType11) : tokenType11 != null) break block8;
                    Object result = this.readConstantPrefix(tokens.next(), tokens);
                    Token closeParen = tokens.next();
                    TokenType tokenType12 = closeParen.tyype();
                    TokenType tokenType13 = TokenType.CLOSE_PAREN;
                    CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType12 != null ? !((Object)((Object)tokenType12)).equals((Object)tokenType13) : tokenType13 != null), this.EXPECTED_CLOSE_PAREN(), closeParen);
                    object = result;
                }
                return object;
            }
            TokenType tokenType14 = TokenType.COMMENT;
            TokenType tokenType15 = tokenType;
            if (tokenType14 != null ? !((Object)((Object)tokenType14)).equals((Object)tokenType15) : tokenType15 != null) break;
            token = tokens.next();
        }
        throw CompilerExceptionThrowers$.MODULE$.exception(this.EXPECTED_CONSTANT(), token);
    }

    public Double getNumberValue(Iterator<Token> tokens) {
        Token token = tokens.next();
        TokenType tokenType = token.tyype();
        TokenType tokenType2 = TokenType.CONSTANT;
        if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null) && token.value() instanceof Double) {
            Token extra = tokens.next();
            TokenType tokenType3 = extra.tyype();
            TokenType tokenType4 = TokenType.EOF;
            CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType3 != null ? !((Object)((Object)tokenType3)).equals((Object)tokenType4) : tokenType4 != null), this.EXTRA_STUFF_AFTER_NUMBER(), extra);
            return (Double)token.value();
        }
        throw CompilerExceptionThrowers$.MODULE$.exception(this.EXPECTED_NUMBER(), token);
    }

    public Object getConstantFromFile(Iterator<Token> tokens) {
        return this.readConstantPrefix(tokens.next(), tokens);
    }

    /*
     * WARNING - void declaration
     */
    public Object getConstantValue(Iterator<Token> tokens) {
        void var2_2;
        Object result = this.readConstantPrefix(tokens.next(), tokens);
        Token extra = tokens.next();
        TokenType tokenType = extra.tyype();
        TokenType tokenType2 = TokenType.EOF;
        CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null), this.EXTRA_STUFF_AFTER_CONSTANT(), extra);
        return var2_2;
    }

    private Pattern EXTENSION_TYPE_PATTERN() {
        return this.EXTENSION_TYPE_PATTERN;
    }

    private String SET_TYPE_OBSERVER() {
        return this.SET_TYPE_OBSERVER;
    }

    private String SET_TYPE_BREED() {
        return this.SET_TYPE_BREED;
    }

    private String SET_TYPE_ALLLINKS() {
        return this.SET_TYPE_ALLLINKS;
    }

    private String SET_TYPE_ALLTURTLES() {
        return this.SET_TYPE_ALLTURTLES;
    }

    private String SET_TYPE_ALLPATCHES() {
        return this.SET_TYPE_ALLPATCHES;
    }

    private String NOT_A_BREED() {
        return this.NOT_A_BREED;
    }

    private String NOT_AN_AGENTSET() {
        return this.NOT_AN_AGENTSET;
    }

    private String MISSING_CLOSE_BRACKET() {
        return this.MISSING_CLOSE_BRACKET;
    }

    private String ILLEGAL_AGENT_CONSTANT() {
        return this.ILLEGAL_AGENT_CONSTANT;
    }

    private String EXTRA_STUFF_AFTER_NUMBER() {
        return this.EXTRA_STUFF_AFTER_NUMBER;
    }

    private String EXTRA_STUFF_AFTER_CONSTANT() {
        return this.EXTRA_STUFF_AFTER_CONSTANT;
    }

    private String EXPECTED_NUMBER() {
        return this.EXPECTED_NUMBER;
    }

    private String EXPECTED_CONSTANT() {
        return this.EXPECTED_CONSTANT;
    }

    private String EXPECTED_CLOSE_PAREN() {
        return this.EXPECTED_CLOSE_PAREN;
    }

    private String EXPECTED_CLOSE_BRACE() {
        return this.EXPECTED_CLOSE_BRACE;
    }

    private String EXPECTED_BREED() {
        return this.EXPECTED_BREED;
    }

    private String BAD_TURTLE_ARG() {
        return this.BAD_TURTLE_ARG;
    }

    private String BAD_LINK_SET_ARGS() {
        return this.BAD_LINK_SET_ARGS;
    }

    private String BAD_TURTLE_SET_ARGS() {
        return this.BAD_TURTLE_SET_ARGS;
    }

    private String BAD_LINK_ARGS() {
        return this.BAD_LINK_ARGS;
    }

    private String BAD_PATCH_ARGS() {
        return this.BAD_PATCH_ARGS;
    }

    private String BAD_PATCH_SET_ARGS() {
        return this.BAD_PATCH_SET_ARGS;
    }

    private String BAD_AGENT() {
        return this.BAD_AGENT;
    }

    public ConstantParser() {
        this(null, null);
    }
}

