/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import org.nlogo.api.Token;
import org.nlogo.api.Token$;
import org.nlogo.api.TokenType;
import org.nlogo.compiler.Application;
import org.nlogo.compiler.CommandBlock;
import org.nlogo.compiler.CompilerExceptionThrowers$;
import org.nlogo.compiler.ConstantParser;
import org.nlogo.compiler.ConstantParser$;
import org.nlogo.compiler.Expression;
import org.nlogo.compiler.ExpressionParser;
import org.nlogo.compiler.ExpressionParser$;
import org.nlogo.compiler.ReporterApp;
import org.nlogo.compiler.ReporterBlock;
import org.nlogo.compiler.Statement;
import org.nlogo.compiler.Statements;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Referenceable;
import org.nlogo.nvm.Reporter;
import org.nlogo.nvm.Syntax;
import org.nlogo.prim._minus;
import org.nlogo.prim._reference;
import org.nlogo.prim._unaryminus;
import scala.BufferedIterator;
import scala.Function1;
import scala.Iterable;
import scala.Predef$;
import scala.StringBuilder;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionParser$ {
    public static final ExpressionParser$ MODULE$;
    private final String MISSING_INPUT_ON_LEFT;
    private final String MISSING_CLOSE_PAREN;
    private final String MISSING_CLOSE_BRACKET;
    private final String INVALID_VARIADIC_CONTEXT;
    private final String EXPECTED_REPORTER;
    private final String EXPECTED_REFERENCABLE;
    private final String EXPECTED_CLOSE_PAREN_HERE;
    private final String EXPECTED_CLOSE_BRACKET;
    private final String EXPECTED_COMMAND;
    private final int MIN_PRECEDENCE;

    static {
        new ExpressionParser$();
    }

    private ExpressionParser$() {
        MODULE$ = this;
        this.MIN_PRECEDENCE = -1;
        this.EXPECTED_COMMAND = "Expected command.";
        this.EXPECTED_CLOSE_BRACKET = "Expected closing bracket.";
        this.EXPECTED_CLOSE_PAREN_HERE = "Expected a closing parenthesis here.";
        this.EXPECTED_REFERENCABLE = "Expected a patch variable here.";
        this.EXPECTED_REPORTER = "Expected reporter.";
        this.INVALID_VARIADIC_CONTEXT = "To use a non-default number of inputs, you need to put parentheses around this.";
        this.MISSING_CLOSE_BRACKET = "No closing bracket for this open bracket.";
        this.MISSING_CLOSE_PAREN = "No closing parenthesis for this open parenthesis.";
        this.MISSING_INPUT_ON_LEFT = "Missing input on the left.";
    }

    private final void recurse$1(Token token, BufferedIterator bufferedIterator, ListBuffer listBuffer) {
        this.advance$1(token, bufferedIterator, listBuffer);
        while (true) {
            TokenType tokenType = ((Token)bufferedIterator.head()).tyype();
            TokenType tokenType2 = TokenType.CLOSE_BRACKET;
            if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null)) {
                this.advance$1(token, bufferedIterator, listBuffer);
                return;
            }
            TokenType tokenType3 = ((Token)bufferedIterator.head()).tyype();
            TokenType tokenType4 = TokenType.OPEN_BRACKET;
            if (!(tokenType3 != null ? !((Object)((Object)tokenType3)).equals((Object)tokenType4) : tokenType4 != null)) {
                this.recurse$1(token, bufferedIterator, listBuffer);
                continue;
            }
            this.advance$1(token, bufferedIterator, listBuffer);
        }
    }

    private final void advance$1(Token token, BufferedIterator bufferedIterator, ListBuffer listBuffer) {
        Token token2 = (Token)bufferedIterator.next();
        TokenType tokenType = token2.tyype();
        TokenType tokenType2 = TokenType.EOF;
        if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null)) {
            throw CompilerExceptionThrowers$.MODULE$.exception(this.MISSING_CLOSE_BRACKET(), token);
        }
        listBuffer.$plus$eq(token2);
    }

    private Expression parseDelayedBlock(ExpressionParser.DelayedBlock delayedBlock, int n) {
        block8: {
            Expression expression;
            block6: {
                Token token;
                BufferedIterator<Token> bufferedIterator;
                block7: {
                    bufferedIterator = delayedBlock.tokens().elements().buffered();
                    token = (Token)bufferedIterator.head();
                    if (!Syntax.typesAreCompatible(n, Syntax.TYPE_REPORTER_BLOCK)) break block7;
                    bufferedIterator.next();
                    Expression expression2 = this.resolveType(Syntax.TYPE_WILDCARD, this.parseExpression(bufferedIterator, false), null);
                    Token token2 = bufferedIterator.head();
                    TokenType tokenType = token2.tyype();
                    TokenType tokenType2 = TokenType.EOF;
                    CompilerExceptionThrowers$.MODULE$.cAssert(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null, this.MISSING_CLOSE_BRACKET(), token);
                    TokenType tokenType3 = token2.tyype();
                    TokenType tokenType4 = TokenType.CLOSE_BRACKET;
                    CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType3 != null ? !((Object)((Object)tokenType3)).equals((Object)tokenType4) : tokenType4 != null), this.EXPECTED_CLOSE_BRACKET(), token2);
                    bufferedIterator.next();
                    expression = new ReporterBlock((ReporterApp)expression2, token.startPos(), token2.endPos(), token2.fileName());
                    break block6;
                }
                if (Syntax.typesAreCompatible(n, Syntax.TYPE_COMMAND_BLOCK)) {
                    bufferedIterator.next();
                    Token token3 = bufferedIterator.head();
                    Statements statements = new Statements(token3.fileName());
                    while (true) {
                        TokenType tokenType = token3.tyype();
                        TokenType tokenType5 = TokenType.CLOSE_BRACKET;
                        if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType5) : tokenType5 != null)) {
                            bufferedIterator.next();
                            expression = new CommandBlock(statements, token.startPos(), token3.endPos(), token3.fileName());
                            break block6;
                        }
                        TokenType tokenType6 = token3.tyype();
                        TokenType tokenType7 = TokenType.EOF;
                        CompilerExceptionThrowers$.MODULE$.cAssert(tokenType6 != null ? !((Object)((Object)tokenType6)).equals((Object)tokenType7) : tokenType7 != null, this.MISSING_CLOSE_BRACKET(), token);
                        statements.addStatement(this.parseStatement(bufferedIterator, false));
                        token3 = bufferedIterator.head();
                    }
                }
                if (!Syntax.typesAreCompatible(n, Syntax.TYPE_LIST)) break block8;
                Reporter reporter = ConstantParser$.MODULE$.makeConstantReporter(new ConstantParser(null, null).parseConstantList((Token)bufferedIterator.next(), bufferedIterator));
                Token token4 = (Token)bufferedIterator.next();
                reporter.token(new Token("", TokenType.CONSTANT, null, token.startPos(), token4.endPos(), token4.fileName()));
                expression = new ReporterApp(reporter, token.startPos(), token4.endPos(), token4.fileName());
            }
            return expression;
        }
        throw CompilerExceptionThrowers$.MODULE$.exception(new StringBuilder().append((Object)"Expected ").append((Object)Syntax.aTypeName(n)).append((Object)" here, rather than a list or block.").toString(), delayedBlock);
    }

    private ExpressionParser.DelayedBlock delayBlock(Token openBracket$1, BufferedIterator<Token> tokens$2) {
        ListBuffer<Token> results$1 = new ListBuffer<Token>();
        this.recurse$1(openBracket$1, tokens$2, results$1);
        int end = ((Token)results$1.last()).endPos();
        results$1.$plus$eq(Token$.MODULE$.eof());
        return new ExpressionParser.DelayedBlock(results$1.readOnly(), ((Token)results$1.first()).startPos(), end, openBracket$1.fileName());
    }

    public Expression parseMore(Expression originalExpr, BufferedIterator<Token> tokens, int precedence) {
        Expression expr = originalExpr;
        boolean done = false;
        while (!done) {
            Token token = tokens.head();
            TokenType tokenType = token.tyype();
            TokenType tokenType2 = TokenType.REPORTER;
            if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null)) {
                Reporter reporter = (Reporter)token.value();
                Syntax syntax = reporter.getSyntax();
                if (syntax.isInfix() && (syntax.precedence() > precedence || syntax.isRightAssociative() && syntax.precedence() == precedence)) {
                    tokens.next();
                    Expression expression = expr;
                    CompilerExceptionThrowers$.MODULE$.cAssert(expression != null && !expression.equals(null), this.MISSING_INPUT_ON_LEFT(), token);
                    ReporterApp tmp = new ReporterApp(reporter, expr.start(), token.endPos(), token.fileName());
                    tmp.addArgument(expr);
                    this.parseArguments(tmp, tokens, syntax.precedence());
                    expr = tmp;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return expr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression parseExpressionInternal(BufferedIterator<Token> tokens, boolean variadic, int precedence) {
        Expression expression;
        Token token = tokens.head();
        TokenType tokenType = token.tyype();
        TokenType tokenType2 = TokenType.OPEN_PAREN;
        TokenType tokenType3 = tokenType;
        if (!(tokenType2 != null ? !((Object)((Object)tokenType2)).equals((Object)tokenType3) : tokenType3 != null)) {
            Token openParen = token;
            tokens.next();
            Expression expr = this.parseExpression(tokens, true);
            token = tokens.head();
            TokenType tokenType4 = tokens.head().tyype();
            TokenType tokenType5 = TokenType.EOF;
            CompilerExceptionThrowers$.MODULE$.cAssert(tokenType4 != null ? !((Object)((Object)tokenType4)).equals((Object)tokenType5) : tokenType5 != null, this.MISSING_CLOSE_PAREN(), openParen);
            TokenType tokenType6 = token.tyype();
            TokenType tokenType7 = TokenType.COMMAND;
            CompilerExceptionThrowers$.MODULE$.cAssert(tokenType6 != null ? !((Object)((Object)tokenType6)).equals((Object)tokenType7) : tokenType7 != null, this.MISSING_CLOSE_PAREN(), openParen);
            TokenType tokenType8 = token.tyype();
            TokenType tokenType9 = TokenType.CLOSE_PAREN;
            CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType8 != null ? !((Object)((Object)tokenType8)).equals((Object)tokenType9) : tokenType9 != null), this.EXPECTED_CLOSE_PAREN_HERE(), token);
            tokens.next();
            expr.start_$eq(openParen.startPos());
            expr.end_$eq(token.endPos());
            expression = expr;
        } else {
            TokenType tokenType10 = TokenType.OPEN_BRACKET;
            TokenType tokenType11 = tokenType;
            if (!(tokenType10 != null ? !((Object)((Object)tokenType10)).equals((Object)tokenType11) : tokenType11 != null)) {
                expression = this.delayBlock(token, tokens);
            } else {
                TokenType tokenType12 = TokenType.REPORTER;
                TokenType tokenType13 = tokenType;
                if (!(tokenType12 != null ? !((Object)((Object)tokenType12)).equals((Object)tokenType13) : tokenType13 != null)) {
                    Reporter reporter;
                    Reporter r = (Reporter)token.value();
                    if (r.getSyntax().isInfix()) {
                        if (!(r instanceof _minus) || !variadic) throw new ExpressionParser.MissingPrefixException(token);
                        _unaryminus r2 = new _unaryminus();
                        r2.token(token);
                        reporter = r2;
                    } else {
                        reporter = r;
                    }
                    Reporter reporter2 = reporter;
                    tokens.next();
                    ReporterApp tmp = new ReporterApp(reporter2, reporter2.token().startPos(), reporter2.token().endPos(), reporter2.token().fileName());
                    if (variadic && this.isVariadic(tmp.head())) {
                        this.parseVarArgs(tmp, tokens, reporter2.getSyntax().precedence());
                    } else {
                        this.parseArguments(tmp, tokens, reporter2.getSyntax().precedence());
                    }
                    expression = tmp;
                } else {
                    TokenType tokenType14 = TokenType.CONSTANT;
                    TokenType tokenType15 = tokenType;
                    if (tokenType14 != null ? !((Object)((Object)tokenType14)).equals((Object)tokenType15) : tokenType15 != null) throw new ExpressionParser.UnexpectedTokenException(token);
                    tokens.next();
                    Reporter tmp = ConstantParser$.MODULE$.makeConstantReporter(token.value());
                    tmp.token(token);
                    expression = new ReporterApp(tmp, token.startPos(), token.endPos(), token.fileName());
                }
            }
        }
        ExpressionParser.DelayedBlock expr = expression;
        return this.parseMore(expr, tokens, precedence);
    }

    public final Expression org$nlogo$compiler$ExpressionParser$$parseArgExpression(BufferedIterator tokens, int precedence, Application app) {
        Expression exceptionResult2 = null;
        try {
            exceptionResult2 = this.parseExpressionInternal(tokens, false, precedence);
            return exceptionResult2;
        }
        catch (ExpressionParser.UnexpectedTokenException unexpectedTokenException) {
            throw CompilerExceptionThrowers$.MODULE$.exception(this.missingInput(app, true), app);
        }
        catch (ExpressionParser.MissingPrefixException missingPrefixException) {
            throw CompilerExceptionThrowers$.MODULE$.exception(this.missingInput(app, true), app);
        }
    }

    public Expression parseExpression(BufferedIterator<Token> tokens, boolean variadic) {
        Expression exceptionResult1 = null;
        try {
            exceptionResult1 = this.parseExpressionInternal(tokens, variadic, this.MIN_PRECEDENCE());
            return exceptionResult1;
        }
        catch (ExpressionParser.UnexpectedTokenException unexpectedTokenException) {
            throw CompilerExceptionThrowers$.MODULE$.exception(this.EXPECTED_REPORTER(), unexpectedTokenException.token());
        }
        catch (ExpressionParser.MissingPrefixException missingPrefixException) {
            throw CompilerExceptionThrowers$.MODULE$.exception(this.MISSING_INPUT_ON_LEFT(), missingPrefixException.token());
        }
    }

    private Expression resolveType(int n, Expression expression, String string) {
        Expression expression2 = expression;
        Expression expression3 = expression2 instanceof ExpressionParser.DelayedBlock ? this.parseDelayedBlock((ExpressionParser.DelayedBlock)expression2, n) : expression;
        CompilerExceptionThrowers$.MODULE$.cAssert(Syntax.typesAreCompatible(n, expression3.reportedType()), new StringBuilder().append((Object)string).append((Object)" expected this input to be ").append((Object)Syntax.aTypeName(n)).append((Object)", but got ").append((Object)Syntax.aTypeName(expression3.reportedType())).append((Object)" instead").toString(), expression3);
        if (n == Syntax.TYPE_REFERENCE) {
            ReporterApp reporterApp = (ReporterApp)expression3;
            CompilerExceptionThrowers$.MODULE$.cAssert(reporterApp.reporter() instanceof Referenceable, this.EXPECTED_REFERENCABLE(), expression3);
            reporterApp.reporter_$eq(new _reference(((Referenceable)((Object)reporterApp.reporter())).makeReference()));
        }
        return expression3;
    }

    private void resolveTypes(Application app) {
        Syntax syntax = app.head().getSyntax();
        int actual1 = 0;
        if (syntax.isInfix()) {
            int tyype = syntax.left();
            CompilerExceptionThrowers$.MODULE$.cAssert(app.size() >= 1, this.missingInput(app, false), app);
            app.replaceArg(0, this.resolveType(tyype, (Expression)app.apply(0), app.head().displayName()));
            actual1 = 1;
        }
        int formal1 = 0;
        int[] types = syntax.right();
        while (formal1 < types.length && !Syntax.typesAreCompatible(Syntax.TYPE_REPEATABLE, types[formal1])) {
            if (formal1 == types.length - 1 && app.size() == types.length - 1 && Syntax.typesAreCompatible(Syntax.TYPE_OPTIONAL, types[formal1])) {
                return;
            }
            CompilerExceptionThrowers$.MODULE$.cAssert(app.size() > actual1, this.missingInput(app, true), app);
            app.replaceArg(actual1, this.resolveType(types[formal1], (Expression)app.apply(actual1), app.head().displayName()));
            ++formal1;
            ++actual1;
        }
        if (formal1 < types.length) {
            int actual2 = app.size() - 1;
            int formal2 = types.length - 1;
            while (formal2 >= 0 && !Syntax.typesAreCompatible(Syntax.TYPE_REPEATABLE, types[formal2])) {
                CompilerExceptionThrowers$.MODULE$.cAssert(app.size() > actual2 && actual2 > -1, this.missingInput(app, true), app);
                app.replaceArg(actual2, this.resolveType(types[formal2], (Expression)app.apply(actual2), app.head().displayName()));
                --formal2;
                --actual2;
            }
            while (actual1 <= actual2) {
                app.replaceArg(actual1, this.resolveType(types[formal1], (Expression)app.apply(actual1), app.head().displayName()));
                ++actual1;
            }
        }
    }

    private String missingInput(Application application, boolean bl) {
        String string;
        Syntax syntax = application.head().getSyntax();
        Object object = ScalaRunTime$.MODULE$.arrayValue(ScalaRunTime$.MODULE$.boxArray(syntax.right()).map((Function1)new anonfun.1()), String.class);
        String[] stringArray = (String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object);
        int n = syntax.left();
        String string2 = bl && this.isVariadic(application.head()) && syntax.min() == 0 ? new StringBuilder().append((Object)application.head().displayName()).append((Object)" expected ").append(BoxesRunTime.boxToInteger(syntax.rightDefault())).append((Object)" input").append((Object)(syntax.rightDefault() > 1 ? "s" : "")).append((Object)" on the right or any number of inputs when surrounded by parentheses").toString() : (string = new StringBuilder().append((Object)application.head().displayName()).append((Object)" expected ").append((Object)(this.isVariadic(application.head()) ? "at least " : "")).append((Object)(bl ? new StringBuilder().append(syntax.rightDefault()).append((Object)" input").append((Object)(syntax.rightDefault() > 1 ? "s" : "")).append((Object)(syntax.isInfix() ? " on the right" : "")).toString() : new StringBuilder().append((Object)Syntax.aTypeName(n)).append((Object)" on the left.").toString())).toString());
        return bl ? (ScalaRunTime$.MODULE$.boxArray(stringArray).forall(new anonfun.missingInput.1()) ? new StringBuilder().append((Object)string).append((Object)".").toString() : (ScalaRunTime$.MODULE$.boxArray(stringArray).size() == 1 ? new StringBuilder().append((Object)string).append((Object)", ").append((Object)ScalaRunTime$.MODULE$.boxArray(stringArray).mkString()).append((Object)".").toString() : new StringBuilder().append((Object)string).append((Object)", ").append((Object)ScalaRunTime$.MODULE$.boxArray(stringArray).toList().dropRight(1).mkString(", ")).append((Object)" and ").append(ScalaRunTime$.MODULE$.boxArray(stringArray).last()).append((Object)".").toString())) : string;
    }

    private boolean isVariadic(Instruction ins) {
        return ScalaRunTime$.MODULE$.boxArray(ins.getSyntax().right()).exists(new anonfun.isVariadic.1());
    }

    private void parseVarArgs(Application app, BufferedIterator<Token> tokens, int precedence) {
        boolean done = false;
        Token token = tokens.head();
        while (true) {
            if (done) {
                this.resolveTypes(app);
                return;
            }
            TokenType tokenType = token.tyype();
            TokenType tokenType2 = TokenType.CLOSE_PAREN;
            if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null)) {
                done = true;
                continue;
            }
            TokenType tokenType3 = token.tyype();
            TokenType tokenType4 = TokenType.REPORTER;
            if (!(tokenType3 != null ? !((Object)((Object)tokenType3)).equals((Object)tokenType4) : tokenType4 != null) && ((Reporter)token.value()).getSyntax().isInfix()) {
                CompilerExceptionThrowers$.MODULE$.cAssert(app.size() == app.head().getSyntax().totalDefault(), this.INVALID_VARIADIC_CONTEXT(), app);
                done = true;
                continue;
            }
            Expression arg = this.org$nlogo$compiler$ExpressionParser$$parseArgExpression(tokens, precedence, app);
            app.addArgument(arg);
            app.end_$eq(arg.end());
            token = tokens.head();
        }
    }

    private void parseArguments(Application app$1, BufferedIterator<Token> tokens$1, int precedence$1) {
        int numArgs = app$1.head().getSyntax().rightDefault();
        boolean optional = app$1.head().getSyntax().right().length >= numArgs && numArgs > 0 && Syntax.typesAreCompatible(Syntax.TYPE_OPTIONAL, app$1.head().getSyntax().right()[numArgs - 1]);
        Predef$.MODULE$.intWrapper(0).until(optional ? numArgs - 1 : numArgs).foreach(new anonfun.parseArguments.1(app$1, tokens$1, precedence$1));
        if (optional) {
            TokenType tokenType = tokens$1.head().tyype();
            TokenType tokenType2 = TokenType.OPEN_BRACKET;
            if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null)) {
                Expression arg = this.org$nlogo$compiler$ExpressionParser$$parseArgExpression(tokens$1, precedence$1, app$1);
                app$1.addArgument(arg);
                app$1.end_$eq(arg.end());
            } else {
                String file = tokens$1.head().fileName();
                app$1.addArgument(new CommandBlock(new Statements(file), app$1.end(), app$1.end(), file));
            }
        }
        this.resolveTypes(app$1);
    }

    private Statement parseStatement(BufferedIterator<Token> tokens, boolean variadic) {
        Token token;
        block7: {
            Statement statement;
            block6: {
                TokenType tokenType;
                block5: {
                    token = (Token)tokens.next();
                    tokenType = token.tyype();
                    TokenType tokenType2 = TokenType.OPEN_PAREN;
                    TokenType tokenType3 = tokenType;
                    if (tokenType2 != null ? !((Object)((Object)tokenType2)).equals((Object)tokenType3) : tokenType3 != null) break block5;
                    Token openParen = token;
                    Statement stmt = this.parseStatement(tokens, true);
                    TokenType tokenType4 = tokens.head().tyype();
                    TokenType tokenType5 = TokenType.EOF;
                    CompilerExceptionThrowers$.MODULE$.cAssert(tokenType4 != null ? !((Object)((Object)tokenType4)).equals((Object)tokenType5) : tokenType5 != null, this.MISSING_CLOSE_PAREN(), openParen);
                    Token closeParen = (Token)tokens.next();
                    TokenType tokenType6 = closeParen.tyype();
                    TokenType tokenType7 = TokenType.CLOSE_PAREN;
                    CompilerExceptionThrowers$.MODULE$.cAssert(!(tokenType6 != null ? !((Object)((Object)tokenType6)).equals((Object)tokenType7) : tokenType7 != null), this.EXPECTED_CLOSE_PAREN_HERE(), closeParen);
                    stmt.start_$eq(openParen.startPos());
                    stmt.end_$eq(token.endPos());
                    statement = stmt;
                    break block6;
                }
                TokenType tokenType8 = TokenType.COMMAND;
                TokenType tokenType9 = tokenType;
                if (tokenType8 != null ? !((Object)((Object)tokenType8)).equals((Object)tokenType9) : tokenType9 != null) break block7;
                Statement stmt = new Statement((Command)token.value(), token.startPos(), token.endPos(), token.fileName());
                if (variadic && this.isVariadic(stmt.head())) {
                    this.parseVarArgs(stmt, tokens, this.MIN_PRECEDENCE());
                } else {
                    this.parseArguments(stmt, tokens, this.MIN_PRECEDENCE());
                }
                statement = stmt;
            }
            return statement;
        }
        throw CompilerExceptionThrowers$.MODULE$.exception(this.EXPECTED_COMMAND(), token);
    }

    public Statements parse(Iterable<Token> tokensIterable) {
        BufferedIterator<Token> tokens = tokensIterable.elements().buffered();
        Statements stmts = new Statements(tokens.head().fileName());
        while (true) {
            TokenType tokenType = tokens.head().tyype();
            TokenType tokenType2 = TokenType.EOF;
            if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null)) {
                return stmts;
            }
            stmts.addStatement(this.parseStatement(tokens, false));
        }
    }

    private String MISSING_INPUT_ON_LEFT() {
        return this.MISSING_INPUT_ON_LEFT;
    }

    private String MISSING_CLOSE_PAREN() {
        return this.MISSING_CLOSE_PAREN;
    }

    private String MISSING_CLOSE_BRACKET() {
        return this.MISSING_CLOSE_BRACKET;
    }

    private String INVALID_VARIADIC_CONTEXT() {
        return this.INVALID_VARIADIC_CONTEXT;
    }

    private String EXPECTED_REPORTER() {
        return this.EXPECTED_REPORTER;
    }

    private String EXPECTED_REFERENCABLE() {
        return this.EXPECTED_REFERENCABLE;
    }

    private String EXPECTED_CLOSE_PAREN_HERE() {
        return this.EXPECTED_CLOSE_PAREN_HERE;
    }

    private String EXPECTED_CLOSE_BRACKET() {
        return this.EXPECTED_CLOSE_BRACKET;
    }

    private String EXPECTED_COMMAND() {
        return this.EXPECTED_COMMAND;
    }

    private int MIN_PRECEDENCE() {
        return this.MIN_PRECEDENCE;
    }
}

