/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.Map;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Let;
import org.nlogo.api.Program;
import org.nlogo.api.Token;
import org.nlogo.api.TokenType;
import org.nlogo.compiler.BreedIdentifierHandler$;
import org.nlogo.compiler.CompilerExceptionThrowers$;
import org.nlogo.compiler.IdentifierParser$;
import org.nlogo.compiler.IdentifierParser$$anonfun$org$nlogo$compiler$IdentifierParser$;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Reporter;
import org.nlogo.prim._breedvariable;
import org.nlogo.prim._call;
import org.nlogo.prim._callreport;
import org.nlogo.prim._letvariable;
import org.nlogo.prim._linkbreedvariable;
import org.nlogo.prim._linkvariable;
import org.nlogo.prim._observervariable;
import org.nlogo.prim._patchvariable;
import org.nlogo.prim._plus;
import org.nlogo.prim._procedurevariable;
import org.nlogo.prim._templatevariable;
import org.nlogo.prim._turtleorlinkvariable;
import org.nlogo.prim._turtlevariable;
import org.nlogo.prim._unknownidentifier;
import org.nlogo.prim.dead._pluswildcard;
import org.nlogo.util.JCL$;
import scala.CountedIterator;
import scala.Iterable;
import scala.Iterator;
import scala.None$;
import scala.Option;
import scala.StringBuilder;
import scala.runtime.NonLocalReturnException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierParser {
    private final String RANDOM_OR_RANDOM_FLOAT_ERROR;
    private final String INVALID_TEMPLATE_VARIABLE;
    private final boolean forgiving;
    public final Map org$nlogo$compiler$IdentifierParser$$newProcedures;
    public final Map org$nlogo$compiler$IdentifierParser$$oldProcedures;
    private final Program program;

    public IdentifierParser(Program program, Map<String, Procedure> oldProcedures, Map<String, Procedure> newProcedures, boolean forgiving) {
        this.program = program;
        this.org$nlogo$compiler$IdentifierParser$$oldProcedures = oldProcedures;
        this.org$nlogo$compiler$IdentifierParser$$newProcedures = newProcedures;
        this.forgiving = forgiving;
        this.INVALID_TEMPLATE_VARIABLE = "variables may not begin with a question mark unless they are the special variables ?, ?1, ?2, ...";
        this.RANDOM_OR_RANDOM_FLOAT_ERROR = "This code was written for an old version of NetLogo in which the RANDOM primitive sometimes reported an integer (e.g. 4), other times a floating point number (e.g. 4.326), depending on its input. That's no longer true in this version; instead, we now have two separate primitives. So you must replace this with either RANDOM or RANDOM-FLOAT depending on whether you want an integer or a floating point result.";
    }

    public final Option checkLet$1(Let let$1, String string, int n) {
        return n < let$1.startPos || n > let$1.endPos ? None$.MODULE$ : (Option)JCL$.MODULE$.iterableFromJava(let$1.children).map(new $anonfun$checkLet$1$1(this, string, n)).find(new $anonfun$checkLet$1$2(this)).getOrElse(new $anonfun$checkLet$1$3(this, string, let$1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final Token processToken$1(Token token, Procedure procedure, Object object) {
        Token token2;
        block5: {
            block4: {
                if (this.forgiving && token.value() instanceof _plus) {
                    token2 = this.org$nlogo$compiler$IdentifierParser$$newToken(new _pluswildcard(), token.name(), TokenType.REPORTER, token.startPos(), token.endPos(), token.fileName());
                    return token2;
                }
                TokenType tokenType = token.tyype();
                TokenType tokenType2 = TokenType.IDENT;
                if (!(tokenType == null ? tokenType2 != null : !((Object)((Object)tokenType)).equals((Object)tokenType2))) break block4;
                TokenType tokenType3 = token.tyype();
                TokenType tokenType4 = TokenType.VARIABLE;
                if (tokenType3 != null ? !((Object)((Object)tokenType3)).equals((Object)tokenType4) : tokenType4 != null) break block5;
            }
            token2 = this.processToken2(token, procedure, ((CountedIterator)object).count());
            return token2;
        }
        token2 = token;
        return token2;
    }

    private String RANDOM_OR_RANDOM_FLOAT_ERROR() {
        return this.RANDOM_OR_RANDOM_FLOAT_ERROR;
    }

    private String INVALID_TEMPLATE_VARIABLE() {
        return this.INVALID_TEMPLATE_VARIABLE;
    }

    public final Token org$nlogo$compiler$IdentifierParser$$newToken(Instruction instr, String name, TokenType tyype, int startPos, int endPos, String fileName) {
        Token tok = new Token(name, tyype, instr, startPos, endPos, fileName);
        instr.token(tok);
        return tok;
    }

    private void checkProcedureName(Procedure procedure) {
        Object newVal;
        Object exceptionResult3 = null;
        try {
            newVal = exceptionResult3 = this.processToken2(procedure.nameToken, procedure, 0).value();
        }
        catch (CompilerException compilerException) {
            return;
        }
        CompilerExceptionThrowers$.MODULE$.cAssert(newVal instanceof _call || newVal instanceof _callreport || newVal instanceof _unknownidentifier, new StringBuilder().append((Object)"Cannot use ").append((Object)procedure.name).append((Object)" as a procedure name.  Conflicts with: ").append(newVal).toString(), procedure.nameToken);
    }

    public final Reporter org$nlogo$compiler$IdentifierParser$$getAgentVariableReporter(String string, Token token) {
        block10: {
            Reporter reporter;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!this.program.turtlesOwn.contains(string) || !this.program.linksOwn.contains(string)) break block2;
                                            reporter = new _turtleorlinkvariable(string);
                                            break block3;
                                        }
                                        if (!this.program.turtlesOwn.contains(string)) break block4;
                                        reporter = new _turtlevariable(this.program.turtlesOwn.indexOf(string));
                                        break block3;
                                    }
                                    if (!this.program.patchesOwn.contains(string)) break block5;
                                    reporter = new _patchvariable(this.program.patchesOwn.indexOf(string));
                                    break block3;
                                }
                                if (!this.program.linksOwn.contains(string)) break block6;
                                reporter = new _linkvariable(this.program.linksOwn.indexOf(string));
                                break block3;
                            }
                            if (!this.program.globals.contains(string)) break block7;
                            reporter = new _observervariable(this.program.globals.indexOf(string));
                            break block3;
                        }
                        if (!JCL$.MODULE$.iterableFromJava(this.program.breedsOwn.values()).exists(new $anonfun$org$nlogo$compiler$IdentifierParser$$getAgentVariableReporter$1(this, string))) break block8;
                        reporter = new _breedvariable(string);
                        break block3;
                    }
                    if (!JCL$.MODULE$.iterableFromJava(this.program.linkBreedsOwn.values()).exists(new $anonfun$org$nlogo$compiler$IdentifierParser$$getAgentVariableReporter$2(this, string))) break block9;
                    reporter = new _linkbreedvariable(string);
                    break block3;
                }
                if (!this.forgiving) break block10;
                reporter = new _unknownidentifier();
            }
            return reporter;
        }
        throw CompilerExceptionThrowers$.MODULE$.exception(new StringBuilder().append((Object)"Nothing named ").append((Object)string).append((Object)" has been defined").toString(), new Token(string, token.tyype(), token.value(), token.startPos(), token.startPos() + string.length(), token.fileName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token processToken2(Token token, Procedure procedure, int n) {
        Object object = new Object();
        Token token2 = null;
        try {
            Token token3;
            String string = (String)token.value();
            if (string.startsWith("?")) {
                int n2;
                if (string.length() == 1) {
                    n2 = 1;
                } else {
                    int n3 = 0;
                    try {
                        n2 = n3 = Integer.parseInt(string.substring(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw CompilerExceptionThrowers$.MODULE$.exception(this.INVALID_TEMPLATE_VARIABLE(), token);
                    }
                }
                int n4 = n2;
                token3 = this.org$nlogo$compiler$IdentifierParser$$newToken(new _templatevariable(n4), string, TokenType.REPORTER, token.startPos(), token.endPos(), token.fileName());
                return token3;
            }
            String string2 = string;
            String string3 = "RANDOM-OR-RANDOM-FLOAT";
            if (string2 == null) {
                if (string3 == null) throw CompilerExceptionThrowers$.MODULE$.exception(this.RANDOM_OR_RANDOM_FLOAT_ERROR(), token);
            } else if (string2.equals(string3)) {
                throw CompilerExceptionThrowers$.MODULE$.exception(this.RANDOM_OR_RANDOM_FLOAT_ERROR(), token);
            }
            token3 = this.getLetFromArg(procedure, string, n).isDefined() ? this.org$nlogo$compiler$IdentifierParser$$newToken(new _letvariable(this.getLetFromArg(procedure, string, n).get(), string), string, TokenType.REPORTER, token.startPos(), token.endPos(), token.fileName()) : (procedure.args.contains(string) ? this.org$nlogo$compiler$IdentifierParser$$newToken(new _procedurevariable(procedure.args.indexOf(string), string), string, TokenType.REPORTER, token.startPos(), token.endPos(), token.fileName()) : (Token)BreedIdentifierHandler$.MODULE$.process(token, this.program).getOrElse(new $anonfun$processToken2$1(this, token, string, object)));
            return token3;
        }
        catch (NonLocalReturnException nonLocalReturnException22) {
            if (nonLocalReturnException22.key() != object) throw nonLocalReturnException22;
            return (Token)nonLocalReturnException22.value();
        }
    }

    private Option<Let> getLetFromArg(Procedure p, String ident$1, int tokPos$1) {
        return (Option)JCL$.MODULE$.iterableFromJava(p.lets).map(new $anonfun$getLetFromArg$1(this, ident$1, tokPos$1)).find(new $anonfun$getLetFromArg$2(this)).getOrElse(new $anonfun$getLetFromArg$3(this));
    }

    public Iterable<Token> process(Iterator<Token> tokens, Procedure procedure$1) {
        this.checkProcedureName(procedure$1);
        Object it$1 = tokens.counted();
        return ((Iterator)it$1).map(new $anonfun$process$1(this, procedure$1, it$1)).collect();
    }
}

