/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.EditorArea;

public strictfp class Actions {
    public static final Action commentAction = new CommentAction();
    public static final Action uncommentAction = new UncommentAction();
    public static final Action shiftLeftAction = new ShiftLeftAction();
    public static final Action shiftRightAction = new ShiftRightAction();
    static final Action tabKeyAction = new TabKeyAction();
    static final Action shiftTabKeyAction = new ShiftTabKeyAction();
    public static final Action CUT_ACTION = new DefaultEditorKit.CutAction();
    public static final Action COPY_ACTION = new DefaultEditorKit.CopyAction();
    public static final Action PASTE_ACTION = new DefaultEditorKit.PasteAction();
    public static final Action DELETE_ACTION = new DefaultEditorKit.InsertContentAction();
    private static Map<String, Action> actionMap;
    public static final Action SELECT_ALL_ACTION;

    private Actions() {
        throw new IllegalStateException();
    }

    static void setEnabled(boolean enabled) {
        commentAction.setEnabled(enabled);
        uncommentAction.setEnabled(enabled);
        shiftLeftAction.setEnabled(enabled);
        shiftRightAction.setEnabled(enabled);
    }

    public static Action getDefaultEditorKitAction(String name) {
        return actionMap.get(name);
    }

    static {
        DELETE_ACTION.putValue("ActionCommandKey", "");
        actionMap = new HashMap<String, Action>();
        Action[] actions = new DefaultEditorKit().getActions();
        for (int i = 0; i < actions.length; ++i) {
            actionMap.put((String)actions[i].getValue("Name"), actions[i]);
        }
        SELECT_ALL_ACTION = Actions.getDefaultEditorKitAction("select-all");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static class MouseQuickHelpAction
    extends TextAction {
        private final Colorizer<?> colorizer;

        public MouseQuickHelpAction(Colorizer<?> colorizer) {
            super("Quick Help");
            this.colorizer = colorizer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent comp = this.getTextComponent(e);
            if (comp instanceof EditorArea) {
                EditorArea ea = (EditorArea)comp;
                this.colorizer.doHelp(comp, ea.getHelpTarget(ea.getMousePos()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static class QuickHelpAction
    extends TextAction {
        private final Colorizer<?> colorizer;

        public QuickHelpAction(Colorizer<?> colorizer) {
            super("Quick Help");
            this.colorizer = colorizer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent comp = this.getTextComponent(e);
            if (comp instanceof EditorArea) {
                EditorArea ea = (EditorArea)comp;
                this.colorizer.doHelp(comp, ea.getHelpTarget(ea.getSelectionStart()));
            }
        }
    }

    strictfp static class ShiftRightAction
    extends TextAction {
        ShiftRightAction() {
            super("shift-line-right");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).insertBeforeEachSelectedLine(" ");
            }
        }
    }

    strictfp static class ShiftLeftAction
    extends TextAction {
        ShiftLeftAction() {
            super("shift-line-left");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).shiftLeft();
            }
        }
    }

    strictfp static class UncommentAction
    extends TextAction {
        UncommentAction() {
            super("uncomment-line");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).uncomment();
            }
        }
    }

    strictfp static class CommentAction
    extends TextAction {
        CommentAction() {
            super("comment-line");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).insertBeforeEachSelectedLine(";");
            }
        }
    }

    strictfp static class ShiftTabKeyAction
    extends TextAction {
        ShiftTabKeyAction() {
            super("shift-tab-key");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).shiftLeft();
                ((EditorArea)component).shiftLeft();
            }
        }
    }

    strictfp static class TabKeyAction
    extends TextAction {
        TabKeyAction() {
            super("tab-key");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getTextComponent(e);
            if (component instanceof EditorArea) {
                ((EditorArea)component).indentSelection();
            }
        }
    }
}

