/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.editor.Actions;
import org.nlogo.editor.BracketMatcher;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.DoubleClickCaret;
import org.nlogo.editor.DumbIndenter;
import org.nlogo.editor.HighlightEditorKit;
import org.nlogo.editor.IndenterInterface;
import org.nlogo.editor.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class EditorArea<TokenType>
extends AbstractEditorArea
implements FocusListener {
    private final int rows;
    private final int columns;
    protected final boolean disableFocusTraversalKeys;
    private final BracketMatcher<TokenType> bracketMatcher;
    private final UndoManager undoManager = new UndoManager();
    protected final Colorizer<TokenType> colorizer;
    protected IndenterInterface indenter;
    private final DoubleClickCaret<TokenType> caret;
    private boolean enabled = true;
    private boolean mouseEvent = false;
    private boolean setSelection = true;
    private int mousePos;

    public EditorArea(int rows, int columns, Font font, boolean disableFocusTraversalKeys, TextListener listener, Colorizer<TokenType> colorizer) {
        this.rows = rows;
        this.columns = columns;
        this.disableFocusTraversalKeys = disableFocusTraversalKeys;
        this.colorizer = colorizer;
        this.indenter = new DumbIndenter(this);
        this.enableEvents(16L);
        this.addFocusListener(this);
        this.bracketMatcher = new BracketMatcher<TokenType>(colorizer);
        this.addCaretListener(this.bracketMatcher);
        int blinkRate = this.getCaret().getBlinkRate();
        this.caret = new DoubleClickCaret<TokenType>(colorizer, this.bracketMatcher);
        this.caret.setBlinkRate(blinkRate);
        this.setCaret(this.caret);
        this.setDragEnabled(false);
        this.setFocusTraversalKeysEnabled(!disableFocusTraversalKeys);
        if (!disableFocusTraversalKeys) {
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), new TransferFocusAction());
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), new TransferFocusBackwardAction());
        } else {
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), Actions.tabKeyAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), Actions.shiftTabKeyAction);
        }
        this.setFont(font);
        this.setEditorKit(new HighlightEditorKit<TokenType>(listener, colorizer));
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), new EnterAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(Character.valueOf(']'), 0), new CloseBracketAction());
        this.getDocument().putProperty("tabSize", 2);
        this.getDocument().putProperty("__EndOfLine__", "\n");
        this.getDocument().addUndoableEditListener(this.undoManager);
        int mask = this.getToolkit().getMenuShortcutKeyMask();
        this.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(90, mask), UndoManager.undoAction());
        this.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(89, mask), UndoManager.redoAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(112, 0), new Actions.QuickHelpAction(colorizer));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
    }

    @Override
    public void enableBracketMatcher(boolean enabled) {
        if (this.enabled != enabled) {
            if (enabled) {
                this.addCaretListener(this.bracketMatcher);
            } else {
                this.removeCaretListener(this.bracketMatcher);
            }
            this.enabled = enabled;
        }
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), new Action[]{Actions.commentAction, Actions.uncommentAction, Actions.shiftLeftAction, Actions.shiftRightAction, new Actions.QuickHelpAction(this.colorizer)});
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        dimension = dimension != null ? dimension : new Dimension(400, 400);
        dimension.width = this.columns != 0 ? this.columns * this.getColumnWidth() : dimension.width;
        dimension.height = this.rows != 0 ? this.rows * this.getRowHeight() : dimension.height;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = dimension = dimension == null ? new Dimension(400, 400) : dimension;
        if (this.columns != 0) {
            dimension.width = StrictMath.max(dimension.width, this.columns * this.getColumnWidth());
        }
        if (this.rows != 0) {
            dimension.height = StrictMath.max(dimension.height, this.rows * this.getRowHeight());
        }
        return dimension;
    }

    private int getColumnWidth() {
        return this.getFontMetrics(this.getFont()).charWidth('m');
    }

    private int getRowHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    @Override
    public void setText(String text) {
        if (!text.equals(this.getText())) {
            super.setText(text);
            this.undoManager.discardAllEdits();
        }
    }

    String getLineText(int offset) throws BadLocationException {
        PlainDocument doc = (PlainDocument)this.getDocument();
        int currentLine = this.offsetToLine(doc, offset);
        int lineStart = this.lineToStartOffset(doc, currentLine);
        int lineEnd = this.lineToEndOffset(doc, currentLine);
        return doc.getText(lineStart, lineEnd - lineStart);
    }

    void indentSelection() {
        this.indenter.handleTab();
    }

    int lineToStartOffset(PlainDocument doc, int line) {
        return doc.getDefaultRootElement().getElement(line).getStartOffset();
    }

    int lineToEndOffset(PlainDocument doc, int line) {
        return doc.getDefaultRootElement().getElement(line).getEndOffset();
    }

    int offsetToLine(PlainDocument doc, int offset) {
        return doc.getDefaultRootElement().getElementIndex(offset);
    }

    void insertBeforeEachSelectedLine(String insertion) {
        PlainDocument doc = (PlainDocument)this.getDocument();
        try {
            int currentLine = this.offsetToLine(doc, this.getSelectionStart());
            int endLine = this.offsetToLine(doc, this.getSelectionEnd());
            if (endLine > currentLine && this.getSelectionEnd() == this.lineToStartOffset(doc, endLine)) {
                --endLine;
            }
            if (endLine > currentLine && this.getSelectionStart() == this.lineToEndOffset(doc, currentLine) - 1) {
                ++currentLine;
            }
            while (currentLine <= endLine) {
                doc.insertString(this.lineToStartOffset(doc, currentLine), insertion, null);
                ++currentLine;
            }
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void uncomment() {
        PlainDocument doc = (PlainDocument)this.getDocument();
        try {
            int currentLine = this.offsetToLine(doc, this.getSelectionStart());
            int endLine = this.offsetToLine(doc, this.getSelectionEnd());
            if (endLine > currentLine && this.getSelectionEnd() == this.lineToStartOffset(doc, endLine)) {
                --endLine;
            }
            if (endLine > currentLine && this.getSelectionStart() == this.lineToEndOffset(doc, currentLine) - 1) {
                ++currentLine;
            }
            while (currentLine <= endLine) {
                int lineEnd;
                int lineStart = this.lineToStartOffset(doc, currentLine);
                String text = doc.getText(lineStart, (lineEnd = this.lineToEndOffset(doc, currentLine)) - lineStart);
                int semicolonPos = text.indexOf(59);
                if (semicolonPos != -1) {
                    boolean allSpaces = true;
                    for (int i = 0; i < semicolonPos; ++i) {
                        if (Character.isWhitespace(text.charAt(i))) continue;
                        allSpaces = false;
                        break;
                    }
                    if (allSpaces) {
                        doc.remove(lineStart + semicolonPos, 1);
                    }
                }
                ++currentLine;
            }
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void shiftLeft() {
        PlainDocument doc = (PlainDocument)this.getDocument();
        try {
            int currentLine = this.offsetToLine(doc, this.getSelectionStart());
            int endLine = this.offsetToLine(doc, this.getSelectionEnd());
            if (endLine > currentLine && this.getSelectionEnd() == this.lineToStartOffset(doc, endLine)) {
                --endLine;
            }
            if (endLine > currentLine && this.getSelectionStart() == this.lineToEndOffset(doc, currentLine) - 1) {
                ++currentLine;
            }
            while (currentLine <= endLine) {
                int lineEnd;
                int lineStart = this.lineToStartOffset(doc, currentLine);
                String text = doc.getText(lineStart, (lineEnd = this.lineToEndOffset(doc, currentLine)) - lineStart);
                if (text.length() > 0 && text.charAt(0) == ' ') {
                    doc.remove(lineStart, 1);
                }
                ++currentLine;
            }
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
        if (!this.mouseEvent && !this.disableFocusTraversalKeys && this.setSelection) {
            this.setCaretPosition(this.getText().length());
            this.moveCaretPosition(0);
        }
        Actions.setEnabled(true);
        UndoManager.setCurrentManager(this.undoManager);
    }

    @Override
    public void focusLost(FocusEvent fe) {
        if (!this.disableFocusTraversalKeys) {
            this.select(0, 0);
        }
        this.mouseEvent = fe.isTemporary();
        this.bracketMatcher.focusLost(this);
        this.colorizer.reset();
        if (!fe.isTemporary()) {
            Actions.setEnabled(false);
            UndoManager.setCurrentManager(null);
        }
    }

    public int getMousePos() {
        return this.mousePos;
    }

    @Override
    public void processMouseEvent(MouseEvent me) {
        if (me.getID() == 501) {
            this.mouseEvent = true;
        }
        if (me.isPopupTrigger()) {
            this.mousePos = this.caret.getMousePosition(me);
            this.doPopup(me);
            return;
        }
        super.processMouseEvent(me);
    }

    private void doPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(Actions.COPY_ACTION));
        Actions.COPY_ACTION.putValue("Name", "Copy");
        menu.add(new JMenuItem(Actions.CUT_ACTION));
        Actions.CUT_ACTION.putValue("Name", "Cut");
        menu.add(new JMenuItem(Actions.PASTE_ACTION));
        Actions.PASTE_ACTION.putValue("Name", "Paste");
        menu.addSeparator();
        menu.add(new JMenuItem(new Actions.MouseQuickHelpAction(this.colorizer)));
        menu.show(this, e.getX(), e.getY());
    }

    @Override
    public void replaceSelection(String s) {
        if (s == null) {
            super.replaceSelection(s);
            return;
        }
        if (s.length() > 0 && Character.getType(s.charAt(0)) == 16) {
            s = s.substring(1);
        }
        if (s.indexOf(9) >= 0) {
            s = s.replaceAll("\t", "  ");
        }
        super.replaceSelection(s);
        this.indenter.handleInsertion(s);
    }

    @Override
    public String getText(int start, int end) {
        try {
            return this.getDocument().getText(start, end);
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    String getHelpTarget(int startPosition) {
        PlainDocument doc = (PlainDocument)this.getDocument();
        try {
            int currentLine = this.offsetToLine(doc, startPosition);
            int startLineOffset = this.lineToStartOffset(doc, currentLine);
            int lineLength = this.lineToEndOffset(doc, currentLine) - startLineOffset;
            String lineText = doc.getText(startLineOffset, lineLength);
            int selStartInString = startPosition - startLineOffset;
            return this.colorizer.getTokenAtPosition(lineText, selStartInString);
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected strictfp class TransferFocusBackwardAction
    extends AbstractAction {
        protected TransferFocusBackwardAction() {
        }

        public void actionPerformed(ActionEvent e) {
            EditorArea.this.transferFocusBackward();
        }
    }

    protected strictfp class TransferFocusAction
    extends AbstractAction {
        protected TransferFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            EditorArea.this.transferFocus();
        }
    }

    strictfp class CloseBracketAction
    extends TextAction {
        CloseBracketAction() {
            super("close-bracket");
        }

        public void actionPerformed(ActionEvent e) {
            EditorArea.this.replaceSelection("]");
            EditorArea.this.indenter.handleCloseBracket();
        }
    }

    strictfp class EnterAction
    extends TextAction {
        EnterAction() {
            super("enter");
        }

        public void actionPerformed(ActionEvent e) {
            EditorArea.this.indenter.handleEnter();
        }
    }
}

