/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.job;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.job.JobThread;
import org.nlogo.nvm.ConcurrentJob;
import org.nlogo.nvm.ExclusiveJob;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerInterface;
import org.nlogo.nvm.JobManagerOwner;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class JobManager
implements JobManagerInterface {
    private final JobThread thread;
    private final World world;

    public JobManager(JobManagerOwner jobManagerOwner, World world, Object lock) {
        this.world = world;
        this.thread = new JobThread(this, jobManagerOwner, lock);
    }

    @Override
    public boolean isInterrupted() {
        return this.thread.isInterrupted();
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public void timeToRunSecondaryJobs() {
        this.thread.isTimeToRunSecondaryJobs = true;
    }

    @Override
    public void maybeRunSecondaryJobs() {
        this.thread.maybeRunSecondaryJobs();
    }

    @Override
    public boolean anyPrimaryJobs() {
        return !this.thread.primaryJobs.isEmpty();
    }

    @Override
    public void addJob(Job job, boolean waitForCompletion) {
        if (waitForCompletion) {
            this.add(job, this.thread.primaryJobs);
            this.waitFor(job, false);
        } else {
            this.add(job, this.thread.primaryJobs);
        }
    }

    @Override
    public Job makeConcurrentJob(JobOwner owner, AgentSet agentset, Procedure procedure) {
        return new ConcurrentJob(owner, agentset, procedure, 0, null);
    }

    @Override
    public Object callReporterProcedure(JobOwner owner, AgentSet agentset, Procedure procedure) throws LogoException {
        return new ExclusiveJob(owner, agentset, procedure, 0, null).callReporterProcedure();
    }

    @Override
    public Object addReporterJobAndWait(AgentSet agentset, Procedure procedure) {
        ConcurrentJob job = new ConcurrentJob(null, agentset, procedure, 0, null);
        this.add(job, this.thread.primaryJobs);
        this.waitFor(job, false);
        return job.result;
    }

    @Override
    public void addJobFromJobThread(Job job) {
        this.thread.primaryJobs.add(job);
    }

    @Override
    public void addJob(JobOwner owner, AgentSet agents, Procedure procedure) {
        this.add(new ConcurrentJob(owner, agents, procedure, 0, null), this.thread.primaryJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSecondaryJob(JobOwner owner, AgentSet agents, Procedure procedure) {
        List<Job> list = this.thread.secondaryJobs;
        synchronized (list) {
            for (Job secondaryJob : this.thread.secondaryJobs) {
                if (secondaryJob == null || secondaryJob.owner != owner || secondaryJob.state != 0) continue;
                return;
            }
        }
        this.add(new ConcurrentJob(owner, agents, procedure, 0, null), this.thread.secondaryJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Job job, List<Job> jobs) {
        jobs.add(job);
        if (job.isTurtleForeverButtonJob()) {
            this.thread.turtleForeverButtonJobs.add((ConcurrentJob)job);
        }
        if (job.isLinkForeverButtonJob()) {
            this.thread.linkForeverButtonJobs.add((ConcurrentJob)job);
        }
        if (job.topLevelProcedure != null) {
            Object object = this.thread.newJobsCondition;
            synchronized (object) {
                this.thread.newJobsCondition.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void joinForeverButtons(Agent agent) {
        if (agent instanceof Turtle) {
            List<ConcurrentJob> list = this.thread.turtleForeverButtonJobs;
            synchronized (list) {
                for (ConcurrentJob job : this.thread.turtleForeverButtonJobs) {
                    job.newAgentJoining(agent, -1, 0);
                }
            }
        } else if (agent instanceof Link) {
            List<ConcurrentJob> list = this.thread.linkForeverButtonJobs;
            synchronized (list) {
                for (ConcurrentJob job : this.thread.linkForeverButtonJobs) {
                    job.newAgentJoining(agent, -1, 0);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void haltPrimary() {
        this.finishJobs(this.thread.primaryJobs, null);
        this.waitForFinishedJobs(this.thread.primaryJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void haltNonObserverJobs() {
        ArrayList<Job> arrayList = new ArrayList<Job>();
        List<Job> list = this.thread.primaryJobs;
        synchronized (list) {
            for (Job job : this.thread.primaryJobs) {
                if (job == null || job.agentset.type() == Observer.class) continue;
                arrayList.add(job);
            }
        }
        this.finishJobs(arrayList, null);
        this.waitForFinishedJobs(arrayList);
    }

    @Override
    public void finishJobs(JobOwner owner) {
        this.finishJobs(this.thread.primaryJobs, owner);
    }

    @Override
    public void finishSecondaryJobs(JobOwner owner) {
        this.finishJobs(this.thread.secondaryJobs, owner);
        this.thread.lastSecondaryRun = 0L;
        this.timeToRunSecondaryJobs();
    }

    @Override
    public void haltSecondary() {
        this.finishJobs(this.thread.secondaryJobs, null);
        this.thread.lastSecondaryRun = 0L;
        this.timeToRunSecondaryJobs();
        this.waitForFinishedJobs(this.thread.secondaryJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stoppingJobs(JobOwner owner) {
        List<Job> list = this.thread.primaryJobs;
        synchronized (list) {
            for (Job job : this.thread.primaryJobs) {
                if (job == null || owner != null && job.owner != owner) continue;
                job.stopping = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(Job job, boolean kill) {
        while (job.state != 2 && this.thread.isAlive()) {
            if (kill) {
                this.thread.interrupt();
                this.world.comeUpForAir = true;
            }
            this.thread.isTimeToRunSecondaryJobs = true;
            try {
                Job job2 = job;
                synchronized (job2) {
                    job.wait(50L);
                }
            }
            catch (InterruptedException ex) {
                Exceptions.ignore(ex);
            }
        }
        if (job.result instanceof RuntimeException) {
            throw (RuntimeException)job.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishJobs(List<Job> jobs, JobOwner owner) {
        List<Job> list = jobs;
        synchronized (list) {
            for (Job job : jobs) {
                if (job == null || owner != null && job.owner != owner) continue;
                job.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFinishedJobs(List<Job> jobs) {
        while (this.thread.isAlive()) {
            Job jobToWaitFor = null;
            List<Job> list = jobs;
            synchronized (list) {
                for (Job job : jobs) {
                    if (job == null) continue;
                    jobToWaitFor = job;
                    break;
                }
            }
            if (jobToWaitFor == null) break;
            this.waitFor(jobToWaitFor, true);
        }
    }
}

