/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.job.JobManager;
import org.nlogo.nvm.ConcurrentJob;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerOwner;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp final class JobThread
extends Thread {
    private final JobManager manager;
    final JobManagerOwner jobManagerOwner;
    private final Object lock;
    final List<Job> primaryJobs = Collections.synchronizedList(new ArrayList());
    final List<Job> secondaryJobs = Collections.synchronizedList(new ArrayList());
    private volatile boolean dying = false;
    final List<ConcurrentJob> turtleForeverButtonJobs = Collections.synchronizedList(new ArrayList());
    final List<ConcurrentJob> linkForeverButtonJobs = Collections.synchronizedList(new ArrayList());
    long lastSecondaryRun = 0L;
    final Object newJobsCondition = new Object();
    boolean isTimeToRunSecondaryJobs = false;
    private JobOwner activeButton = null;
    private long lastSecondaryRunDuration = 0L;

    JobThread(JobManager manager, JobManagerOwner jobManagerOwner, Object lock) {
        super("JobThread");
        this.manager = manager;
        this.jobManagerOwner = jobManagerOwner;
        this.lock = lock;
        this.setPriority(4);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.dying) {
                this.compact(this.primaryJobs);
                this.runPrimaryJobs();
                this.maybeRunSecondaryJobs();
                Object object = this.newJobsCondition;
                synchronized (object) {
                    if (this.primaryJobs.isEmpty()) {
                        try {
                            this.newJobsCondition.wait(200L);
                        }
                        catch (InterruptedException ex) {
                            Exceptions.ignore(ex);
                        }
                    }
                }
            }
            return;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    void maybeRunSecondaryJobs() {
        long now;
        if (this.isTimeToRunSecondaryJobs && (now = System.currentTimeMillis()) - this.lastSecondaryRun > 100L + this.lastSecondaryRunDuration) {
            this.compact(this.secondaryJobs);
            this.runSecondaryJobs();
            this.isTimeToRunSecondaryJobs = false;
            this.lastSecondaryRun = System.currentTimeMillis();
            this.lastSecondaryRunDuration = this.lastSecondaryRun - now;
            this.jobManagerOwner.periodicUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPrimaryJobs() {
        for (int i = 0; i < this.primaryJobs.size(); ++i) {
            Job job;
            block19: {
                Object object;
                job = this.primaryJobs.get(i);
                if (job.state != 0) {
                    if (job.topLevelProcedure != null && job.owner == this.activeButton) {
                        this.activeButton = null;
                    }
                    this.primaryJobs.set(i, null);
                    if (job.isTurtleForeverButtonJob()) {
                        this.turtleForeverButtonJobs.remove(job);
                    }
                    if (job.isLinkForeverButtonJob()) {
                        this.linkForeverButtonJobs.remove(job);
                    }
                    job.state = (byte)2;
                    if (job.topLevelProcedure == null) continue;
                    this.jobManagerOwner.updateDisplay(false);
                    object = job;
                    synchronized (object) {
                        job.notifyAll();
                    }
                    if (job.owner == null) continue;
                    this.jobManagerOwner.ownerFinished(job.owner);
                    continue;
                }
                if (job.owner != null && job.owner.isButton() && job.topLevelProcedure != null) {
                    if (this.activeButton != null) {
                        if (job.owner != this.activeButton) {
                            continue;
                        }
                    } else {
                        this.activeButton = job.owner;
                    }
                }
                try {
                    object = this.lock;
                    synchronized (object) {
                        job.step();
                    }
                }
                catch (LogoException ex) {
                    job.result = ex;
                    if (job.owner != null) {
                        this.manager.finishJobs(this.primaryJobs, job.owner);
                    }
                }
                catch (RuntimeException ex) {
                    job.result = ex;
                    if (job.owner == null) break block19;
                    this.manager.finishJobs(this.primaryJobs, job.owner);
                }
            }
            if (!job.buttonTurnIsOver) continue;
            this.activeButton = null;
            job.buttonTurnIsOver = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSecondaryJobs() {
        for (int i = 0; i < this.secondaryJobs.size(); ++i) {
            Object object;
            Job job = this.secondaryJobs.get(i);
            if (job.state != 0) {
                this.secondaryJobs.set(i, null);
                job.state = (byte)2;
                if (job.topLevelProcedure == null) continue;
                object = job;
                synchronized (object) {
                    job.notifyAll();
                }
                if (job.owner == null) continue;
                this.jobManagerOwner.ownerFinished(job.owner);
                continue;
            }
            try {
                object = this.lock;
                synchronized (object) {
                    job.step();
                    continue;
                }
            }
            catch (LogoException ex) {
                job.result = ex;
                if (job.owner == null) continue;
                this.manager.finishJobs(this.secondaryJobs, job.owner);
                continue;
            }
            catch (RuntimeException ex) {
                job.result = ex;
                if (job.owner == null) continue;
                this.manager.finishJobs(this.secondaryJobs, job.owner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(List<Job> list) {
        List<Job> list2 = list;
        synchronized (list2) {
            Iterator<Job> iter = list.iterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
            }
        }
    }
}

