/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lite;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.nlogo.awt.Utils;
import org.nlogo.lite.AppletPanel;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Events;
import org.nlogo.window.InvalidVersionException;
import org.nlogo.window.VMCheck;

public strictfp class Applet
extends JApplet
implements Events.CompiledEvent.Handler {
    private AppletPanel panel;

    public void init() {
        VMCheck.detectBadJVMs();
        Utils.invokeLater(new Runnable(){

            public void run() {
                Applet.this.init2();
                Applet.this.go(null);
            }
        });
    }

    public void init2() {
        this.panel = new AppletPanel(Utils.getFrame(this), new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                try {
                    AppletContext context = Applet.this.getAppletContext();
                    context.showDocument(new URL("http://ccl.northwestern.edu/netlogo/"), "_blank");
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException();
                }
            }
        }, true){

            protected URL getFileURL(String filename) throws MalformedURLException {
                return new URL(Applet.this.getCodeBase(), filename);
            }
        };
        this.add(this.panel);
        this.panel.setPrefix(this.getCodeBase());
    }

    public void go(String path) {
        String name = "";
        try {
            name = this.getParameter("DefaultModel");
            if (this.getCodeBase().toString().indexOf("file:") == 0 && System.getProperty("os.name").startsWith("Windows")) {
                name = org.nlogo.util.Utils.unescapeSpacesInURL(name);
            }
            URL modelURL = new URL(this.getCodeBase(), name);
            this.panel.setPrefix(modelURL);
            String source2 = org.nlogo.util.Utils.url2String(modelURL.toString());
            this.panel.openFromSource(name, name, source2);
            Utils.invokeLater(new Runnable(){

                public void run() {
                    Applet.this.requestFocus();
                }
            });
        }
        catch (FileNotFoundException ex) {
            Applet.showModelNotFoundDialog(ex.getMessage());
        }
        catch (InvalidVersionException e) {
            Applet.showInvalidVersionDialog();
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public void requestFocus() {
        if (this.panel != null) {
            this.panel.requestFocus();
        }
    }

    public void handle(Events.CompiledEvent e) {
        if (e.error != null) {
            JPanel errorPanel = new JPanel();
            String msg = (e.sourceOwner != null ? e.sourceOwner.classDisplayName() + ": " : "") + e.error.getMessage();
            errorPanel.add(new JLabel(msg));
            errorPanel.setBackground(Color.white);
            this.add(errorPanel);
        }
    }

    private static void showModelNotFoundDialog(String name) {
        String message = "Model file not found:\n" + name + "\n\n" + "The model should be in the same directory as the HTML\n" + "file containing the applet.  (Or, you can modify the defaultModel\n" + "attribute of the APPLET tag to point to a different location.)\n";
        JOptionPane pane = new JOptionPane(message);
        JDialog dialog = pane.createDialog(new JFrame(), "Model File Not Found");
        dialog.setVisible(true);
    }

    private static void showInvalidVersionDialog() {
        String message = "The file is not a valid NetLogo model file.";
        JOptionPane pane = new JOptionPane(message);
        JDialog dialog = pane.createDialog(new JFrame(), "Model File Not Found");
        dialog.setVisible(true);
    }
}

