/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lite;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.nlogo.agent.Agent;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AggregateManagerInterface;
import org.nlogo.api.FileIO;
import org.nlogo.api.LogoException;
import org.nlogo.api.ModelReader;
import org.nlogo.api.ModelType;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.Version;
import org.nlogo.awt.Utils;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.nvm.CompilerInterface;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Femto;
import org.nlogo.window.AppletAdPanel;
import org.nlogo.window.CodeEditor;
import org.nlogo.window.CompilerManager;
import org.nlogo.window.EditorColorizer;
import org.nlogo.window.EditorFactory;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfacePanelLite;
import org.nlogo.window.InvalidVersionException;
import org.nlogo.window.ModelLoader;
import org.nlogo.window.ProceduresLite;
import org.nlogo.window.RuntimeErrorDialog;
import org.nlogo.window.VMCheck;
import org.nlogo.workspace.AbstractWorkspace;

public abstract class AppletPanel
extends JPanel
implements Exceptions.Handler,
Event.LinkParent {
    protected final InterfacePanelLite iP;
    protected final GUIWorkspace workspace;
    private final ProceduresLite procedures;
    private final AppletAdPanel panel;
    private final AggregateManagerInterface aggregateManager;
    private final List<Object> linkComponents = new ArrayList<Object>();

    public AppletPanel(Frame frame, MouseListener mouseListener, boolean bl) {
        AbstractWorkspace.isApplet(bl);
        RuntimeErrorDialog.init(this);
        Exceptions.setHandler(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        final Femto femto = new Femto();
        femto.addClass(AggregateManagerInterface.class, "org.nlogo.sdm.AggregateManagerLite");
        femto.addClass(RendererInterface.class, "org.nlogo.render.Renderer");
        femto.addScalaSingleton(CompilerInterface.class, "org.nlogo.compiler.Compiler");
        this.aggregateManager = femto.get(AggregateManagerInterface.class, new Object[0]);
        World world = Version.is3D() ? new World3D() : new World();
        this.workspace = new GUIWorkspace(world, GUIWorkspace.KioskLevel.MODERATE, frame, frame, null, null, femto.get(CompilerInterface.class, new Object[0])){

            @Override
            protected void doImport(AbstractWorkspace.BufferedReaderImporter importer) throws IOException {
                if (1.isApplet()) {
                    importer.doImport(new BufferedReader(new StringReader(org.nlogo.util.Utils.url2String(AppletPanel.this.getFileURL(importer.filename).toString()))));
                } else {
                    super.doImport(importer);
                }
            }

            @Override
            public void inspectAgent(Class<? extends Agent> agentClass, Agent agent, double radius) {
            }

            @Override
            public AggregateManagerInterface aggregateManager() {
                return AppletPanel.this.aggregateManager;
            }

            @Override
            public RendererInterface newRenderer() {
                return femto.get(RendererInterface.class, this.world);
            }
        };
        this.addLinkComponent(this.aggregateManager);
        this.addLinkComponent(this.workspace);
        this.procedures = new ProceduresLite(this.workspace, this.workspace);
        this.addLinkComponent(this.procedures);
        this.addLinkComponent(new CompilerManager(this.workspace, this.procedures));
        this.addLinkComponent(new Events.CompiledEvent.Handler(){

            public void handle(Events.CompiledEvent e) {
                if (e.error != null) {
                    e.error.printStackTrace();
                }
            }
        });
        this.addLinkComponent(new Events.LoadSectionEvent.Handler(){

            public void handle(Events.LoadSectionEvent e) {
                if (e.section == ModelReader.Section.AGGREGATE) {
                    AppletPanel.this.aggregateManager.load(e.text, AppletPanel.this.workspace);
                }
            }
        });
        this.iP = new InterfacePanelLite(this.workspace.viewWidget, this.workspace, this.workspace, this.workspace.plotManager(), new EditorFactory(){

            public AbstractEditorArea newEditor(int cols, int rows, boolean disableFocusTraversal) {
                Font font = new Font(Utils.platformMonospacedFont(), 0, 12);
                return new CodeEditor(cols, rows, font, disableFocusTraversal, null, new EditorColorizer(AppletPanel.this.workspace));
            }
        });
        this.workspace.setWidgetContainer(this.iP);
        this.setBackground(Color.WHITE);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.iP, gridBagConstraints);
        this.add(this.iP);
        this.panel = new AppletAdPanel(mouseListener);
        gridBagConstraints.anchor = 15;
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.add(this.panel);
    }

    protected abstract URL getFileURL(String var1) throws MalformedURLException;

    public void requestFocus() {
        if (this.iP != null) {
            this.iP.requestFocus();
        }
    }

    public void setAdVisible(boolean visible) {
        this.panel.setVisible(visible);
    }

    public void setPrefix(URL url) {
        this.workspace.fileManager().setPrefix(url);
    }

    public void handle(final Throwable throwable) {
        try {
            if (!(throwable instanceof LogoException)) {
                throwable.printStackTrace(System.err);
            }
            final Thread thread = Thread.currentThread();
            Utils.invokeLater(new Runnable(){

                public void run() {
                    RuntimeErrorDialog.show("Runtime Error", null, null, thread, throwable);
                }
            });
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void addLinkComponent(Object c) {
        this.linkComponents.add(c);
    }

    public Object[] getLinkChildren() {
        return this.linkComponents.toArray();
    }

    public void openFromSource(String name, String path, String source2) throws InvalidVersionException {
        RuntimeErrorDialog.setModelName(name);
        ModelLoader.load(this, path, ModelType.LIBRARY, source2);
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UseQuartz", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        AbstractWorkspace.isApplet(false);
        VMCheck.detectBadJVMs();
        String path = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--events")) {
                Event.logEvents = true;
                continue;
            }
            path = args[i];
        }
        final String finalPath = path;
        Utils.invokeLater(new Runnable(){

            public void run() {
                try {
                    this.run2();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvalidVersionException e) {
                    throw new IllegalStateException(e);
                }
            }

            private void run2() throws IOException, InvalidVersionException {
                final JFrame frame = new JFrame("NetLogo Model");
                AppletPanel applet = new AppletPanel(frame, new MouseAdapter(){}, false){

                    protected URL getFileURL(String filename) throws MalformedURLException {
                        return AppletPanel.toURL(new File(filename));
                    }

                    public Insets getInsets() {
                        return new Insets(5, 5, 5, 5);
                    }
                };
                frame.setResizable(false);
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        frame.setVisible(false);
                        frame.dispose();
                        AppletPanel.main(new String[0]);
                    }
                });
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)applet, "Center");
                frame.pack();
                String path = finalPath;
                if (path == null) {
                    FileDialog dialog = new FileDialog((Frame)frame, "Open: NetLogo Model", 0);
                    dialog.setVisible(true);
                    if (dialog.getDirectory() == null) {
                        System.exit(0);
                    }
                    path = dialog.getDirectory() + dialog.getFile();
                }
                applet.setAdVisible(false);
                String name = new File(path).getName();
                String source2 = FileIO.file2String(path);
                String modelPath = new File(path).getAbsolutePath();
                applet.openFromSource(name, modelPath, source2);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private static URL toURL(File file) throws MalformedURLException {
        return file.toURL();
    }
}

