/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.log;

public strictfp final class LogMessage {
    public String[][] attributes;
    public LogMessage[] elements;
    public String data;
    public String tag;

    private LogMessage() {
    }

    public static LogMessage createGlobalMessage(String type) {
        LogMessage msg = new LogMessage();
        msg.tag = "event";
        msg.attributes = new String[1][];
        msg.attributes[0] = new String[2];
        msg.attributes[0][0] = "type";
        msg.attributes[0][1] = type;
        msg.elements = new LogMessage[2];
        msg.elements[0] = new LogMessage();
        msg.elements[0].tag = "name";
        msg.elements[1] = new LogMessage();
        msg.elements[1].tag = "value";
        return msg;
    }

    public void updateGlobalMessage(String name, String value) {
        this.elements[0].data = name;
        this.elements[1].data = value;
    }

    public static LogMessage createSliderMessage() {
        LogMessage msg = new LogMessage();
        msg.tag = "event";
        msg.attributes = new String[1][];
        msg.attributes[0] = new String[2];
        msg.attributes[0][0] = "type";
        msg.attributes[0][1] = "slider";
        msg.elements = new LogMessage[4];
        msg.elements[0] = new LogMessage();
        msg.elements[0].tag = "action";
        msg.elements[0].data = "changed";
        msg.elements[1] = new LogMessage();
        msg.elements[1].tag = "name";
        msg.elements[2] = new LogMessage();
        msg.elements[2].tag = "value";
        msg.elements[3] = LogMessage.createSliderParameterMessage();
        return msg;
    }

    public static LogMessage createSliderParameterMessage() {
        LogMessage msg = new LogMessage();
        msg.tag = "parameters";
        msg.elements = new LogMessage[3];
        msg.elements[0] = new LogMessage();
        msg.elements[0].tag = "min";
        msg.elements[1] = new LogMessage();
        msg.elements[1].tag = "max";
        msg.elements[2] = new LogMessage();
        msg.elements[2].tag = "inc";
        return msg;
    }

    public void updateSliderMessage(String name, double value, double min, double max, double inc) {
        this.elements[1].data = name;
        this.elements[2].data = Double.toString(value);
        this.elements[3].elements[0].data = Double.toString(min);
        this.elements[3].elements[1].data = Double.toString(max);
        this.elements[3].elements[2].data = Double.toString(inc);
    }

    public static LogMessage createButtonMessage() {
        LogMessage msg = new LogMessage();
        msg.tag = "event";
        msg.attributes = new String[1][];
        msg.attributes[0] = new String[2];
        msg.attributes[0][0] = "type";
        msg.attributes[0][1] = "button";
        msg.elements = new LogMessage[3];
        msg.elements[0] = new LogMessage();
        msg.elements[0].tag = "name";
        msg.elements[1] = new LogMessage();
        msg.elements[1].tag = "action";
        msg.elements[2] = new LogMessage();
        msg.elements[2].tag = "releaseType";
        return msg;
    }

    public void updateButtonMessage(String name, String action, String who) {
        this.elements[0].data = name;
        this.elements[1].data = action;
        this.elements[2].data = who;
    }

    public static LogMessage createWidgetMessage() {
        LogMessage msg = new LogMessage();
        msg.tag = "event";
        msg.attributes = new String[1][];
        msg.attributes[0] = new String[2];
        msg.attributes[0][0] = "type";
        msg.elements = new LogMessage[2];
        msg.elements[0] = new LogMessage();
        msg.elements[0].tag = "name";
        msg.elements[1] = new LogMessage();
        msg.elements[1].tag = "action";
        return msg;
    }

    public static LogMessage createAgentMessage() {
        LogMessage msg = new LogMessage();
        msg.tag = "event";
        msg.attributes = new String[1][];
        msg.attributes[0] = new String[2];
        msg.attributes[0][0] = "type";
        msg.elements = new LogMessage[3];
        msg.elements[0] = new LogMessage();
        msg.elements[0].tag = "name";
        msg.elements[1] = new LogMessage();
        msg.elements[1].tag = "action";
        msg.elements[2] = new LogMessage();
        msg.elements[2].tag = "breed";
        return msg;
    }

    public void updateAgentMessage(String type, String name, String action, String breed) {
        this.attributes[0][1] = type;
        this.elements[0].data = name;
        this.elements[1].data = action;
        this.elements[2].data = breed;
    }

    public static LogMessage createCompileMessage() {
        LogMessage msg = new LogMessage();
        msg.tag = "event";
        msg.attributes = new String[1][];
        msg.attributes[0] = new String[2];
        msg.attributes[0][0] = "type";
        msg.elements = new LogMessage[4];
        msg.elements[0] = new LogMessage();
        msg.elements[0].tag = "action";
        msg.elements[1] = new LogMessage();
        msg.elements[1].tag = "code";
        msg.elements[2] = new LogMessage();
        msg.elements[2].tag = "agentType";
        msg.elements[3] = new LogMessage();
        msg.elements[3].tag = "errorMessage";
        msg.elements[3].attributes = new String[2][];
        msg.elements[3].attributes[0] = new String[2];
        msg.elements[3].attributes[0][0] = "startPos";
        msg.elements[3].attributes[1] = new String[2];
        msg.elements[3].attributes[1][0] = "endPos";
        return msg;
    }

    public void updateCompileMessage(String type, String action, String code, String agentType, String errorMessage, int startPos, int endPos) {
        this.attributes[0][1] = type;
        this.elements[0].data = action;
        this.elements[1].data = code;
        this.elements[2].data = agentType;
        this.elements[3].data = errorMessage;
        this.elements[3].attributes[0][1] = Integer.toString(startPos);
        this.elements[3].attributes[1][1] = Integer.toString(endPos);
    }

    public static LogMessage createSpeedMessage() {
        LogMessage msg = new LogMessage();
        msg.tag = "event";
        msg.attributes = new String[1][];
        msg.attributes[0] = new String[2];
        msg.attributes[0][0] = "type";
        msg.attributes[0][1] = "speed";
        msg.elements = new LogMessage[1];
        msg.elements[0] = new LogMessage();
        msg.elements[0].tag = "value";
        return msg;
    }

    public void updateSpeedMessage(String value) {
        this.elements[0].data = value;
    }
}

