/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.Let;
import org.nlogo.api.LogoException;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.ConcurrentJob;
import org.nlogo.nvm.EngineException;
import org.nlogo.nvm.ExclusiveJob;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.LetMap;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Reporter;
import org.nlogo.util.Exceptions;

public strictfp final class Context {
    public final Job job;
    public Agent myself;
    public Agent agent;
    public int agentBit;
    public int ip;
    public Activation activation;
    public boolean waiting = false;
    private LetMap letMap;
    private boolean inReporterProcedure = false;
    public boolean stopping = false;
    public boolean finished = false;

    public Context(Job job, Agent agent, int ip, Activation activation) {
        this.job = job;
        this.agent = agent;
        if (agent != null) {
            this.agentBit = agent.getAgentBit();
        }
        this.ip = ip;
        this.activation = activation;
    }

    public Context(Context context, AgentSet agents) {
        this.job = context.job;
        this.activation = context.activation;
        this.letMap = context.letMap;
        this.myself = context.agent;
        this.agentBit = agents.getAgentBit();
    }

    public Context(Context context, Agent agent) {
        this.job = context.job;
        this.activation = context.activation;
        this.letMap = context.letMap;
        this.myself = context.agent;
        this.agentBit = agent.getAgentBit();
    }

    public boolean makeChildrenExclusive() {
        return this.inReporterProcedure || this.job.exclusive();
    }

    void stepConcurrent() throws LogoException {
        if (this.agent.id == -1L) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!command.switches && !this.finished);
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this, command);
        }
        catch (StackOverflowError ex) {
            throw new EngineException(this, "stack overflow (recursion too deep)");
        }
    }

    void runExclusive() throws LogoException {
        if (this.agent.id == -1L) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!this.finished);
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this, command);
        }
    }

    public Agent myself() {
        if (this.myself == null) {
            if (this.job.parentContext == null) {
                throw new IllegalStateException("null parent context");
            }
            this.myself = this.job.parentContext.agent;
        }
        return this.myself;
    }

    public boolean atTopActivation() {
        return this.job.parentContext == null || this.activation != this.job.parentContext.activation;
    }

    public void runExclusiveJob(AgentSet agentset, int address) throws LogoException {
        new ExclusiveJob(this.job.owner, agentset, this.activation.procedure, address, this, this.job.random).run();
        if (this.agent.id == -1L) {
            this.finished = true;
        }
    }

    public Job makeConcurrentJob(AgentSet agentset) {
        return new ConcurrentJob(this.job.owner, agentset, null, this.ip + 1, this, this.job.random);
    }

    public void returnFromProcedure() {
        this.ip = this.activation.returnAddress;
        this.activation = this.activation.parent;
    }

    public Object evaluateReporter(Agent agent, Reporter reporter) throws LogoException {
        this.agent = agent;
        return reporter.report(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callReporterProcedure(Activation newActivation) throws LogoException {
        boolean oldInReporterProcedure = this.inReporterProcedure;
        Command command = null;
        this.inReporterProcedure = true;
        this.activation = newActivation;
        this.ip = 0;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!this.finished && this.job.result == null);
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this, command);
        }
        finally {
            this.inReporterProcedure = oldInReporterProcedure;
        }
        this.ip = this.activation.returnAddress;
        this.activation = this.activation.parent;
        Object result = this.job.result;
        this.job.result = null;
        return result;
    }

    public void let(Let let, Object value) {
        if (this.letMap == null) {
            this.letMap = new LetMap();
        }
        this.letMap.add(let, value);
    }

    public Object getLet(Let let) {
        Object value;
        if (this.letMap != null && (value = this.letMap.get(let)) != null) {
            return value;
        }
        return this.job.parentContext.getLet(let);
    }

    public void setLet(Let let, Object value) {
        if (this.letMap == null || !this.letMap.set(let, value)) {
            this.job.parentContext.setLet(let, value);
        }
    }

    public String toString() {
        return "Context: ip: " + this.ip + " job: " + this.job;
    }

    void runtimeError(Exception ex) {
        try {
            Instruction instruction = null;
            Context context = null;
            if (ex instanceof EngineException) {
                instruction = ((EngineException)ex).instruction;
                context = ((EngineException)ex).context;
            }
            if (instruction == null) {
                instruction = this.activation.procedure.code[this.ip];
            }
            if (context == null) {
                context = this;
            }
            this.activation.procedure.code[this.ip].workspace().runtimeError(this.job.owner, context, instruction, ex);
        }
        catch (RuntimeException ex2) {
            Exceptions.handle(ex);
        }
    }

    public String buildRuntimeErrorMessage(Instruction instruction, Throwable throwable) {
        Activation parentActivation;
        Procedure procedure;
        String exceptionName = "." + throwable.getClass().getName();
        exceptionName = exceptionName.substring(exceptionName.lastIndexOf(46) + 1);
        String instructionName = instruction.displayName();
        String procedureName = "";
        Procedure procedure2 = procedure = this.activation == null ? null : this.activation.procedure;
        if (procedure != null && !procedure.topLevel) {
            procedureName = " in procedure " + procedure.getNameAndFile();
        }
        Activation activation = parentActivation = this.activation == null ? null : this.activation.parent;
        while (parentActivation != null) {
            if (parentActivation.procedure != null) {
                if (parentActivation.procedure.topLevel) break;
                procedureName = procedureName + "\n  called by procedure " + parentActivation.procedure.getNameAndFile();
            }
            parentActivation = parentActivation.parent;
        }
        String message = throwable instanceof LogoException ? "error while " + this.agent + " running " + instructionName + procedureName + "\n" + throwable.getMessage() : "error (" + exceptionName + ")\nwhile " + this.agent + " running " + instructionName + procedureName;
        if (this.job.owner != null) {
            message = message + "\n(halted running of " + this.job.owner.displayName() + ")";
        }
        return message;
    }

    private void comeUpForAir(Command command) throws HaltException {
        if (command.switches && this.job.owner != null && this.job.owner.ownsPrimaryJobs()) {
            command.workspace().perhapsUpdateDisplay();
        }
        if (Thread.currentThread().isInterrupted()) {
            command.world.comeUpForAir = false;
            this.finished = true;
            throw new HaltException(true);
        }
    }
}

