/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.LogoList;
import org.nlogo.api.Nobody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Syntax {
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_LIST = 8;
    public static final int TYPE_TURTLESET = 16;
    public static final int TYPE_PATCHSET = 32;
    public static final int TYPE_LINKSET = 64;
    public static final int TYPE_AGENTSET = 112;
    public static final int TYPE_TURTLE = 256;
    public static final int TYPE_PATCH = 512;
    public static final int TYPE_LINK = 1024;
    public static final int TYPE_AGENT = 1792;
    public static final int TYPE_WILDCARD = 2047;
    public static final int TYPE_REFERENCE = 2048;
    public static final int TYPE_COMMAND_BLOCK = 4096;
    public static final int TYPE_BOOLEAN_BLOCK = 8192;
    public static final int TYPE_NUMBER_BLOCK = 16384;
    public static final int TYPE_OTHER_BLOCK = 32768;
    public static final int TYPE_REPORTER_BLOCK = 57344;
    public static final int TYPE_REPEATABLE = 65536;
    public static final int TYPE_OPTIONAL = 131072;
    private final int left;
    private final int[] right;
    private final int ret;
    private final int precedence;
    private final int dfault;
    private final int minimum;
    private final boolean isRightAssociative;
    private final String agentClassString;
    private final String blockAgentClassString;
    private final boolean switches;

    public int[] right() {
        return this.right;
    }

    public int left() {
        return this.left;
    }

    public int ret() {
        return this.ret;
    }

    public int precedence() {
        return this.precedence;
    }

    public boolean isRightAssociative() {
        return this.isRightAssociative;
    }

    public String agentClassString() {
        return this.agentClassString;
    }

    public String blockAgentClassString() {
        return this.blockAgentClassString;
    }

    public boolean switches() {
        return this.switches;
    }

    private Syntax(int left, int[] right, int ret, int precedence, int dfault, boolean isRightAssociative) {
        this(left, right, ret, precedence, dfault, dfault, isRightAssociative, "OTPL", null, false);
    }

    private Syntax(int left, int[] right, int ret, int precedence, int dfault, int minimum, boolean isRightAssociative, String agentClassString, String blockAgentClassString, boolean switches) {
        if (agentClassString != null && agentClassString.length() != 4) {
            throw new IllegalArgumentException();
        }
        if (blockAgentClassString != null && blockAgentClassString.length() != 4 && !blockAgentClassString.equals("?")) {
            throw new IllegalArgumentException();
        }
        this.left = left;
        this.right = right;
        this.ret = ret;
        this.precedence = precedence;
        this.dfault = dfault;
        this.minimum = minimum;
        this.isRightAssociative = isRightAssociative;
        this.agentClassString = agentClassString;
        this.blockAgentClassString = blockAgentClassString;
        this.switches = switches;
    }

    public static Syntax commandSyntax() {
        return Syntax.commandSyntax(false);
    }

    public static Syntax commandSyntax(boolean switches) {
        return Syntax.commandSyntax("OTPL", switches);
    }

    public static Syntax commandSyntax(String agentClassString, boolean switches) {
        return new Syntax(0, new int[0], 0, 0, 0, 0, false, agentClassString, null, switches);
    }

    public static Syntax commandSyntax(int[] right) {
        return new Syntax(0, right, 0, 0, right.length, false);
    }

    public static Syntax commandSyntax(int[] right, boolean switches) {
        return new Syntax(0, right, 0, 0, right.length, right.length, false, "OTPL", null, switches);
    }

    public static Syntax commandSyntax(int[] right, String agentClassString) {
        return new Syntax(0, right, 0, 0, right.length, right.length, false, agentClassString, null, false);
    }

    public static Syntax commandSyntax(int[] right, String agentClassString, boolean switches) {
        return new Syntax(0, right, 0, 0, right.length, right.length, false, agentClassString, null, switches);
    }

    public static Syntax commandSyntax(int[] right, String agentClassString, String blockAgentClassString, boolean switches) {
        return new Syntax(0, right, 0, 0, right.length, right.length, false, agentClassString, blockAgentClassString, switches);
    }

    public static Syntax commandSyntax(int[] right, int dfault, String agentClassString, String blockAgentClassString, boolean switches) {
        return new Syntax(0, right, 0, 0, dfault, right.length, false, agentClassString, blockAgentClassString, switches);
    }

    public static Syntax commandSyntax(int[] right, int dfault) {
        return new Syntax(0, right, 0, 0, dfault, false);
    }

    public static Syntax reporterSyntax(int ret) {
        return new Syntax(0, new int[0], ret, 10, 0, false);
    }

    public static Syntax reporterSyntax(int ret, String agentClassString) {
        return new Syntax(0, new int[0], ret, 10, 0, 0, false, agentClassString, null, false);
    }

    public static Syntax reporterSyntax(int left, int[] right, int ret, int precedence) {
        return new Syntax(left, right, ret, precedence, right.length, false);
    }

    public static Syntax reporterSyntax(int[] right, int ret) {
        return new Syntax(0, right, ret, 10, right.length, false);
    }

    public static Syntax reporterSyntax(int[] right, int ret, String agentClassString, String blockAgentClassString) {
        return new Syntax(0, right, ret, 10, right.length, right.length, false, agentClassString, blockAgentClassString, false);
    }

    public static Syntax reporterSyntax(int[] right, int ret, String agentClassString) {
        return new Syntax(0, right, ret, 10, right.length, right.length, false, agentClassString, null, false);
    }

    public static Syntax reporterSyntax(int[] right, int ret, int dfault) {
        return new Syntax(0, right, ret, 10, dfault, false);
    }

    public static Syntax reporterSyntax(int[] right, int ret, int dfault, int min) {
        return new Syntax(0, right, ret, 10, dfault, min, false, "OTPL", null, false);
    }

    public static Syntax reporterSyntax(int left, int[] right, int ret, int precedence, boolean isRightAssociative, String agentClassString, String blockAgentClassString) {
        return new Syntax(left, right, ret, precedence, right.length, right.length, isRightAssociative, agentClassString, blockAgentClassString, false);
    }

    public static Syntax reporterSyntax(int left, int[] right, int ret, int precedence, int dfault, boolean isRightAssociative, String agentClassString, String blockAgentClassString) {
        return new Syntax(left, right, ret, precedence, dfault, right.length, isRightAssociative, agentClassString, blockAgentClassString, false);
    }

    public boolean isInfix() {
        return this.left != 0;
    }

    public int rightDefault() {
        return this.dfault;
    }

    public int totalDefault() {
        return this.isInfix() ? this.dfault + 1 : this.dfault;
    }

    public int min() {
        return this.minimum;
    }

    public static int getAgentSetMask(Class<? extends Agent> clazz) {
        if (clazz == Turtle.class) {
            return 16;
        }
        if (clazz == Patch.class) {
            return 32;
        }
        if (clazz == Link.class) {
            return 64;
        }
        return 112;
    }

    public static boolean typesAreCompatible(int mask, int value) {
        return (mask & value) > 0;
    }

    public static String aTypeName(Object obj) {
        String result = Syntax.typeName(obj);
        if (obj instanceof Nobody) {
            return result;
        }
        return Syntax.addAOrAn(result);
    }

    public static String typeName(Object obj) {
        if (obj instanceof Number) {
            return Syntax.typeName(1);
        }
        if (obj instanceof Boolean) {
            return Syntax.typeName(2);
        }
        if (obj instanceof String) {
            return Syntax.typeName(4);
        }
        if (obj instanceof LogoList) {
            return Syntax.typeName(8);
        }
        if (obj instanceof AgentSet) {
            return Syntax.typeName(112);
        }
        if (obj instanceof Nobody) {
            return Syntax.typeName(128);
        }
        if (obj instanceof Turtle) {
            return Syntax.typeName(256);
        }
        if (obj instanceof Patch) {
            return Syntax.typeName(512);
        }
        if (obj instanceof Link) {
            return Syntax.typeName(1024);
        }
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName();
    }

    public static String aTypeName(int mask) {
        String result = Syntax.typeName(mask);
        if (result.equals("NOBODY")) {
            return "NOBODY";
        }
        if (result.equals("anything")) {
            return result;
        }
        return Syntax.addAOrAn(result);
    }

    public static String typeName(int mask) {
        String result = "(none)";
        if (Syntax.typesAreCompatible(mask, 65536)) {
            mask = Syntax.subtractMasks(mask, 65536);
        }
        if (Syntax.typesAreCompatible(mask, 2048)) {
            return "variable";
        }
        if ((mask & 0xF008) == 61448) {
            result = "list or block";
            mask = Syntax.subtractMasks(mask, 61448);
        } else if ((mask & 0x7FF) == 2047) {
            result = "anything";
            mask = Syntax.subtractMasks(mask, 2047);
        } else if ((mask & 0x700) == 1792) {
            result = "agent";
            mask = Syntax.subtractMasks(mask, 1920);
        } else if (Syntax.typesAreCompatible(mask, 1)) {
            result = "number";
            mask = Syntax.subtractMasks(mask, 1);
        } else if (Syntax.typesAreCompatible(mask, 2)) {
            result = "TRUE/FALSE";
            mask = Syntax.subtractMasks(mask, 2);
        } else if (Syntax.typesAreCompatible(mask, 4)) {
            result = "string";
            mask = Syntax.subtractMasks(mask, 4);
        } else if (Syntax.typesAreCompatible(mask, 8)) {
            result = "list";
            mask = Syntax.subtractMasks(mask, 8);
        } else if ((mask & 0x70) == 112) {
            result = "agentset";
            mask = Syntax.subtractMasks(mask, 112);
        } else if (Syntax.typesAreCompatible(mask, 16)) {
            result = "turtle agentset";
            mask = Syntax.subtractMasks(mask, 16);
        } else if (Syntax.typesAreCompatible(mask, 32)) {
            result = "patch agentset";
            mask = Syntax.subtractMasks(mask, 32);
        } else if (Syntax.typesAreCompatible(mask, 64)) {
            result = "link agentset";
            mask = Syntax.subtractMasks(mask, 64);
        } else if (Syntax.typesAreCompatible(mask, 256)) {
            result = "turtle";
            mask = Syntax.subtractMasks(mask, 384);
        } else if (Syntax.typesAreCompatible(mask, 512)) {
            result = "patch";
            mask = Syntax.subtractMasks(mask, 640);
        } else if (Syntax.typesAreCompatible(mask, 1024)) {
            result = "link";
            mask = Syntax.subtractMasks(mask, 1152);
        } else if (Syntax.typesAreCompatible(mask, 128)) {
            result = "NOBODY";
            mask = Syntax.subtractMasks(mask, 128);
        } else if (Syntax.typesAreCompatible(mask, 4096)) {
            result = "command block";
            mask = Syntax.subtractMasks(mask, 4096);
        } else if ((mask & 0xE000) == 57344) {
            result = "reporter block";
            mask = Syntax.subtractMasks(mask, 57344);
        } else if (Syntax.typesAreCompatible(mask, 32768)) {
            result = "different kind of block";
            mask = Syntax.subtractMasks(mask, 57344);
        } else if (Syntax.typesAreCompatible(mask, 8192)) {
            result = "TRUE/FALSE block";
            mask = Syntax.subtractMasks(mask, 8192);
        } else if (Syntax.typesAreCompatible(mask, 16384)) {
            result = "number block";
            mask = Syntax.subtractMasks(mask, 16384);
        }
        if (mask == 0) {
            return result;
        }
        if (mask == 131072) {
            return result + " (optional)";
        }
        return result + " or " + Syntax.typeName(mask);
    }

    public static int getTypeConstant(Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            return 2047;
        }
        if (clazz.equals(Agent.class)) {
            return 1792;
        }
        if (clazz.equals(AgentSet.class)) {
            return 112;
        }
        if (clazz.equals(LogoList.class)) {
            return 8;
        }
        if (clazz.equals(Turtle.class)) {
            return 256;
        }
        if (clazz.equals(Patch.class)) {
            return 512;
        }
        if (clazz.equals(Link.class)) {
            return 1024;
        }
        if (clazz.equals(String.class)) {
            return 4;
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return 1;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return 2;
        }
        throw new IllegalArgumentException("There was no Syntax type constant found for this class " + clazz);
    }

    private static String addAOrAn(String str) {
        switch (str.toUpperCase().charAt(0)) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                return "an " + str;
            }
        }
        return "a " + str;
    }

    private static int subtractMasks(int mask1, int mask2) {
        return mask1 - (mask1 & mask2);
    }
}

