/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.CSV;
import org.nlogo.api.Color;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPen;
import org.nlogo.plot.PlotPoint;

public strictfp class PlotExporter {
    private final Plot plot;
    private final CSV csv;

    public PlotExporter(Plot plot, CSV csv) {
        this.plot = plot;
        this.csv = csv;
    }

    public void export(PrintWriter writer) {
        this.exportIntro(writer);
        this.exportPens(writer);
        this.exportPoints(writer);
    }

    private void exportIntro(PrintWriter writer) {
        writer.println(this.csv.data(this.plot.name()));
        writer.println(this.csv.headerRow(new String[]{"x min", "x max", "y min", "y max", "autoplot?", "current pen", "legend open?", "number of pens"}));
        writer.println(this.csv.dataRow(new Object[]{this.plot.xMin(), this.plot.xMax(), this.plot.yMin(), this.plot.yMax(), this.plot.autoPlotOn() ? Boolean.TRUE : Boolean.FALSE, this.plot.currentPen().name(), this.plot.legendIsOpen() ? Boolean.TRUE : Boolean.FALSE, this.plot.pens().size()}));
        writer.println();
    }

    private void exportPens(PrintWriter writer) {
        writer.println(this.csv.headerRow(new String[]{"pen name", "pen down?", "mode", "interval", "color", "x"}));
        for (PlotPen pen : this.plot.pens()) {
            writer.println(this.csv.dataRow(new Object[]{pen.name(), pen.isDown() ? Boolean.TRUE : Boolean.FALSE, pen.mode(), pen.interval(), Color.argbToColor(pen.color()), pen.x()}));
        }
        writer.println();
    }

    private void exportPoints(PrintWriter writer) {
        List penDataList;
        int numPens = 0;
        for (PlotPen pen : this.plot.pens()) {
            if (numPens > 0) {
                writer.print(",,,,");
            }
            writer.print(this.csv.data(pen.name()));
            ++numPens;
        }
        writer.println();
        ArrayList<String> pointHeaders = new ArrayList<String>();
        int numPointHeaders = 0;
        for (int i = 0; i < numPens; ++i) {
            pointHeaders.add("x");
            pointHeaders.add("y");
            pointHeaders.add("color");
            pointHeaders.add("pen down?");
            numPointHeaders += 4;
        }
        writer.println(this.csv.headerRow(pointHeaders.toArray(new String[0])));
        ArrayList<List> penDataListsList = new ArrayList<List>();
        int maxPenDataListSize = 0;
        for (PlotPen pen : this.plot.pens()) {
            penDataList = pen.points();
            if (penDataList == null) {
                penDataList = new ArrayList<PlotPoint>();
            }
            maxPenDataListSize = StrictMath.max(maxPenDataListSize, penDataList.size());
            penDataListsList.add(penDataList);
        }
        PlotPoint[][] outColumnsArray = new PlotPoint[maxPenDataListSize][numPens];
        for (int i = 0; i < numPens; ++i) {
            penDataList = (List)penDataListsList.get(i);
            int penDataListSize = penDataList.size();
            for (int j = 0; j < penDataListSize; ++j) {
                outColumnsArray[j][i] = (PlotPoint)penDataList.get(j);
            }
        }
        for (int row = 0; row < maxPenDataListSize; ++row) {
            for (int col = 0; col < numPens; ++col) {
                if (outColumnsArray[row][col] != null) {
                    writer.print(this.csv.data(outColumnsArray[row][col].x()));
                    writer.print(",");
                    writer.print(this.csv.data(outColumnsArray[row][col].y()));
                    writer.print(",");
                    writer.print(this.csv.data(Color.argbToColor(outColumnsArray[row][col].color())));
                    writer.print(",");
                    writer.print(this.csv.data(outColumnsArray[row][col].isDown() ? Boolean.TRUE : Boolean.FALSE));
                    if (col + 1 >= numPens) continue;
                    writer.print(",");
                    continue;
                }
                if (col + 1 < numPens) {
                    writer.print(",,,,");
                    continue;
                }
                writer.print(",,,");
            }
            writer.println();
        }
    }
}

