/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPen;
import org.nlogo.plot.PlotPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class PlotPainter {
    private final Plot plot;
    private Graphics gOff;
    private BufferedImage offScreenImage = null;
    private int height;
    private int width;

    public PlotPainter(Plot plot) {
        this.plot = plot;
    }

    public void setupOffscreenImage(int width, int height) {
        if (this.offScreenImage == null || this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            if (this.offScreenImage != null) {
                this.offScreenImage.flush();
                this.offScreenImage = null;
            }
            this.offScreenImage = new BufferedImage(width, height, 2);
            if (this.gOff != null) {
                this.gOff.dispose();
            }
            this.gOff = this.offScreenImage.getGraphics();
            this.gOff.setColor(Color.WHITE);
            this.gOff.fillRect(0, 0, width, height);
            this.refresh();
        }
    }

    public void drawImage(Graphics g) {
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void refresh() {
        this.gOff.setColor(Color.WHITE);
        this.gOff.fillRect(0, 0, this.offScreenImage.getWidth(), this.offScreenImage.getHeight());
        for (PlotPen pen : this.plot.pens()) {
            if (pen.penModeChanged()) {
                pen.penModeChanged(false);
            }
            this.refreshPen(pen, this.collectPointsForPainting(pen));
        }
    }

    private List<PlotPoint> collectPointsForPainting(PlotPen pen) {
        List<PlotPoint> pointsToPlot;
        switch (pen.mode()) {
            case 0: 
            case 2: {
                pointsToPlot = pen.points();
                break;
            }
            case 1: {
                pointsToPlot = new ArrayList<PlotPoint>();
                for (int i = 0; i < pen.points().size(); ++i) {
                    PlotPoint oldPoint = pen.points().get(i);
                    pointsToPlot.add(new PlotPoint(oldPoint.x(), 0.0, true, oldPoint.color()));
                    pointsToPlot.add(new PlotPoint(oldPoint.x(), oldPoint.y(), true, oldPoint.color()));
                    pointsToPlot.add(new PlotPoint(oldPoint.x() + pen.interval(), oldPoint.y(), true, oldPoint.color()));
                    pointsToPlot.add(new PlotPoint(oldPoint.x() + pen.interval(), 0.0, true, oldPoint.color()));
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return pointsToPlot;
    }

    private void refreshPen(PlotPen pen, List<PlotPoint> pointsToPlot) {
        PlotPoint last = null;
        int color = 0;
        int minY = 0;
        int maxY = 0;
        boolean coalescing = false;
        ((Graphics2D)this.gOff).setRenderingHint(RenderingHints.KEY_ANTIALIASING, pen.mode() == 2 ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_ON);
        int size = pointsToPlot.size();
        for (int i = 0; i < size; ++i) {
            PlotPoint next = pointsToPlot.get(i);
            if (next.color() != color) {
                color = next.color();
                this.gOff.setColor(new Color(color));
            }
            if (pen.mode() == 2) {
                this.drawPoint(this.gOff, next);
            } else if (last == null) {
                this.drawEdge(this.gOff, next, next);
            } else if (i != size - 1 && this.screenX(last.x()) == this.screenX(next.x()) && last.color() == next.color() && last.isDown() && next.isDown()) {
                int y = this.screenY(next.y());
                if (coalescing) {
                    if (y < minY) {
                        minY = y;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                } else {
                    ((Graphics2D)this.gOff).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    this.drawEdge(this.gOff, last, next);
                    coalescing = true;
                    minY = y;
                    maxY = y;
                }
            } else {
                if (coalescing) {
                    this.gOff.setColor(new Color(last.color()));
                    this.gOff.fillRect(this.screenX(last.x()), minY, 1, maxY - minY + 1);
                    coalescing = false;
                    ((Graphics2D)this.gOff).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    this.gOff.setColor(new Color(color));
                }
                if (next.isDown()) {
                    this.drawEdge(this.gOff, last, next);
                }
            }
            last = next;
        }
    }

    private void drawPoint(Graphics g, PlotPoint p) {
        g.drawRect(this.screenX(p.x()), this.screenY(p.y()), 1, 1);
    }

    private void drawEdge(Graphics g, PlotPoint p1, PlotPoint p2) {
        int x1 = this.screenX(p1.x());
        int y1 = this.screenY(p1.y());
        int x2 = this.screenX(p2.x());
        int y2 = this.screenY(p2.y());
        if (x1 < 0 && x2 < 0 || x1 > this.width && x2 > this.width || y1 < 0 && y2 < 0 || y1 > this.height && y2 > this.height) {
            return;
        }
        g.drawLine(x1, y1, x2, y2);
    }

    private int screenX(double x) {
        double range = this.plot.xMax() - this.plot.xMin();
        double scale = range / (double)(this.width - 1);
        double result = StrictMath.rint((x - this.plot.xMin()) / scale);
        if (result > 16383.0) {
            return 16383;
        }
        if (result < -16383.0) {
            return -16383;
        }
        return (int)result;
    }

    private int screenY(double y) {
        double range = this.plot.yMax() - this.plot.yMin();
        double scale = range / (double)(this.height - 1);
        double result = StrictMath.rint((double)(this.height - 1) - (y - this.plot.yMin()) / scale);
        if (result > 16383.0) {
            return 16383;
        }
        if (result < -16383.0) {
            return -16383;
        }
        return (int)result;
    }
}

