/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class PlotPen
implements Serializable,
Cloneable,
PlotPenInterface {
    private static final String[] PLOT_PEN_MODES = new String[]{"Line", "Bar", "Point"};
    private Plot plot;
    private boolean temporary;
    private List<PlotPoint> points = new ArrayList<PlotPoint>();
    private double x = 0.0;
    private int defaultColor = Color.BLACK.getRGB();
    private int color = Color.BLACK.getRGB();
    private String name;
    private boolean inLegend = true;
    private double defaultInterval = 1.0;
    private double interval = 1.0;
    private boolean isDown = true;
    private int defaultMode = 0;
    private int mode = 0;
    private boolean penModeChanged = false;

    public static boolean isValidPlotPenMode(int mode) {
        return mode >= 0 && mode < PLOT_PEN_MODES.length;
    }

    public PlotPen(Plot plot, String name, boolean temporary) {
        this.plot = plot;
        this.name = name;
        this.temporary = temporary;
        this.hardReset();
        plot.addPen(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean temporary() {
        return this.temporary;
    }

    public List<PlotPoint> points() {
        return this.points;
    }

    public double x() {
        return this.x;
    }

    @Override
    public void x(double x) {
        this.x = x;
    }

    public void defaultColor(int defaultColor) {
        this.defaultColor = defaultColor;
    }

    public int color() {
        return this.color;
    }

    @Override
    public void color(int color) {
        this.color = color;
        this.plot.pensDirty = true;
        if (this.plot.plotListener != null) {
            this.plot.plotListener.setPenColor(color);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    public boolean inLegend() {
        return this.inLegend;
    }

    public void inLegend(boolean inLegend) {
        this.inLegend = inLegend;
    }

    public void defaultInterval(double defaultInterval) {
        this.defaultInterval = defaultInterval;
    }

    public double interval() {
        return this.interval;
    }

    @Override
    public void interval(double interval) {
        this.interval = interval;
        if (this.plot.plotListener != null) {
            this.plot.plotListener.setInterval(interval);
        }
    }

    public boolean isDown() {
        return this.isDown;
    }

    @Override
    public void isDown(boolean isDown) {
        this.isDown = isDown;
        if (this.plot.plotListener != null) {
            this.plot.plotListener.penDown(isDown);
        }
    }

    public void defaultMode(int defaultMode) {
        this.defaultMode = defaultMode;
    }

    public int mode() {
        return this.mode;
    }

    @Override
    public void mode(int mode) {
        if (this.mode != mode) {
            this.penModeChanged(true);
            this.mode = mode;
            if (this.plot.plotListener != null) {
                this.plot.plotListener.plotPenMode(mode);
            }
        }
    }

    boolean penModeChanged() {
        return this.penModeChanged;
    }

    void penModeChanged(boolean penModeChanged) {
        this.penModeChanged = penModeChanged;
    }

    public void hardReset() {
        this.softReset();
        if (!this.temporary) {
            this.color = this.defaultColor;
            this.mode = this.defaultMode;
            this.interval = this.defaultInterval;
        }
    }

    public void plotListenerReset(boolean hardReset) {
        if (this.plot.plotListener != null) {
            this.plot.plotListener.resetPen(hardReset);
        }
    }

    public void softReset() {
        this.x = 0.0;
        this.isDown = true;
        this.points = new ArrayList<PlotPoint>();
    }

    public void plot(double y) {
        if (!this.points.isEmpty()) {
            this.x += this.interval;
        }
        this.plot(this.x, y);
    }

    public void plot(double x, double y) {
        this.x = x;
        this.points.add(new PlotPoint(x, y, this.isDown, this.color));
        if (this.isDown) {
            this.plot.perhapsGrowRanges(this, x, y);
        }
        if (this.plot.plotListener != null) {
            this.plot.plotListener.plot(x, y);
        }
    }

    @Override
    public void plot(double x, double y, int color, boolean isDown) {
        this.points.add(new PlotPoint(x, y, isDown, color));
    }
}

