/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.awt.Image;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.World;
import org.nlogo.render.Drawable;
import org.nlogo.render.LinkDrawer;
import org.nlogo.render.TopologyRenderer;

public strictfp class VertCylinderRenderer
extends TopologyRenderer {
    public VertCylinderRenderer(World world) {
        super(world);
    }

    void fillBackground(GraphicsInterface g) {
        if (this.worldAndViewPreMultipliedX != 0) {
            this.fillWith(g, RendererInterface.VIEW_BACKGROUND);
        }
    }

    void wrapDrawable(Drawable obj, GraphicsInterface g, double xcor, double ycor, double turtleSize, double cellSize) {
        double size = turtleSize * cellSize + obj.adjustSize(turtleSize, cellSize);
        double offset = size / 2.0;
        double x = this.graphicsX(xcor, cellSize) - offset;
        double y = this.graphicsY(ycor, cellSize) - offset;
        g.push();
        g.translate(x, y);
        this.draw(obj, g, x, y, 0.0, 0.0, size);
        if (x + size > (double)this.width) {
            this.draw(obj, g, x, y, this.width, 0.0, size);
        }
        if (x < 0.0) {
            this.draw(obj, g, x, y, -this.width, 0.0, size);
        }
        g.pop();
    }

    void paintAllPatchesBlack(GraphicsInterface g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, this.worldAndViewPreMultipliedY, this.width, this.height);
    }

    void paintViewImage(GraphicsInterface g, Image image) {
        super.paintViewImage(g, image);
        int x = this.worldAndViewPreMultipliedX;
        if (this.worldAndViewPreMultipliedX > 0) {
            x = this.worldAndViewPreMultipliedX - this.width;
        } else if (this.worldAndViewPreMultipliedX < 0) {
            x = this.worldAndViewPreMultipliedX + this.width;
        }
        if (x != 0) {
            g.drawImage(image, x, this.worldAndViewPreMultipliedY, this.width, this.height);
        }
    }

    void drawLink(GraphicsInterface g, Link link, LinkDrawer.LinkDrawable drawable, double patchSize, Color color, double lineThickness) {
        double x1 = this.graphicsX(link.x1(), patchSize);
        double y1 = this.graphicsY(link.y1(), patchSize);
        double x2 = this.graphicsX(link.x2(), patchSize);
        double y2 = this.graphicsY(link.y2(), patchSize);
        int lineWidth = (int)StrictMath.max(1.0, lineThickness * patchSize);
        g.setStroke(lineWidth);
        g.setColor(color);
        drawable.draw(g, link, color, x1, y1, x2, y2, patchSize, lineThickness);
        if (x2 + (double)lineWidth > (double)this.width) {
            drawable.draw(g, link, color, x1 - (double)this.width, y1, x2 - (double)this.width, y2, patchSize, lineThickness);
        }
        if (x2 - (double)lineWidth < 0.0) {
            drawable.draw(g, link, color, x1 + (double)this.width, y1, x2 + (double)this.width, y2, patchSize, lineThickness);
        }
    }

    void drawLine(GraphicsInterface g, double startX, double startY, double endX, double endY, double penSize) {
        double x1 = this.graphicsXNoOffset(startX, this.world.patchSize());
        double y1 = this.graphicsYNoOffset(startY, this.world.patchSize());
        double x2 = this.graphicsXNoOffset(endX, this.world.patchSize());
        double y2 = this.graphicsYNoOffset(endY, this.world.patchSize());
        double size = penSize / 2.0;
        g.drawLine(x1, y1, x2, y2);
        if (penSize > 1.0) {
            if (x2 + size > (double)this.width) {
                g.drawLine(x1 - (double)this.width, y1, x2 - (double)this.width, y2);
            }
            if (x1 - size < 0.0) {
                g.drawLine(x1 + (double)this.width, y1, x2 + (double)this.width, y2);
            }
        }
    }

    public double graphicsX(double xcor, double patchSize, double viewOffsetX) {
        return patchSize * (xcor - (double)this.world.minPxcor() + 0.5 - viewOffsetX);
    }
}

