/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm;

import java.util.Arrays;
import java.util.Comparator;
import org.nlogo.api.CompilerException;
import org.nlogo.api.CompilerServices;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Stock;
import org.nlogo.sdm.Translator$;
import scala.Function1;
import scala.StringBuilder;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator {
    private final String dt;
    private final ListBuffer<Converter> constantConverters;
    private final ListBuffer<Converter> converters;
    private final ListBuffer<Rate> rates;
    private final ListBuffer<Stock> stocks;
    private final CompilerServices compiler;

    public Translator(Model model, CompilerServices compiler) {
        this.compiler = compiler;
        this.stocks = new ListBuffer();
        this.rates = new ListBuffer();
        this.converters = new ListBuffer();
        this.constantConverters = new ListBuffer();
        this.dt = ((Object)BoxesRunTime.boxToDouble(model.dt())).toString();
        model.elements().filter((Function1<ModelElement, Boolean>)new $anonfun$1(this)).foreach(new $anonfun$2(this));
    }

    /*
     * WARNING - void declaration
     */
    public boolean isConstant(String s) {
        void var2_2;
        boolean exceptionResult1 = false;
        try {
            this.compiler.readFromString(s);
            exceptionResult1 = true;
        }
        catch (CompilerException compilerException) {
            exceptionResult1 = false;
        }
        return (boolean)var2_2;
    }

    public String updateStockExpression(Stock s$1) {
        ObjectRef expr$1 = new ObjectRef(new StringBuilder().append((Object)"  let new-").append((Object)s$1.name()).append((Object)(s$1.nonNegative() ? " max( list 0 ( " : " ( ")).append((Object)s$1.name()).append((Object)" ").toString());
        this.rates().foreach((Function1<Rate, Object>)new $anonfun$updateStockExpression$1(this, s$1, expr$1));
        if (s$1.nonNegative()) {
            expr$1.elem = new StringBuilder().append((Object)((String)expr$1.elem)).append((Object)") ").toString();
        }
        return new StringBuilder().append((Object)((String)expr$1.elem)).append((Object)")\n").toString();
    }

    public String initialValueExpressionForConverter(Converter c) {
        String string;
        return new StringBuilder().append((Object)"  set ").append((Object)c.name()).append((Object)" ").append((Object)((string = c.expression()) == null || string.equals(null) ? "0" : c.expression())).append((Object)"\n").toString();
    }

    public String initialValueExpressionForStock(Stock s) {
        String string;
        return new StringBuilder().append((Object)"  set ").append((Object)s.name()).append((Object)" ").append((Object)((string = s.initialValueExpression()) == null || string.equals(null) ? "0" : s.initialValueExpression())).append((Object)"\n").toString();
    }

    public String procedureForConverter(Converter c) {
        String string;
        return new StringBuilder().append((Object)";; Report value of variable\nto-report ").append((Object)c.name()).append((Object)"\n").append((Object)"  report ").append((Object)((string = c.expression()) == null || string.equals(null) ? "0" : c.expression())).append((Object)"\n").append((Object)"end\n\n").toString();
    }

    public final String org$nlogo$sdm$Translator$$procedureForRate(Rate r) {
        String string;
        return new StringBuilder().append((Object)";; Report value of flow\nto-report ").append((Object)r.name()).append((Object)"\n").append((Object)"  report ( ").append((Object)((string = r.expression()) == null || string.equals(null) ? "0" : r.expression())).append((Object)"\n  ) * ").append((Object)"dt").append((Object)"\n").append((Object)"end\n\n").toString();
    }

    public String source() {
        Object object = ScalaRunTime$.MODULE$.arrayValue(this.stocks().toArray(), Stock.class);
        Stock[] stockArray = (Stock[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Stock.class) : object);
        Arrays.sort((Object[])stockArray, new StockComparator());
        ObjectRef objectRef = new ObjectRef("");
        ObjectRef objectRef2 = new ObjectRef("");
        ObjectRef objectRef3 = new ObjectRef("");
        objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)";; System dynamics model globals\nglobals [\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)";; Initializes the system dynamics model.\n;; Call this in your model's SETUP procedure.\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)new StringBuilder().append((Object)"to system-dynamics-setup \n  reset-ticks\n  set dt ").append((Object)this.dt()).append((Object)"\n").toString()).toString();
        if (!this.constantConverters().isEmpty()) {
            objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)"  ;; constants\n").toString();
            objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"  ;; initialize constant values\n").toString();
            this.constantConverters().foreach((Function1<Converter, Object>)new $anonfun$source$1(this, objectRef, objectRef2));
        }
        if (!this.stocks().isEmpty()) {
            objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)"  ;; stock values\n").toString();
            objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"  ;; initialize stock values\n").toString();
            ScalaRunTime$.MODULE$.boxArray(stockArray).foreach(new $anonfun$source$2(this, objectRef, objectRef2));
        }
        objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)"  ;; size of each step, see SYSTEM-DYNAMICS-GO\n  dt\n").toString();
        objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)"]\n\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"end\n\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)";; Step through the system dynamics model by performing next iteration of Euler's method.\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)";; Call this in your model's GO procedure.\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"to system-dynamics-go\n").toString();
        objectRef3.elem = new StringBuilder().append((Object)((String)objectRef3.elem)).append((Object)";; Plot the current state of the system dynamics model's stocks\n").toString();
        objectRef3.elem = new StringBuilder().append((Object)((String)objectRef3.elem)).append((Object)";; Call this procedure in your model's GO procedure.\n").toString();
        objectRef3.elem = new StringBuilder().append((Object)((String)objectRef3.elem)).append((Object)"to system-dynamics-do-plot\n").toString();
        if (!this.converters().isEmpty() || !this.rates().isEmpty()) {
            objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"\n  ;; compute variable and flow values once per step\n").toString();
            this.converters().foreach((Function1<Converter, Object>)new $anonfun$source$3(this, objectRef2));
            this.rates().foreach((Function1<Rate, Object>)new $anonfun$source$4(this, objectRef2));
        }
        if (!this.stocks().isEmpty()) {
            objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"\n  ;; update stock values\n  ;; use temporary variables so order of computation doesn't affect result.\n").toString();
            ScalaRunTime$.MODULE$.boxArray(stockArray).foreach(new $anonfun$source$5(this, objectRef2, objectRef3));
            ScalaRunTime$.MODULE$.boxArray(stockArray).foreach(new $anonfun$source$6(this, objectRef2));
        }
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"\n  tick-advance dt\nend\n\n").toString();
        objectRef3.elem = new StringBuilder().append((Object)((String)objectRef3.elem)).append((Object)"end\n\n").toString();
        this.rates().foreach((Function1<Rate, Object>)new $anonfun$source$7(this, objectRef2));
        this.converters().foreach((Function1<Converter, Object>)new $anonfun$source$8(this, objectRef2));
        return new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)((String)objectRef2.elem)).append((Object)((String)objectRef3.elem)).toString();
    }

    public String dt() {
        return this.dt;
    }

    public ListBuffer<Converter> constantConverters() {
        return this.constantConverters;
    }

    public ListBuffer<Converter> converters() {
        return this.converters;
    }

    public ListBuffer<Rate> rates() {
        return this.rates;
    }

    public ListBuffer<Stock> stocks() {
        return this.stocks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StockComparator
    implements Comparator<Stock> {
        public StockComparator() {
            if (Translator.this == null) {
                throw new NullPointerException();
            }
        }

        public /* synthetic */ Translator org$nlogo$sdm$Translator$StockComparator$$$outer() {
            return Translator.this;
        }

        @Override
        public int compare(Stock s1, Stock s2) {
            String sname1 = s1.name().toUpperCase();
            String sname2 = s2.name().toUpperCase();
            String sexp1 = s1.initialValueExpression().toUpperCase();
            String sexp2 = s2.initialValueExpression().toUpperCase();
            return this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp1) ? (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp2) ? sname1.compareTo(sname2) : -1) : (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp2) ? 1 : sname1.compareTo(sname2));
        }
    }
}

