/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.util.StringTokenizer;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Element;

public strictfp class Line
extends Element
implements Cloneable {
    private Point start;
    private Point end;

    public Line(Point start, Point last, Color color) {
        super(color);
        this.start = start;
        this.end = last;
    }

    public void setFilled(boolean fill) {
    }

    public Object clone() {
        Line newLine = (Line)super.clone();
        newLine.start = (Point)newLine.start.clone();
        newLine.end = (Point)newLine.end.clone();
        return newLine;
    }

    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.getColor(turtleColor));
        g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
    }

    public String toString() {
        return "Line " + this.c.getRGB() + " " + this.marked + " " + this.start.x + " " + this.start.y + " " + this.end.x + " " + this.end.y;
    }

    public static Line parseLine(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text);
        tokenizer.nextToken();
        String color = tokenizer.nextToken();
        boolean b1 = Boolean.valueOf(tokenizer.nextToken());
        int x1 = Integer.valueOf(tokenizer.nextToken());
        int y1 = Integer.valueOf(tokenizer.nextToken());
        int x2 = Integer.valueOf(tokenizer.nextToken());
        int y2 = Integer.valueOf(tokenizer.nextToken());
        if (x1 == x2 && y1 == y2) {
            return null;
        }
        Line line = new Line(new Point(x1, y1), new Point(x2, y2), Color.decode(color));
        line.setMarked(b1);
        return line;
    }
}

